/*
 * Decompiled with CFR 0.152.
 */
package github.pitbox46.itemblacklist;

import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import github.pitbox46.itemblacklist.Config;
import github.pitbox46.itemblacklist.JsonUtils;
import github.pitbox46.itemblacklist.blacklist.Blacklist;
import github.pitbox46.itemblacklist.blacklist.ItemBanPredicate;
import github.pitbox46.itemblacklist.commands.ModCommands;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="itemblacklist")
public class ItemBlacklist {
    public static final Logger LOGGER = LogManager.getLogger();
    public static File BLACKLIST_FILE = null;
    public static Blacklist BLACKLIST = Blacklist.emptyBlacklist();
    public static JsonOps MODIFIED_JSON_OPS = new JsonOps(false){

        public <U> U convertTo(DynamicOps<U> outOps, JsonElement input) {
            if (input == null) {
                return (U)outOps.empty();
            }
            return (U)super.convertTo(outOps, input);
        }
    };

    public ItemBlacklist() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER, "itemblacklist.properties.toml");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        Path modFolder = event.getServer().m_129843_(new LevelResource("serverconfig"));
        BLACKLIST_FILE = JsonUtils.initialize(modFolder, "itemblacklist.json", (RegistryAccess)event.getServer().m_206579_());
        BLACKLIST = JsonUtils.readFromJson(BLACKLIST_FILE, (RegistryAccess)event.getServer().m_206579_());
    }

    @SubscribeEvent
    public void onServerSave(LevelEvent.Save event) {
        Level level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level && (level = (Level)levelAccessor).m_46472_() == level.m_7654_().m_129783_().m_46472_()) {
            JsonUtils.writeJson(BLACKLIST_FILE, BLACKLIST, event.getLevel().m_9598_());
        }
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinLevelEvent event) {
        if (((Boolean)Config.BAN_ITEM_ENTITY.get()).booleanValue() && Config.testBanRate() && event.getEntity() instanceof ItemEntity && ItemBlacklist.shouldDelete(((ItemEntity)event.getEntity()).m_32055_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        if (((Boolean)Config.BAN_ITEM_ENTITY.get()).booleanValue() && Config.testBanRate() && ItemBlacklist.shouldDelete(event.getItem().m_32055_(), event.getEntity())) {
            event.setCanceled(true);
            event.getItem().m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @SubscribeEvent
    public void onPlayerContainerOpen(PlayerContainerEvent event) {
        if (((Boolean)Config.BAN_CONTAINER.get()).booleanValue() && Config.testBanRate()) {
            for (int i = 0; i < event.getContainer().f_38839_.size(); ++i) {
                if (!ItemBlacklist.shouldDelete(event.getContainer().m_38853_(i).m_7993_(), event.getEntity())) continue;
                event.getContainer().m_38853_(i).m_5852_(ItemStack.f_41583_);
            }
        }
    }

    public static boolean shouldDelete(@Nullable ItemStack stack) {
        return ItemBlacklist.shouldDelete(stack, null);
    }

    public static boolean shouldDelete(@Nullable ItemStack stack, @Nullable Player player) {
        return BLACKLIST.shouldBan(stack, player);
    }

    public static String itemListToString(Collection<ItemBanPredicate> itemList) {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (ItemBanPredicate pred : itemList) {
            Set items = pred.itemPredicate().f_151427_;
            if (items == null) continue;
            builder.append(items).append(", ");
        }
        if (!itemList.isEmpty()) {
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append(']');
        return builder.toString();
    }
}

