/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.client.util.player;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerUtil {
    private static boolean isPlayerAboveGroundCachedResult = false;
    private static long lastPlayerAboveGroundCheckTime = -1L;

    public static boolean isPlayerAboveGround(LocalPlayer clientPlayerEntity) {
        if (System.currentTimeMillis() - lastPlayerAboveGroundCheckTime < 250L) {
            return isPlayerAboveGroundCachedResult;
        }
        lastPlayerAboveGroundCheckTime = System.currentTimeMillis();
        isPlayerAboveGroundCachedResult = PlayerUtil.isPlayerAboveGroundImpl(clientPlayerEntity);
        return isPlayerAboveGroundCachedResult;
    }

    private static boolean isPlayerAboveGroundImpl(@NotNull LocalPlayer clientPlayerEntity) {
        if (clientPlayerEntity.m_5842_()) {
            return true;
        }
        @Nullable ClientLevel clientWorld = clientPlayerEntity.f_108545_;
        if (clientWorld == null) {
            return true;
        }
        double x = clientPlayerEntity.m_20185_();
        double z = clientPlayerEntity.m_20189_();
        double y = clientPlayerEntity.m_20188_();
        int points = 10;
        int undergroundPoints = 0;
        for (int i = 0; i < points; ++i) {
            double dx = (Math.random() - 0.5) * 5.0;
            double dz = (Math.random() - 0.5) * 5.0;
            float topY = clientWorld.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, (int)(x + dx), (int)(z + dz));
            float seaLevel = (float)clientWorld.m_5736_() - 0.25f;
            if (!(y < (double)(topY = Math.max(topY, seaLevel))) || !(y < (double)seaLevel)) continue;
            ++undergroundPoints;
        }
        int topY = clientWorld.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, (int)x, (int)z);
        int seaLevel = clientWorld.m_5736_();
        if (y < (double)topY && y < (double)((float)seaLevel - 0.25f)) {
            ++undergroundPoints;
        }
        return (double)undergroundPoints < (double)points * 0.65;
    }
}

