/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.config;

import com.google.gson.GsonBuilder;
import dev.imb11.fog.client.FogClient;
import dev.imb11.fog.client.FogManager;
import dev.imb11.fog.client.util.FogConfigHelper;
import dev.imb11.mru.yacl.EntryType;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class FogConfig {
    private static final String CONFIG_FILE_NAME = "config";
    private static final String CONFIG_FILE_EXTENSION = "json";
    private static final ConfigClassHandler<FogConfig> HANDLER = ConfigClassHandler.createBuilder(FogConfig.class).id(ResourceLocation.m_214293_((String)"fog", (String)"config")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(FogClient.getConfigPath(CONFIG_FILE_NAME, CONFIG_FILE_EXTENSION)).appendGsonBuilder(GsonBuilder::setPrettyPrinting).build()).build();
    private static final FogConfigHelper HELPER = new FogConfigHelper("fog", "config");
    @SerialEntry
    public boolean disableMod = false;
    @SerialEntry
    @NotNull
    public List<String> disabledDimensions = List.of(String.format("%s:the_nether", "minecraft"));
    @SerialEntry
    public boolean disableRaininessEffect = false;
    @SerialEntry
    public boolean disableUndergroundFogMultiplier = false;
    @SerialEntry
    public boolean disableBiomeFogColour = false;
    @SerialEntry
    public boolean disableCloudWhitening = false;
    @SerialEntry
    public float initialFogStart = 0.1f;
    @SerialEntry
    public float initialFogEnd = 0.85f;
    @SerialEntry
    public float raininessTransitionSpeed = 0.005f;
    @SerialEntry
    public float undergroundnessTransitionSpeed = 0.005f;
    @SerialEntry
    public float fogStartTransitionSpeed = 0.005f;
    @SerialEntry
    public float fogEndTransitionSpeed = 0.005f;
    @SerialEntry
    public float darknessTransitionSpeed = 0.005f;
    @SerialEntry
    public float fogColorTransitionSpeed = 0.025f;
    @SerialEntry
    public float startMultiplierTransitionSpeed = 0.0075f;
    @SerialEntry
    public float endMultiplierTransitionSpeed = 0.0075f;

    @NotNull
    public static FogConfig getInstance() {
        return (FogConfig)HANDLER.instance();
    }

    public static void load() {
        HANDLER.load();
    }

    public static void save() {
        HANDLER.save();
    }

    @NotNull
    public YetAnotherConfigLib getYetAnotherConfigLibInstance() {
        return YetAnotherConfigLib.create(HANDLER, (defaults, config, builder) -> builder.title((Component)Component.m_237119_()).save(() -> {
            HANDLER.save();
            FogManager.INSTANCE = new FogManager();
        }).category(ConfigCategory.createBuilder().name(HELPER.getText(EntryType.CATEGORY_NAME, "fog_calculations")).option((Option)LabelOption.create((Component)HELPER.getText(EntryType.OPTION_NAME, "fog_calculations.warning"))).option(HELPER.getSlider("initial_fog_start", 0.0f, 1.0f, 0.05f, defaults.initialFogStart, () -> Float.valueOf(config.initialFogStart), val -> {
            config.initialFogStart = val.floatValue();
        })).option(HELPER.getSlider("initial_fog_end", 0.0f, 1.0f, 0.05f, defaults.initialFogEnd, () -> Float.valueOf(config.initialFogEnd), val -> {
            config.initialFogEnd = val.floatValue();
        })).option(HELPER.getFieldTDP("fog_start_transition_speed", 0.001f, 0.5f, defaults.fogStartTransitionSpeed, () -> Float.valueOf(config.fogStartTransitionSpeed), val -> {
            config.fogStartTransitionSpeed = val.floatValue();
        })).option(HELPER.getFieldTDP("fog_end_transition_speed", 0.001f, 0.5f, defaults.fogEndTransitionSpeed, () -> Float.valueOf(config.fogEndTransitionSpeed), val -> {
            config.fogEndTransitionSpeed = val.floatValue();
        })).option(HELPER.getFieldTDP("darkness_transition_speed", 0.001f, 0.5f, defaults.darknessTransitionSpeed, () -> Float.valueOf(config.darknessTransitionSpeed), val -> {
            config.darknessTransitionSpeed = val.floatValue();
        })).option(HELPER.getFieldTDP("fog_color_transition_speed", 0.001f, 0.5f, defaults.fogColorTransitionSpeed, () -> Float.valueOf(config.fogColorTransitionSpeed), val -> {
            config.fogColorTransitionSpeed = val.floatValue();
        })).option(HELPER.getFieldTDP("start_multiplier_transition_speed", 0.001f, 0.5f, defaults.startMultiplierTransitionSpeed, () -> Float.valueOf(config.startMultiplierTransitionSpeed), val -> {
            config.startMultiplierTransitionSpeed = val.floatValue();
        })).option(HELPER.getFieldTDP("end_multiplier_transition_speed", 0.001f, 0.5f, defaults.endMultiplierTransitionSpeed, () -> Float.valueOf(config.endMultiplierTransitionSpeed), val -> {
            config.endMultiplierTransitionSpeed = val.floatValue();
        })).option(HELPER.getFieldTDP("raininess_transition_speed", 0.001f, 0.5f, defaults.raininessTransitionSpeed, () -> Float.valueOf(config.raininessTransitionSpeed), val -> {
            config.raininessTransitionSpeed = val.floatValue();
        })).option(HELPER.getFieldTDP("undergroundness_transition_speed", 0.001f, 0.5f, defaults.undergroundnessTransitionSpeed, () -> Float.valueOf(config.undergroundnessTransitionSpeed), val -> {
            config.undergroundnessTransitionSpeed = val.floatValue();
        })).option(HELPER.get("disable_raininess_effect", defaults.disableRaininessEffect, () -> config.disableRaininessEffect, val -> {
            config.disableRaininessEffect = val;
        })).option(HELPER.get("disable_underground_fog_multiplier", defaults.disableUndergroundFogMultiplier, () -> config.disableUndergroundFogMultiplier, val -> {
            config.disableUndergroundFogMultiplier = val;
        })).option(HELPER.get("disable_biome_fog_colour", defaults.disableBiomeFogColour, () -> config.disableBiomeFogColour, val -> {
            config.disableBiomeFogColour = val;
        })).option(Option.createBuilder().name(HELPER.getText(EntryType.OPTION_NAME, "disable_cloud_whitening")).description(initialFogStart -> OptionDescription.createBuilder().text(new Component[]{HELPER.getText(EntryType.OPTION_DESCRIPTION, "disable_cloud_whitening")}).build()).binding((Object)defaults.disableCloudWhitening, () -> this.disableCloudWhitening, newDisableCloudWhitening -> {
            this.disableCloudWhitening = newDisableCloudWhitening;
        }).controller(BooleanControllerBuilder::create).available(!FogClient.isModInstalled("sodium")).build()).group((OptionGroup)ListOption.createBuilder().name((Component)Component.m_237115_((String)String.format("%s.config.option.disabled_dimensions", "fog"))).binding(this.disabledDimensions, () -> this.disabledDimensions, val -> {
            this.disabledDimensions = val;
        }).controller(StringControllerBuilder::create).initial((Object)"mod_id:dimension_id").build()).option(Option.createBuilder().name(HELPER.getText(EntryType.OPTION_NAME, "disable_mod")).description(initialFogStart -> OptionDescription.createBuilder().text(new Component[]{HELPER.getText(EntryType.OPTION_DESCRIPTION, "disable_mod")}).build()).binding((Object)defaults.disableMod, () -> this.disableMod, newDisableMod -> {
            this.disableMod = newDisableMod;
        }).controller(BooleanControllerBuilder::create).build()).build()));
    }
}

