/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.crafting;

import com.google.gson.JsonObject;
import com.simibubi.create.AllFluids;
import com.simibubi.create.content.fluids.potion.PotionFluid;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.registry.BnCRecipeSerializers;
import umpaz.brewinandchewin.common.utility.KegRecipeWrapper;

public class CreatePotionPouringRecipe
extends KegPouringRecipe {
    public CreatePotionPouringRecipe(ResourceLocation id, Optional<ItemStack> container, int amount) {
        super(id, ((PotionFluid)AllFluids.POTION.get()).m_5613_(), container, Items.f_42589_.m_7968_(), amount, false, true);
    }

    @Override
    public ItemStack assemble(KegRecipeWrapper recipeWrapper, RegistryAccess registryAccess) {
        Potion potion;
        ItemStack stack = new ItemStack((ItemLike)Items.f_42589_);
        FluidStack fluidStack = recipeWrapper.getFluid(0);
        if (fluidStack.getTag() != null && (potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(fluidStack.getTag().m_128461_("Potion")))) != null) {
            PotionUtils.m_43549_((ItemStack)stack, (Potion)potion);
        }
        return stack;
    }

    @Override
    public FluidStack getFluid(ItemStack container) {
        FluidStack fluidStack = super.getFluid(container);
        Potion potion = PotionUtils.m_43579_((ItemStack)container);
        PotionFluid.addPotionToFluidStack((FluidStack)fluidStack, (Potion)potion);
        return fluidStack;
    }

    @Override
    public boolean hasSpecialFluid() {
        return true;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)BnCRecipeSerializers.CREATE_POTION_POURING.get();
    }

    public static class Serializer
    implements RecipeSerializer<CreatePotionPouringRecipe> {
        public CreatePotionPouringRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int amountIn = GsonHelper.m_13824_((JsonObject)json, (String)"amount", (int)250);
            Optional<ItemStack> containerIn = GsonHelper.m_13900_((JsonObject)json, (String)"container") ? Optional.of(CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"container"), (boolean)true)) : Optional.empty();
            return new CreatePotionPouringRecipe(recipeId, containerIn, amountIn);
        }

        @Nullable
        public CreatePotionPouringRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int amountIn = buffer.m_130242_();
            Optional containerIn = buffer.m_236860_(FriendlyByteBuf::m_130267_);
            return new CreatePotionPouringRecipe(recipeId, containerIn, amountIn);
        }

        public void toNetwork(FriendlyByteBuf buffer, CreatePotionPouringRecipe recipe) {
            buffer.m_130130_(recipe.getAmount());
            buffer.m_236835_(recipe.getRawContainer(), FriendlyByteBuf::m_130055_);
        }
    }
}

