/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.integration.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.crafting.KegFermentingRecipe;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.registry.BnCItems;
import umpaz.brewinandchewin.common.registry.BnCMenuTypes;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.integration.emi.BnCRecipeCategories;
import umpaz.brewinandchewin.integration.emi.BnCRecipeWorkstations;
import umpaz.brewinandchewin.integration.emi.handler.KegEmiRecipeHandler;
import umpaz.brewinandchewin.integration.emi.recipe.CheeseEmiRecipe;
import umpaz.brewinandchewin.integration.emi.recipe.FermentingEmiRecipe;
import umpaz.brewinandchewin.integration.emi.recipe.PouringEmiRecipe;

@EmiEntrypoint
public class EMIPlugin
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        registry.addCategory(BnCRecipeCategories.FERMENTING);
        registry.addCategory(BnCRecipeCategories.POURING);
        registry.addCategory(BnCRecipeCategories.AGING);
        registry.addWorkstation(BnCRecipeCategories.FERMENTING, (EmiIngredient)BnCRecipeWorkstations.KEG);
        registry.addWorkstation(BnCRecipeCategories.POURING, (EmiIngredient)BnCRecipeWorkstations.KEG);
        registry.addRecipeHandler((MenuType)BnCMenuTypes.KEG.get(), (EmiRecipeHandler)new KegEmiRecipeHandler());
        for (KegFermentingRecipe kegFermentingRecipe : registry.getRecipeManager().m_44013_((RecipeType)BnCRecipeTypes.FERMENTING.get())) {
            if (kegFermentingRecipe.getResultFluid() != null) {
                registry.addRecipe((EmiRecipe)new FermentingEmiRecipe(kegFermentingRecipe.m_6423_(), kegFermentingRecipe.m_7527_().stream().map(EmiIngredient::of).toList(), this.getFluidItemIngredients(registry.getRecipeManager(), kegFermentingRecipe), this.getFluidIngredient(kegFermentingRecipe), EmiStack.of((Fluid)kegFermentingRecipe.getResultFluid(), (long)kegFermentingRecipe.getAmount()), kegFermentingRecipe.getTemperature(), kegFermentingRecipe.getFermentTime(), kegFermentingRecipe.getExperience()));
                continue;
            }
            registry.addRecipe((EmiRecipe)new FermentingEmiRecipe(kegFermentingRecipe.m_6423_(), kegFermentingRecipe.m_7527_().stream().map(EmiIngredient::of).toList(), this.getFluidItemIngredients(registry.getRecipeManager(), kegFermentingRecipe), this.getFluidIngredient(kegFermentingRecipe), EmiStack.of((ItemStack)kegFermentingRecipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_())), kegFermentingRecipe.getTemperature(), kegFermentingRecipe.getFermentTime(), kegFermentingRecipe.getExperience()));
        }
        for (KegPouringRecipe kegPouringRecipe : registry.getRecipeManager().m_44013_((RecipeType)BnCRecipeTypes.KEG_POURING.get()).stream().filter(pouringRecipe -> !pouringRecipe.hasSpecialFluid()).toList()) {
            registry.addRecipe((EmiRecipe)new PouringEmiRecipe(kegPouringRecipe.m_6423_(), (EmiIngredient)EmiStack.of((Fluid)kegPouringRecipe.getRawFluid(), (long)kegPouringRecipe.getAmount()), EmiStack.of((ItemStack)kegPouringRecipe.getContainer()), EmiStack.of((ItemStack)kegPouringRecipe.getOutput())));
        }
        registry.addRecipe((EmiRecipe)new CheeseEmiRecipe(BrewinAndChewin.asResource("/cheese/flaxen"), EmiStack.of((ItemLike)((ItemLike)BnCItems.UNRIPE_FLAXEN_CHEESE_WHEEL.get())), EmiStack.of((ItemLike)((ItemLike)BnCItems.FLAXEN_CHEESE_WHEEL.get()))));
        registry.addRecipe((EmiRecipe)new CheeseEmiRecipe(BrewinAndChewin.asResource("/cheese/scarlet"), EmiStack.of((ItemLike)((ItemLike)BnCItems.UNRIPE_SCARLET_CHEESE_WHEEL.get())), EmiStack.of((ItemLike)((ItemLike)BnCItems.SCARLET_CHEESE_WHEEL.get()))));
    }

    private EmiIngredient getFluidIngredient(KegFermentingRecipe recipe) {
        if (recipe.getFluidIngredient() == null) {
            return null;
        }
        return EmiStack.of((Fluid)recipe.getFluidIngredient().getFluid(), (CompoundTag)recipe.getFluidIngredient().getTag(), (long)recipe.getFluidIngredient().getAmount());
    }

    private EmiIngredient getFluidItemIngredients(RecipeManager recipes, KegFermentingRecipe recipe) {
        if (recipe.getFluidIngredient() == null) {
            return null;
        }
        int fluidAmount = recipe.getFluidIngredient().getAmount();
        return EmiIngredient.of(recipes.m_44013_((RecipeType)BnCRecipeTypes.KEG_POURING.get()).stream().filter(recipe1 -> recipe.getFluidIngredient().getFluid().m_6212_(recipe1.getRawFluid())).map(holder -> {
            ItemStack stack = holder.getOutput();
            stack = stack.m_255036_(fluidAmount / holder.getAmount());
            return EmiStack.of((ItemStack)stack);
        }).toList());
    }
}

