/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi;

import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiInitRegistry;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiRecipeSorting;
import dev.emi.emi.api.recipe.EmiWorldInteractionRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiRegistryAdapter;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.FluidEmiStack;
import dev.emi.emi.api.stack.ItemEmiStack;
import dev.emi.emi.api.stack.ListEmiIngredient;
import dev.emi.emi.api.stack.TagEmiIngredient;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.config.EffectLocation;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.config.FluidUnit;
import dev.emi.emi.handler.CookingRecipeHandler;
import dev.emi.emi.handler.CraftingRecipeHandler;
import dev.emi.emi.handler.InventoryRecipeHandler;
import dev.emi.emi.handler.StonecuttingRecipeHandler;
import dev.emi.emi.mixin.accessor.AxeItemAccessor;
import dev.emi.emi.mixin.accessor.HandledScreenAccessor;
import dev.emi.emi.mixin.accessor.HoeItemAccessor;
import dev.emi.emi.mixin.accessor.ShovelItemAccessor;
import dev.emi.emi.mixin.accessor.SmithingTransformRecipeAccessor;
import dev.emi.emi.mixin.accessor.SmithingTrimRecipeAccessor;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.platform.EmiClient;
import dev.emi.emi.recipe.EmiAnvilRecipe;
import dev.emi.emi.recipe.EmiCompostingRecipe;
import dev.emi.emi.recipe.EmiCookingRecipe;
import dev.emi.emi.recipe.EmiFuelRecipe;
import dev.emi.emi.recipe.EmiGrindstoneRecipe;
import dev.emi.emi.recipe.EmiShapedRecipe;
import dev.emi.emi.recipe.EmiShapelessRecipe;
import dev.emi.emi.recipe.EmiSmithingRecipe;
import dev.emi.emi.recipe.EmiStonecuttingRecipe;
import dev.emi.emi.recipe.EmiTagRecipe;
import dev.emi.emi.recipe.special.EmiAnvilEnchantRecipe;
import dev.emi.emi.recipe.special.EmiAnvilRepairItemRecipe;
import dev.emi.emi.recipe.special.EmiArmorDyeRecipe;
import dev.emi.emi.recipe.special.EmiBannerDuplicateRecipe;
import dev.emi.emi.recipe.special.EmiBannerShieldRecipe;
import dev.emi.emi.recipe.special.EmiBookCloningRecipe;
import dev.emi.emi.recipe.special.EmiFireworkRocketRecipe;
import dev.emi.emi.recipe.special.EmiFireworkStarFadeRecipe;
import dev.emi.emi.recipe.special.EmiFireworkStarRecipe;
import dev.emi.emi.recipe.special.EmiGrindstoneDisenchantingBookRecipe;
import dev.emi.emi.recipe.special.EmiGrindstoneDisenchantingRecipe;
import dev.emi.emi.recipe.special.EmiMapCloningRecipe;
import dev.emi.emi.recipe.special.EmiRepairItemRecipe;
import dev.emi.emi.recipe.special.EmiSmithingTrimRecipe;
import dev.emi.emi.recipe.special.EmiSuspiciousStewRecipe;
import dev.emi.emi.registry.EmiTags;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.runtime.EmiLog;
import dev.emi.emi.runtime.EmiReloadLog;
import dev.emi.emi.stack.serializer.FluidEmiStackSerializer;
import dev.emi.emi.stack.serializer.ItemEmiStackSerializer;
import dev.emi.emi.stack.serializer.ListEmiIngredientSerializer;
import dev.emi.emi.stack.serializer.TagEmiIngredientSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.ArmorDyeRecipe;
import net.minecraft.world.item.crafting.BannerDuplicateRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.BookCloningRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.FireworkRocketRecipe;
import net.minecraft.world.item.crafting.FireworkStarFadeRecipe;
import net.minecraft.world.item.crafting.FireworkStarRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.MapCloningRecipe;
import net.minecraft.world.item.crafting.MapExtendingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.RepairItemRecipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.ShieldDecorationRecipe;
import net.minecraft.world.item.crafting.ShulkerBoxColoring;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.item.crafting.SuspiciousStewRecipe;
import net.minecraft.world.item.crafting.TippedArrowRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

@EmiEntrypoint
public class VanillaPlugin
implements EmiPlugin {
    public static EmiRecipeCategory TAG = new EmiRecipeCategory(EmiPort.id("emi:tag"), EmiStack.of((ItemLike)Items.f_42656_), VanillaPlugin.simplifiedRenderer(240, 208), EmiRecipeSorting.none());
    public static EmiRecipeCategory INGREDIENT = new EmiRecipeCategory(EmiPort.id("emi:ingredient"), EmiStack.of((ItemLike)Items.f_42522_), VanillaPlugin.simplifiedRenderer(240, 208));
    public static EmiRecipeCategory RESOLUTION = new EmiRecipeCategory(EmiPort.id("emi:resolution"), EmiStack.of((ItemLike)Items.f_42522_), VanillaPlugin.simplifiedRenderer(240, 208));

    @Override
    public void initialize(EmiInitRegistry registry) {
        registry.addIngredientSerializer(ItemEmiStack.class, new ItemEmiStackSerializer());
        registry.addIngredientSerializer(FluidEmiStack.class, new FluidEmiStackSerializer());
        registry.addIngredientSerializer(TagEmiIngredient.class, new TagEmiIngredientSerializer());
        registry.addIngredientSerializer(ListEmiIngredient.class, new ListEmiIngredientSerializer());
        registry.addRegistryAdapter(EmiRegistryAdapter.simple(Item.class, EmiPort.getItemRegistry(), EmiStack::of));
        registry.addRegistryAdapter(EmiRegistryAdapter.simple(Fluid.class, EmiPort.getFluidRegistry(), EmiStack::of));
    }

    @Override
    public void register(EmiRegistry registry) {
        registry.addCategory(VanillaEmiRecipeCategories.CRAFTING);
        registry.addCategory(VanillaEmiRecipeCategories.SMELTING);
        registry.addCategory(VanillaEmiRecipeCategories.BLASTING);
        registry.addCategory(VanillaEmiRecipeCategories.SMOKING);
        registry.addCategory(VanillaEmiRecipeCategories.CAMPFIRE_COOKING);
        registry.addCategory(VanillaEmiRecipeCategories.STONECUTTING);
        registry.addCategory(VanillaEmiRecipeCategories.SMITHING);
        registry.addCategory(VanillaEmiRecipeCategories.ANVIL_REPAIRING);
        registry.addCategory(VanillaEmiRecipeCategories.GRINDING);
        registry.addCategory(VanillaEmiRecipeCategories.BREWING);
        registry.addCategory(VanillaEmiRecipeCategories.WORLD_INTERACTION);
        registry.addCategory(VanillaEmiRecipeCategories.FUEL);
        registry.addCategory(VanillaEmiRecipeCategories.COMPOSTING);
        registry.addCategory(VanillaEmiRecipeCategories.INFO);
        registry.addCategory(TAG);
        registry.addCategory(INGREDIENT);
        registry.addCategory(RESOLUTION);
        registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, EmiStack.of((ItemLike)Items.f_41960_));
        registry.addWorkstation(VanillaEmiRecipeCategories.SMELTING, EmiStack.of((ItemLike)Items.f_41962_));
        registry.addWorkstation(VanillaEmiRecipeCategories.BLASTING, EmiStack.of((ItemLike)Items.f_42770_));
        registry.addWorkstation(VanillaEmiRecipeCategories.SMOKING, EmiStack.of((ItemLike)Items.f_42769_));
        registry.addWorkstation(VanillaEmiRecipeCategories.CAMPFIRE_COOKING, EmiStack.of((ItemLike)Items.f_42781_));
        registry.addWorkstation(VanillaEmiRecipeCategories.CAMPFIRE_COOKING, EmiStack.of((ItemLike)Items.f_42782_));
        registry.addWorkstation(VanillaEmiRecipeCategories.STONECUTTING, EmiStack.of((ItemLike)Items.f_42776_));
        registry.addWorkstation(VanillaEmiRecipeCategories.SMITHING, EmiStack.of((ItemLike)Items.f_42775_));
        registry.addWorkstation(VanillaEmiRecipeCategories.ANVIL_REPAIRING, EmiStack.of((ItemLike)Items.f_42146_));
        registry.addWorkstation(VanillaEmiRecipeCategories.ANVIL_REPAIRING, EmiStack.of((ItemLike)Items.f_42147_));
        registry.addWorkstation(VanillaEmiRecipeCategories.ANVIL_REPAIRING, EmiStack.of((ItemLike)Items.f_42148_));
        registry.addWorkstation(VanillaEmiRecipeCategories.BREWING, EmiStack.of((ItemLike)Items.f_42543_));
        registry.addWorkstation(VanillaEmiRecipeCategories.GRINDING, EmiStack.of((ItemLike)Items.f_42773_));
        registry.addWorkstation(VanillaEmiRecipeCategories.COMPOSTING, EmiStack.of((ItemLike)Items.f_42726_));
        registry.addRecipeHandler(null, new InventoryRecipeHandler());
        registry.addRecipeHandler(MenuType.f_39968_, new CraftingRecipeHandler());
        registry.addRecipeHandler(MenuType.f_39970_, new CookingRecipeHandler(VanillaEmiRecipeCategories.SMELTING));
        registry.addRecipeHandler(MenuType.f_39966_, new CookingRecipeHandler(VanillaEmiRecipeCategories.BLASTING));
        registry.addRecipeHandler(MenuType.f_39978_, new CookingRecipeHandler(VanillaEmiRecipeCategories.SMOKING));
        registry.addRecipeHandler(MenuType.f_39980_, new StonecuttingRecipeHandler());
        registry.addExclusionArea(CreativeModeInventoryScreen.class, (screen, consumer) -> {
            int left = ((HandledScreenAccessor)screen).getX();
            int top = ((HandledScreenAccessor)screen).getY();
            int width = ((HandledScreenAccessor)screen).getBackgroundWidth();
            int bottom = top + ((HandledScreenAccessor)screen).getBackgroundHeight();
            consumer.accept(new Bounds(left, top - 28, width, 28));
            consumer.accept(new Bounds(left, bottom, width, 28));
        });
        registry.addGenericExclusionArea((screen, consumer) -> {
            if (EmiConfig.effectLocation != EffectLocation.HIDDEN && screen instanceof EffectRenderingInventoryScreen) {
                EffectRenderingInventoryScreen inv = (EffectRenderingInventoryScreen)screen;
                Minecraft client = Minecraft.m_91087_();
                Collection collection = client.f_91074_.m_21220_();
                if (!collection.isEmpty()) {
                    int right;
                    int rightWidth;
                    int k = 33;
                    if (collection.size() > 5) {
                        k = 132 / (collection.size() - 1);
                    }
                    if ((rightWidth = inv.f_96543_ - (right = ((HandledScreenAccessor)inv).getX() + ((HandledScreenAccessor)inv).getBackgroundWidth() + 2)) >= 32) {
                        int left;
                        int width;
                        int top = ((HandledScreenAccessor)inv).getY();
                        int height = (collection.size() - 1) * k + 32;
                        if (EmiConfig.effectLocation == EffectLocation.TOP) {
                            int size = collection.size();
                            top = ((HandledScreenAccessor)inv).getY() - 34;
                            if (screen instanceof CreativeModeInventoryScreen) {
                                top -= 28;
                                if (EmiAgnos.isForge()) {
                                    top -= 22;
                                }
                            }
                            int xOff = 34;
                            if (size == 1) {
                                xOff = 122;
                            } else if (size > 5) {
                                xOff = (((HandledScreenAccessor)inv).getBackgroundWidth() - 32) / (size - 1);
                            }
                            width = Math.max(122, (size - 1) * xOff + 32);
                            left = ((HandledScreenAccessor)inv).getX() + (((HandledScreenAccessor)inv).getBackgroundWidth() - width) / 2;
                            height = 32;
                        } else {
                            left = switch (EmiConfig.effectLocation) {
                                case EffectLocation.LEFT_COMPRESSED -> ((HandledScreenAccessor)inv).getX() - 2 - 32;
                                case EffectLocation.LEFT -> ((HandledScreenAccessor)inv).getX() - 2 - 120;
                                default -> right;
                            };
                            width = switch (EmiConfig.effectLocation) {
                                case EffectLocation.LEFT, EffectLocation.RIGHT -> 120;
                                case EffectLocation.LEFT_COMPRESSED, EffectLocation.RIGHT_COMPRESSED -> 32;
                                default -> 32;
                            };
                        }
                        consumer.accept(new Bounds(left, top, width, height));
                    }
                }
            }
        });
        Comparison potionComparison = Comparison.compareData(stack -> PotionUtils.m_43577_((CompoundTag)stack.getNbt()));
        registry.setDefaultComparison((Object)Items.f_42589_, potionComparison);
        registry.setDefaultComparison((Object)Items.f_42736_, potionComparison);
        registry.setDefaultComparison((Object)Items.f_42739_, potionComparison);
        registry.setDefaultComparison((Object)Items.f_42738_, potionComparison);
        registry.setDefaultComparison((Object)Items.f_42690_, EmiPort.compareStrict());
        Set hiddenItems = Stream.concat(EmiUtil.values(TagKey.m_203882_((ResourceKey)EmiPort.getItemRegistry().m_123023_(), (ResourceLocation)EmiTags.HIDDEN_FROM_RECIPE_VIEWERS)).map(Holder::m_203334_), EmiPort.getDisabledItems()).collect(Collectors.toSet());
        List dyeableItems = EmiPort.getItemRegistry().m_123024_().filter(i -> i instanceof DyeableLeatherItem).collect(Collectors.toList());
        for (CraftingRecipe craftingRecipe : VanillaPlugin.getRecipes(registry, RecipeType.f_44107_)) {
            ResourceLocation id = EmiPort.getId(craftingRecipe);
            if (craftingRecipe instanceof MapExtendingRecipe) {
                MapExtendingRecipe map = (MapExtendingRecipe)craftingRecipe;
                EmiStack paper = EmiStack.of((ItemLike)Items.f_42516_);
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiCraftingRecipe(List.of(paper, paper, paper, paper, EmiStack.of((ItemLike)Items.f_42573_), paper, paper, paper, paper), EmiStack.of((ItemLike)Items.f_42573_), id, false), craftingRecipe);
                continue;
            }
            if (craftingRecipe instanceof ShapedRecipe) {
                ShapedRecipe shaped = (ShapedRecipe)craftingRecipe;
                if (craftingRecipe.m_8004_(3, 3)) {
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiShapedRecipe(shaped), craftingRecipe);
                    continue;
                }
            }
            if (craftingRecipe instanceof ShapelessRecipe) {
                ShapelessRecipe shapeless = (ShapelessRecipe)craftingRecipe;
                if (craftingRecipe.m_8004_(3, 3)) {
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiShapelessRecipe(shapeless), craftingRecipe);
                    continue;
                }
            }
            if (craftingRecipe instanceof ArmorDyeRecipe) {
                ArmorDyeRecipe dye = (ArmorDyeRecipe)craftingRecipe;
                for (Item i2 : dyeableItems) {
                    if (hiddenItems.contains(i2)) continue;
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiArmorDyeRecipe(i2, VanillaPlugin.synthetic("crafting/dying", EmiUtil.subId(i2))), craftingRecipe);
                }
                continue;
            }
            if (craftingRecipe instanceof SuspiciousStewRecipe) {
                SuspiciousStewRecipe stew = (SuspiciousStewRecipe)craftingRecipe;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiSuspiciousStewRecipe(id), craftingRecipe);
                continue;
            }
            if (craftingRecipe instanceof ShulkerBoxColoring) {
                ShulkerBoxColoring shulker = (ShulkerBoxColoring)craftingRecipe;
                for (DyeColor dye : DyeColor.values()) {
                    DyeItem dyeItem = DyeItem.m_41082_((DyeColor)dye);
                    ResourceLocation sid = VanillaPlugin.synthetic("crafting/shulker_box_dying", EmiUtil.subId((Item)dyeItem));
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiCraftingRecipe(List.of(EmiStack.of((ItemLike)Items.f_42265_), EmiStack.of((ItemLike)dyeItem)), EmiStack.of(ShulkerBoxBlock.m_56250_((DyeColor)dye)), sid), craftingRecipe);
                }
                continue;
            }
            if (craftingRecipe instanceof ShieldDecorationRecipe) {
                ShieldDecorationRecipe shield = (ShieldDecorationRecipe)craftingRecipe;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiBannerShieldRecipe(id), craftingRecipe);
                continue;
            }
            if (craftingRecipe instanceof BookCloningRecipe) {
                BookCloningRecipe book = (BookCloningRecipe)craftingRecipe;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiBookCloningRecipe(id), craftingRecipe);
                continue;
            }
            if (craftingRecipe instanceof TippedArrowRecipe) {
                TippedArrowRecipe tipped = (TippedArrowRecipe)craftingRecipe;
                EmiPort.getPotionRegistry().m_203611_().forEach(entry -> {
                    if (entry.m_203334_() == Potions.f_43598_) {
                        return;
                    }
                    EmiStack arrow = EmiStack.of((ItemLike)Items.f_42412_);
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiCraftingRecipe(List.of(arrow, arrow, arrow, arrow, EmiStack.of(EmiPort.setPotion(new ItemStack((ItemLike)Items.f_42739_), (Potion)entry.m_203334_())), arrow, arrow, arrow, arrow), EmiStack.of(EmiPort.setPotion(new ItemStack((ItemLike)Items.f_42738_, 8), (Potion)entry.m_203334_())), VanillaPlugin.synthetic("crafting/tipped_arrow", EmiUtil.subId(EmiPort.getPotionRegistry().m_7981_((Object)((Potion)entry.m_203334_())))), false), recipe);
                });
                continue;
            }
            if (craftingRecipe instanceof FireworkStarRecipe) {
                FireworkStarRecipe star = (FireworkStarRecipe)craftingRecipe;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiFireworkStarRecipe(id), craftingRecipe);
                continue;
            }
            if (craftingRecipe instanceof FireworkStarFadeRecipe) {
                FireworkStarFadeRecipe star = (FireworkStarFadeRecipe)craftingRecipe;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiFireworkStarFadeRecipe(id), craftingRecipe);
                continue;
            }
            if (craftingRecipe instanceof FireworkRocketRecipe) {
                FireworkRocketRecipe rocket = (FireworkRocketRecipe)craftingRecipe;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiFireworkRocketRecipe(id), craftingRecipe);
                continue;
            }
            if (craftingRecipe instanceof BannerDuplicateRecipe) {
                BannerDuplicateRecipe banner = (BannerDuplicateRecipe)craftingRecipe;
                for (Item i3 : EmiBannerDuplicateRecipe.BANNERS) {
                    if (hiddenItems.contains(i3)) continue;
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiBannerDuplicateRecipe(i3, VanillaPlugin.synthetic("crafting/banner_copying", EmiUtil.subId(i3))), craftingRecipe);
                }
                continue;
            }
            if (craftingRecipe instanceof RepairItemRecipe) {
                RepairItemRecipe tool = (RepairItemRecipe)craftingRecipe;
                for (Item i4 : EmiRepairItemRecipe.TOOLS) {
                    if (hiddenItems.contains(i4)) continue;
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiRepairItemRecipe(i4, VanillaPlugin.synthetic("crafting/repairing", EmiUtil.subId(i4))), craftingRecipe);
                }
                continue;
            }
            if (craftingRecipe instanceof MapCloningRecipe) {
                MapCloningRecipe map = (MapCloningRecipe)craftingRecipe;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiMapCloningRecipe(id), craftingRecipe);
                continue;
            }
            if (craftingRecipe instanceof CustomRecipe) continue;
            try {
                ArrayList input;
                boolean shapeless;
                if (craftingRecipe.m_7527_().isEmpty() || EmiPort.getOutput(craftingRecipe).m_41619_() || !craftingRecipe.m_8004_(3, 3)) continue;
                boolean bl = shapeless = craftingRecipe.m_8004_(1, craftingRecipe.m_7527_().size()) && craftingRecipe.m_8004_(craftingRecipe.m_7527_().size(), 1);
                if (shapeless) {
                    input = craftingRecipe.m_7527_().stream().map(EmiIngredient::of).toList();
                } else {
                    int width = craftingRecipe.m_8004_(2, 3) ? (craftingRecipe.m_8004_(1, 3) ? 1 : 2) : 3;
                    input = Lists.newArrayList();
                    for (int i5 = 0; i5 < craftingRecipe.m_7527_().size(); ++i5) {
                        input.add(EmiIngredient.of((Ingredient)craftingRecipe.m_7527_().get(i5)));
                        if ((i5 + 1) % width != 0) continue;
                        for (int j = width; j < 3; ++j) {
                            input.add(EmiStack.EMPTY);
                        }
                    }
                }
                EmiShapedRecipe.setRemainders(input, craftingRecipe);
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiCraftingRecipe(input, EmiStack.of(EmiPort.getOutput(recipe)), id, shapeless));
            }
            catch (Exception e) {
                EmiReloadLog.warn("Exception when parsing vanilla crafting recipe " + String.valueOf(id), e);
            }
        }
        for (SmeltingRecipe smeltingRecipe : VanillaPlugin.getRecipes(registry, RecipeType.f_44108_)) {
            VanillaPlugin.addRecipeSafe(registry, () -> new EmiCookingRecipe((AbstractCookingRecipe)smeltingRecipe, VanillaEmiRecipeCategories.SMELTING, 1, false), smeltingRecipe);
        }
        for (BlastingRecipe blastingRecipe : VanillaPlugin.getRecipes(registry, RecipeType.f_44109_)) {
            VanillaPlugin.addRecipeSafe(registry, () -> new EmiCookingRecipe((AbstractCookingRecipe)blastingRecipe, VanillaEmiRecipeCategories.BLASTING, 2, false), blastingRecipe);
        }
        for (SmokingRecipe smokingRecipe : VanillaPlugin.getRecipes(registry, RecipeType.f_44110_)) {
            VanillaPlugin.addRecipeSafe(registry, () -> new EmiCookingRecipe((AbstractCookingRecipe)smokingRecipe, VanillaEmiRecipeCategories.SMOKING, 2, false), smokingRecipe);
        }
        for (CampfireCookingRecipe campfireCookingRecipe : VanillaPlugin.getRecipes(registry, RecipeType.f_44111_)) {
            VanillaPlugin.addRecipeSafe(registry, () -> new EmiCookingRecipe((AbstractCookingRecipe)campfireCookingRecipe, VanillaEmiRecipeCategories.CAMPFIRE_COOKING, 1, true), campfireCookingRecipe);
        }
        for (SmithingRecipe smithingRecipe : VanillaPlugin.getRecipes(registry, RecipeType.f_44113_)) {
            Minecraft client = Minecraft.m_91087_();
            if (smithingRecipe instanceof SmithingTransformRecipeAccessor) {
                SmithingTransformRecipeAccessor stra = (SmithingTransformRecipeAccessor)smithingRecipe;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiSmithingRecipe(EmiIngredient.of(stra.getTemplate()), EmiIngredient.of(stra.getBase()), EmiIngredient.of(stra.getAddition()), EmiStack.of(EmiPort.getOutput(smithingRecipe)), EmiPort.getId(smithingRecipe)), smithingRecipe);
                continue;
            }
            if (!(smithingRecipe instanceof SmithingTrimRecipeAccessor)) continue;
            SmithingTrimRecipeAccessor stra = (SmithingTrimRecipeAccessor)smithingRecipe;
            VanillaPlugin.addRecipeSafe(registry, () -> new EmiSmithingTrimRecipe(EmiIngredient.of(stra.getTemplate()), EmiIngredient.of(stra.getBase()), EmiIngredient.of(stra.getAddition()), EmiStack.of(EmiPort.getOutput(smithingRecipe)), smithingRecipe), smithingRecipe);
        }
        for (StonecutterRecipe stonecutterRecipe : VanillaPlugin.getRecipes(registry, RecipeType.f_44112_)) {
            VanillaPlugin.addRecipeSafe(registry, () -> new EmiStonecuttingRecipe(stonecutterRecipe), stonecutterRecipe);
        }
        VanillaPlugin.safely("repair", () -> VanillaPlugin.addRepair(registry, hiddenItems));
        VanillaPlugin.safely("brewing", () -> EmiAgnos.addBrewingRecipes(registry));
        VanillaPlugin.safely("world interaction", () -> VanillaPlugin.addWorldInteraction(registry, hiddenItems, dyeableItems));
        VanillaPlugin.safely("fuel", () -> VanillaPlugin.addFuel(registry, hiddenItems));
        VanillaPlugin.safely("composting", () -> VanillaPlugin.addComposting(registry, hiddenItems));
        for (TagKey tagKey : EmiTags.TAGS) {
            if (new TagEmiIngredient(tagKey, 1L).getEmiStacks().size() <= 1) continue;
            VanillaPlugin.addRecipeSafe(registry, () -> new EmiTagRecipe(key));
        }
    }

    private static void addRepair(EmiRegistry registry, Set<Item> hiddenItems) {
        ArrayList targetedEnchantments = Lists.newArrayList();
        ArrayList universalEnchantments = Lists.newArrayList();
        for (Enchantment enchantment : EmiPort.getEnchantmentRegistry().m_123024_().toList()) {
            try {
                if (enchantment.m_6081_(ItemStack.f_41583_)) {
                    universalEnchantments.add(enchantment);
                    continue;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            targetedEnchantments.add(enchantment);
        }
        for (Item i : EmiPort.getItemRegistry()) {
            TallFlowerBlock tf;
            BlockItem bi;
            Block consumer;
            if (hiddenItems.contains(i)) continue;
            try {
                if (i.m_41462_() > 0) {
                    TieredItem ti;
                    ArmorItem ai;
                    if (i instanceof ArmorItem && (ai = (ArmorItem)i).m_40401_() != null && ai.m_40401_().m_6230_() != null && !ai.m_40401_().m_6230_().m_43947_()) {
                        id = VanillaPlugin.synthetic("anvil/repairing/material", EmiUtil.subId(i) + "/" + EmiUtil.subId(ai.m_40401_().m_6230_().m_43908_()[0].m_41720_()));
                        VanillaPlugin.addRecipeSafe(registry, () -> new EmiAnvilRecipe(EmiStack.of((ItemLike)i), EmiIngredient.of(ai.m_40401_().m_6230_()), id));
                    } else if (i instanceof TieredItem && (ti = (TieredItem)i).m_43314_().m_6282_() != null && !ti.m_43314_().m_6282_().m_43947_()) {
                        id = VanillaPlugin.synthetic("anvil/repairing/material", EmiUtil.subId(i) + "/" + EmiUtil.subId(ti.m_43314_().m_6282_().m_43908_()[0].m_41720_()));
                        VanillaPlugin.addRecipeSafe(registry, () -> new EmiAnvilRecipe(EmiStack.of((ItemLike)i), EmiIngredient.of(ti.m_43314_().m_6282_()), id));
                    }
                }
                if (i.m_41465_()) {
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiAnvilRepairItemRecipe(i, VanillaPlugin.synthetic("anvil/repairing/tool", EmiUtil.subId(i))));
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiGrindstoneRecipe(i, VanillaPlugin.synthetic("grindstone/repairing", EmiUtil.subId(i))));
                }
            }
            catch (Throwable t) {
                EmiLog.error("Exception thrown registering repair recipes", t);
            }
            try {
                ItemStack defaultStack = i.m_7968_();
                int acceptableEnchantments = 0;
                consumer = e -> {
                    int max = e.m_6586_();
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiAnvilEnchantRecipe(i, (Enchantment)e, max, VanillaPlugin.synthetic("anvil/enchanting", EmiUtil.subId(i) + "/" + EmiUtil.subId(EmiPort.getEnchantmentRegistry().m_7981_(e)) + "/" + max)));
                };
                for (Enchantment e2 : targetedEnchantments) {
                    if (!e2.m_6081_(defaultStack)) continue;
                    consumer.accept(e2);
                    ++acceptableEnchantments;
                }
                if (acceptableEnchantments > 0) {
                    for (Enchantment e2 : universalEnchantments) {
                        if (!e2.m_6081_(defaultStack)) continue;
                        consumer.accept(e2);
                        ++acceptableEnchantments;
                    }
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiGrindstoneDisenchantingRecipe(i, VanillaPlugin.synthetic("grindstone/disenchanting/tool", EmiUtil.subId(i))));
                }
            }
            catch (Throwable t) {
                EmiReloadLog.warn("Exception thrown registering enchantment recipes", t);
            }
            if (!(i instanceof BlockItem) || !((consumer = (bi = (BlockItem)i).m_40614_()) instanceof TallFlowerBlock) || !EmiPort.canTallFlowerDuplicate(tf = (TallFlowerBlock)consumer)) continue;
            VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((ItemLike)bi).setRemainder(EmiStack.of((ItemLike)bi)), EmiStack.of((ItemLike)Items.f_42499_), EmiStack.of((ItemLike)i), VanillaPlugin.synthetic("world/flower_duping", EmiUtil.subId(i)), false));
        }
        VanillaPlugin.addRecipeSafe(registry, () -> new EmiAnvilRecipe(EmiStack.of((ItemLike)Items.f_42741_), EmiStack.of((ItemLike)Items.f_42714_), VanillaPlugin.synthetic("anvil/repairing/material", EmiUtil.subId(Items.f_42741_) + "/" + EmiUtil.subId(Items.f_42714_))));
        VanillaPlugin.addRecipeSafe(registry, () -> new EmiAnvilRecipe(EmiStack.of((ItemLike)Items.f_42740_), EmiIngredient.of(ItemTags.f_13168_), VanillaPlugin.synthetic("anvil/repairing/material", EmiUtil.subId(Items.f_42740_) + "/" + EmiUtil.subId(Items.f_42647_))));
        for (Enchantment e3 : EmiPort.getEnchantmentRegistry().m_123024_().toList()) {
            if (e3.m_6589_()) continue;
            int max = Math.min(10, e3.m_6586_());
            int min = e3.m_44702_();
            while (min <= max) {
                int level = min++;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiGrindstoneDisenchantingBookRecipe(e3, level, VanillaPlugin.synthetic("grindstone/disenchanting/book", EmiUtil.subId(EmiPort.getEnchantmentRegistry().m_7981_((Object)e3)) + "/" + level)));
            }
        }
    }

    private static void addWorldInteraction(EmiRegistry registry, Set<Item> hiddenItems, List<Item> dyeableItems) {
        ResourceLocation id;
        Object id2;
        EmiStack concreteWater = EmiStack.of((Fluid)Fluids.f_76193_);
        concreteWater.setRemainder(concreteWater);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.f_50506_, concreteWater, Blocks.f_50542_);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.f_50507_, concreteWater, Blocks.f_50543_);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.f_50508_, concreteWater, Blocks.f_50544_);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.f_50509_, concreteWater, Blocks.f_50545_);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.f_50510_, concreteWater, Blocks.f_50494_);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.f_50511_, concreteWater, Blocks.f_50495_);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.f_50512_, concreteWater, Blocks.f_50496_);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.f_50513_, concreteWater, Blocks.f_50497_);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.f_50514_, concreteWater, Blocks.f_50498_);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.f_50515_, concreteWater, Blocks.f_50499_);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.f_50516_, concreteWater, Blocks.f_50500_);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.f_50517_, concreteWater, Blocks.f_50501_);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.f_50518_, concreteWater, Blocks.f_50502_);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.f_50519_, concreteWater, Blocks.f_50503_);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.f_50573_, concreteWater, Blocks.f_50504_);
        VanillaPlugin.addConcreteRecipe(registry, Blocks.f_50574_, concreteWater, Blocks.f_50505_);
        EmiIngredient axes = VanillaPlugin.damagedTool(VanillaPlugin.getPreferredTag(List.of("minecraft:axes", "c:axes", "c:tools/axes", "fabric:axes", "forge:tools/axes"), EmiStack.of((ItemLike)Items.f_42386_)), 1);
        for (Map.Entry<Block, Block> entry2 : AxeItemAccessor.getStrippedBlocks().entrySet()) {
            ResourceLocation id22 = VanillaPlugin.synthetic("world/stripping", EmiUtil.subId(entry2.getKey()));
            VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((ItemLike)entry2.getKey()), axes, EmiStack.of((ItemLike)entry2.getValue()), id22));
        }
        for (Map.Entry<Object, Object> entry3 : ((BiMap)WeatheringCopper.f_154887_.get()).entrySet()) {
            id2 = VanillaPlugin.synthetic("world/stripping", EmiUtil.subId((Block)entry3.getKey()));
            VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.lambda$addWorldInteraction$47(entry3, axes, (ResourceLocation)id2));
        }
        for (Map.Entry<Object, Object> entry4 : ((BiMap)HoneycombItem.f_150864_.get()).entrySet()) {
            id2 = VanillaPlugin.synthetic("world/stripping", EmiUtil.subId((Block)entry4.getKey()));
            VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.lambda$addWorldInteraction$48(entry4, axes, (ResourceLocation)id2));
        }
        EmiIngredient shears = VanillaPlugin.damagedTool(EmiStack.of((ItemLike)Items.f_42574_), 1);
        VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/shearing", "minecraft/pumpkin")).leftInput(EmiStack.of((ItemLike)Items.f_42046_)).rightInput(shears, true).output(EmiStack.of((ItemLike)Items.f_42577_, 4L)).output(EmiStack.of((ItemLike)Items.f_42047_)).build());
        EmiIngredient emiIngredient = VanillaPlugin.damagedTool(VanillaPlugin.getPreferredTag(List.of("minecraft:hoes", "c:hoes", "c:tools/hoes", "fabric:hoes", "forge:tools/hoes"), EmiStack.of((ItemLike)Items.f_42387_)), 1);
        for (Map.Entry entry5 : HoeItemAccessor.getTillingActions().entrySet()) {
            Consumer consumer = (Consumer)((Pair)entry5.getValue()).getSecond();
            if (!EmiClient.HOE_ACTIONS.containsKey(consumer)) continue;
            Block b = (Block)entry5.getKey();
            id = VanillaPlugin.synthetic("world/tilling", EmiUtil.subId(b));
            List<EmiStack> list = EmiClient.HOE_ACTIONS.get(consumer).stream().map(EmiStack::of).toList();
            if (list.size() == 1) {
                VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((ItemLike)b), hoes, (EmiStack)list.get(0), id));
                continue;
            }
            if (list.size() == 2) {
                VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(id).leftInput(EmiStack.of((ItemLike)b)).rightInput(hoes, true).output((EmiStack)list.get(0)).output((EmiStack)list.get(1)).build());
                continue;
            }
            EmiReloadLog.warn("Encountered hoe action of peculiar size " + list.size() + ", skipping.");
        }
        EmiIngredient shovels = VanillaPlugin.damagedTool(VanillaPlugin.getPreferredTag(List.of("minecraft:shovels", "c:shovels", "c:tools/shovels", "fabric:shovels", "forge:tools/shovels"), EmiStack.of((ItemLike)Items.f_42384_)), 1);
        for (Map.Entry<Block, BlockState> entry6 : ShovelItemAccessor.getPathStates().entrySet()) {
            Block result = entry6.getValue().m_60734_();
            id = VanillaPlugin.synthetic("world/flattening", EmiUtil.subId(entry6.getKey()));
            VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((ItemLike)entry4.getKey()), shovels, EmiStack.of((ItemLike)result), id));
        }
        EmiStack emiStack = EmiStack.of((ItemLike)Items.f_42784_);
        for (Map.Entry entry5 : ((BiMap)HoneycombItem.f_150863_.get()).entrySet()) {
            id = VanillaPlugin.synthetic("world/waxing", EmiUtil.subId((Block)entry5.getKey()));
            VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((ItemLike)entry5.getKey()), honeycomb, EmiStack.of((ItemLike)entry5.getValue()), id, false));
        }
        for (Item i : dyeableItems) {
            if (hiddenItems.contains(i)) continue;
            EmiStack cauldron = EmiStack.of((ItemLike)Items.f_42544_);
            EmiStack waterThird = EmiStack.of((Fluid)Fluids.f_76193_, (long)FluidUnit.BOTTLE);
            int uniq = EmiUtil.RANDOM.nextInt();
            VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/cauldron_washing", EmiUtil.subId(i))).leftInput(EmiStack.EMPTY, s -> new GeneratedSlotWidget(r -> {
                ItemStack stack = i.m_7968_();
                ((DyeableLeatherItem)i).m_41115_(stack, r.nextInt(0x1000000));
                return EmiStack.of(stack);
            }, uniq, s.getBounds().x(), s.getBounds().y())).rightInput(cauldron, true).rightInput(waterThird, false).output(EmiStack.of((ItemLike)i)).supportsRecipeTree(false).build());
        }
        EmiStack emiStack2 = EmiStack.of((Fluid)Fluids.f_76193_, (long)FluidUnit.BUCKET);
        EmiStack lava = EmiStack.of((Fluid)Fluids.f_76195_, (long)FluidUnit.BUCKET);
        EmiStack waterCatalyst = emiStack2.copy().setRemainder(emiStack2);
        EmiStack lavaCatalyst = lava.copy().setRemainder(lava);
        VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/fluid_spring", "minecraft/water")).leftInput(waterCatalyst).rightInput(waterCatalyst, false).output(EmiStack.of((Fluid)Fluids.f_76193_, (long)FluidUnit.BUCKET)).build());
        VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/fluid_interaction", "minecraft/cobblestone")).leftInput(waterCatalyst).rightInput(lavaCatalyst, false).output(EmiStack.of((ItemLike)Items.f_42594_)).build());
        VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/fluid_interaction", "minecraft/stone")).leftInput(waterCatalyst).rightInput(lavaCatalyst, false).output(EmiStack.of((ItemLike)Items.f_41905_)).build());
        VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/fluid_interaction", "minecraft/obsidian")).leftInput(lava).rightInput(waterCatalyst, false).output(EmiStack.of((ItemLike)Items.f_41999_)).build());
        EmiStack soulSoil = EmiStack.of((ItemLike)Items.f_42050_);
        soulSoil.setRemainder(soulSoil);
        EmiStack blueIce = EmiStack.of((ItemLike)Items.f_42363_);
        blueIce.setRemainder(blueIce);
        VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/fluid_interaction", "minecraft/basalt")).leftInput(lavaCatalyst).rightInput(soulSoil, false, s -> s.appendTooltip((Component)EmiPort.translatable("tooltip.emi.fluid_interaction.basalt.soul_soil", ChatFormatting.GREEN))).rightInput(blueIce, false, s -> s.appendTooltip((Component)EmiPort.translatable("tooltip.emi.fluid_interaction.basalt.blue_ice", ChatFormatting.GREEN))).output(EmiStack.of((ItemLike)Items.f_42051_)).build());
        EmiPort.getFluidRegistry().m_203611_().forEach(entry -> {
            Fluid fluid = (Fluid)entry.m_203334_();
            Item bucket = fluid.m_6859_();
            if (fluid.m_7444_(fluid.m_76145_()) && !fluid.m_76145_().m_76188_().m_60795_() && bucket != Items.f_41852_ && fluid instanceof FlowingFluid) {
                VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((ItemLike)Items.f_42446_), EmiStack.of(fluid, (long)FluidUnit.BUCKET), EmiStack.of((ItemLike)bucket), VanillaPlugin.synthetic("emi", "bucket_filling/" + EmiUtil.subId(fluid)), false));
            }
        });
        VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((ItemLike)Items.f_42590_), water, EmiStack.of(EmiPort.setPotion(new ItemStack((ItemLike)Items.f_42589_), Potions.f_43599_)), VanillaPlugin.synthetic("world/unique", "minecraft/water_bottle")));
        EmiStack waterBottle = EmiStack.of(EmiPort.setPotion(new ItemStack((ItemLike)Items.f_42589_), Potions.f_43599_)).setRemainder(EmiStack.of((ItemLike)Items.f_42590_));
        EmiStack mud = EmiStack.of((ItemLike)Items.f_220216_);
        VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((ItemLike)Items.f_42329_), waterBottle, mud, VanillaPlugin.synthetic("world/unique", "minecraft/mud"), false));
    }

    private static EmiIngredient damagedTool(EmiIngredient tool, int damage) {
        for (EmiStack stack : tool.getEmiStacks()) {
            ItemStack is = stack.getItemStack().m_41777_();
            is.m_41721_(1);
            stack.setRemainder(EmiStack.of(is));
        }
        return tool;
    }

    private static EmiIngredient getPreferredTag(List<String> candidates, EmiIngredient fallback) {
        for (String id : candidates) {
            EmiIngredient potential = EmiIngredient.of(TagKey.m_203882_((ResourceKey)EmiPort.getItemRegistry().m_123023_(), (ResourceLocation)EmiPort.id(id)));
            if (potential.isEmpty()) continue;
            return potential;
        }
        return fallback;
    }

    private static void addFuel(EmiRegistry registry, Set<Item> hiddenItems) {
        Map<Item, Integer> fuelMap = EmiAgnos.getFuelMap();
        VanillaPlugin.compressRecipesToTags(fuelMap.keySet().stream().collect(Collectors.toSet()), (a, b) -> Integer.compare((Integer)fuelMap.get(a), (Integer)fuelMap.get(b)), tag -> {
            EmiIngredient stack = EmiIngredient.of(tag);
            Item item = stack.getEmiStacks().get(0).getItemStack().m_41720_();
            int time = (Integer)fuelMap.get(item);
            registry.addRecipe(new EmiFuelRecipe(stack, time, VanillaPlugin.synthetic("fuel/tag", EmiUtil.subId(tag.f_203868_()))));
        }, item -> {
            if (!hiddenItems.contains(item)) {
                int time = (Integer)fuelMap.get(item);
                registry.addRecipe(new EmiFuelRecipe(EmiStack.of((ItemLike)item), time, VanillaPlugin.synthetic("fuel/item", EmiUtil.subId(item))));
            }
        });
    }

    private static void addComposting(EmiRegistry registry, Set<Item> hiddenItems) {
        VanillaPlugin.compressRecipesToTags(ComposterBlock.f_51914_.keySet().stream().map(ItemLike::m_5456_).collect(Collectors.toSet()), (a, b) -> Float.compare(ComposterBlock.f_51914_.getFloat(a), ComposterBlock.f_51914_.getFloat(b)), tag -> {
            EmiIngredient stack = EmiIngredient.of(tag);
            Item item = stack.getEmiStacks().get(0).getItemStack().m_41720_();
            float chance = ComposterBlock.f_51914_.getFloat((Object)item);
            registry.addRecipe(new EmiCompostingRecipe(stack, chance, VanillaPlugin.synthetic("composting/tag", EmiUtil.subId(tag.f_203868_()))));
        }, item -> {
            if (!hiddenItems.contains(item)) {
                float chance = ComposterBlock.f_51914_.getFloat(item);
                registry.addRecipe(new EmiCompostingRecipe(EmiStack.of((ItemLike)item), chance, VanillaPlugin.synthetic("composting/item", EmiUtil.subId(item))));
            }
        });
    }

    private static void compressRecipesToTags(Set<Item> stacks, Comparator<Item> comparator, Consumer<TagKey<Item>> tagConsumer, Consumer<Item> itemConsumer) {
        HashSet handled = Sets.newHashSet();
        block0: for (TagKey<Item> key : EmiTags.getTags(EmiPort.getItemRegistry())) {
            Item base;
            List<Item> items = EmiUtil.values(key).map(Holder::m_203334_).toList();
            if (items.size() < 2 || !stacks.contains(base = items.get(0))) continue;
            for (int i = 1; i < items.size(); ++i) {
                Item item = items.get(i);
                if (!stacks.contains(item) || comparator.compare(base, item) != 0) continue block0;
            }
            if (handled.containsAll(items)) continue;
            handled.addAll(items);
            tagConsumer.accept(key);
        }
        for (Item item : stacks) {
            if (handled.contains(item)) continue;
            itemConsumer.accept(item);
        }
    }

    private static ResourceLocation synthetic(String type, String name) {
        return EmiPort.id("emi", "/" + type + "/" + name);
    }

    private static <C extends Container, T extends Recipe<C>> Iterable<T> getRecipes(EmiRegistry registry, RecipeType<T> type) {
        return registry.getRecipeManager().m_44013_(type).stream()::iterator;
    }

    private static void safely(String name, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            EmiReloadLog.warn("Exception thrown when reloading " + name + " step in vanilla EMI plugin", t);
        }
    }

    private static void addRecipeSafe(EmiRegistry registry, Supplier<EmiRecipe> supplier) {
        try {
            registry.addRecipe(supplier.get());
        }
        catch (Throwable e) {
            EmiReloadLog.warn("Exception thrown when parsing EMI recipe (no ID available)", e);
        }
    }

    private static void addRecipeSafe(EmiRegistry registry, Supplier<EmiRecipe> supplier, Recipe<?> recipe) {
        try {
            registry.addRecipe(supplier.get());
        }
        catch (Throwable e) {
            EmiReloadLog.warn("Exception thrown when parsing vanilla recipe " + String.valueOf(EmiPort.getId(recipe)), e);
        }
    }

    private static EmiRenderable simplifiedRenderer(int u, int v) {
        return (raw, x, y, delta) -> {
            EmiDrawContext context = EmiDrawContext.wrap(raw);
            context.drawTexture(EmiRenderHelper.WIDGETS, x, y, u, v, 16, 16);
        };
    }

    private static void addConcreteRecipe(EmiRegistry registry, Block powder, EmiStack water, Block result) {
        VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((ItemLike)powder), water, EmiStack.of((ItemLike)result), VanillaPlugin.synthetic("world/concrete", EmiUtil.subId(result))));
    }

    private static EmiRecipe basicWorld(EmiIngredient left, EmiIngredient right, EmiStack output, ResourceLocation id) {
        return VanillaPlugin.basicWorld(left, right, output, id, true);
    }

    private static EmiRecipe basicWorld(EmiIngredient left, EmiIngredient right, EmiStack output, ResourceLocation id, boolean catalyst) {
        return EmiWorldInteractionRecipe.builder().id(id).leftInput(left).rightInput(right, catalyst).output(output).build();
    }

    private static /* synthetic */ EmiRecipe lambda$addWorldInteraction$48(Map.Entry entry, EmiIngredient axes, ResourceLocation id) {
        return VanillaPlugin.basicWorld(EmiStack.of((ItemLike)entry.getKey()), axes, EmiStack.of((ItemLike)entry.getValue()), id);
    }

    private static /* synthetic */ EmiRecipe lambda$addWorldInteraction$47(Map.Entry entry, EmiIngredient axes, ResourceLocation id) {
        return VanillaPlugin.basicWorld(EmiStack.of((ItemLike)entry.getKey()), axes, EmiStack.of((ItemLike)entry.getValue()), id);
    }

    static {
        VanillaEmiRecipeCategories.CRAFTING = new EmiRecipeCategory(EmiPort.id("minecraft:crafting"), EmiStack.of((ItemLike)Items.f_41960_), VanillaPlugin.simplifiedRenderer(240, 240), EmiRecipeSorting.compareOutputThenInput());
        VanillaEmiRecipeCategories.SMELTING = new EmiRecipeCategory(EmiPort.id("minecraft:smelting"), EmiStack.of((ItemLike)Items.f_41962_), VanillaPlugin.simplifiedRenderer(224, 240), EmiRecipeSorting.compareOutputThenInput());
        VanillaEmiRecipeCategories.BLASTING = new EmiRecipeCategory(EmiPort.id("minecraft:blasting"), EmiStack.of((ItemLike)Items.f_42770_), VanillaPlugin.simplifiedRenderer(208, 240), EmiRecipeSorting.compareOutputThenInput());
        VanillaEmiRecipeCategories.SMOKING = new EmiRecipeCategory(EmiPort.id("minecraft:smoking"), EmiStack.of((ItemLike)Items.f_42769_), VanillaPlugin.simplifiedRenderer(192, 240), EmiRecipeSorting.compareOutputThenInput());
        VanillaEmiRecipeCategories.CAMPFIRE_COOKING = new EmiRecipeCategory(EmiPort.id("minecraft:campfire_cooking"), EmiStack.of((ItemLike)Items.f_42781_), VanillaPlugin.simplifiedRenderer(176, 240), EmiRecipeSorting.compareOutputThenInput());
        VanillaEmiRecipeCategories.STONECUTTING = new EmiRecipeCategory(EmiPort.id("minecraft:stonecutting"), EmiStack.of((ItemLike)Items.f_42776_), VanillaPlugin.simplifiedRenderer(160, 240), EmiRecipeSorting.compareInputThenOutput());
        VanillaEmiRecipeCategories.SMITHING = new EmiRecipeCategory(EmiPort.id("minecraft:smithing"), EmiStack.of((ItemLike)Items.f_42775_), VanillaPlugin.simplifiedRenderer(240, 224), EmiRecipeSorting.compareInputThenOutput());
        VanillaEmiRecipeCategories.ANVIL_REPAIRING = new EmiRecipeCategory(EmiPort.id("emi:anvil_repairing"), EmiStack.of((ItemLike)Items.f_42146_), VanillaPlugin.simplifiedRenderer(240, 224), EmiRecipeSorting.none());
        VanillaEmiRecipeCategories.GRINDING = new EmiRecipeCategory(EmiPort.id("emi:grinding"), EmiStack.of((ItemLike)Items.f_42773_), VanillaPlugin.simplifiedRenderer(192, 224), EmiRecipeSorting.none());
        VanillaEmiRecipeCategories.BREWING = new EmiRecipeCategory(EmiPort.id("minecraft:brewing"), EmiStack.of((ItemLike)Items.f_42543_), VanillaPlugin.simplifiedRenderer(224, 224), EmiRecipeSorting.none());
        VanillaEmiRecipeCategories.WORLD_INTERACTION = new EmiRecipeCategory(EmiPort.id("emi:world_interaction"), EmiStack.of((ItemLike)Items.f_42276_), VanillaPlugin.simplifiedRenderer(208, 224), EmiRecipeSorting.none());
        EmiRenderable flame = (matrices, x, y, delta) -> EmiTexture.FULL_FLAME.render(matrices, x + 1, y + 1, delta);
        VanillaEmiRecipeCategories.FUEL = new EmiRecipeCategory(EmiPort.id("emi:fuel"), flame, flame, EmiRecipeSorting.compareInputThenOutput());
        VanillaEmiRecipeCategories.COMPOSTING = new EmiRecipeCategory(EmiPort.id("emi:composting"), EmiStack.of((ItemLike)Items.f_42726_), EmiStack.of((ItemLike)Items.f_42726_), EmiRecipeSorting.compareInputThenOutput());
        VanillaEmiRecipeCategories.INFO = new EmiRecipeCategory(EmiPort.id("emi:info"), EmiStack.of((ItemLike)Items.f_42614_), VanillaPlugin.simplifiedRenderer(208, 224), EmiRecipeSorting.none());
    }
}

