/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class EmiAnvilRepairItemRecipe
implements EmiRecipe {
    private final Item tool;
    private final ResourceLocation id;
    private final int uniq = EmiUtil.RANDOM.nextInt();

    public EmiAnvilRepairItemRecipe(Item tool, ResourceLocation id) {
        this.tool = tool;
        this.id = id;
    }

    @Override
    public EmiRecipeCategory getCategory() {
        return VanillaEmiRecipeCategories.ANVIL_REPAIRING;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public List<EmiIngredient> getInputs() {
        return List.of(EmiStack.of((ItemLike)this.tool), EmiStack.of((ItemLike)this.tool));
    }

    @Override
    public List<EmiStack> getOutputs() {
        return List.of(EmiStack.of((ItemLike)this.tool));
    }

    @Override
    public boolean supportsRecipeTree() {
        return false;
    }

    @Override
    public int getDisplayWidth() {
        return 125;
    }

    @Override
    public int getDisplayHeight() {
        return 18;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.PLUS, 27, 3);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 75, 1);
        int notUniq = this.uniq;
        widgets.addGeneratedSlot(r -> this.getItem((Random)r, 0), notUniq, 0, 0);
        widgets.addGeneratedSlot(r -> this.getItem((Random)r, 1), notUniq, 49, 0);
        widgets.addGeneratedSlot(r -> this.getItem((Random)r, 2), notUniq, 107, 0).recipeContext(this);
    }

    protected EmiStack getItem(Random random, int item) {
        ArrayList items = Lists.newArrayList();
        items.add(this.getTool(random));
        items.add(this.getTool(random));
        items.add(this.getMergeItems(items));
        return EmiStack.of((ItemStack)items.get(item));
    }

    private ItemStack getMergeItems(List<ItemStack> items) {
        ItemStack item = this.tool.m_7968_();
        int maxDamage = this.tool.m_41462_();
        int damage = items.get(0).m_41773_() - 21 * maxDamage / 20 + items.get(1).m_41773_();
        if (damage > 0) {
            item.m_41721_(damage);
        }
        return item;
    }

    private ItemStack getTool(Random r) {
        ItemStack stack = this.tool.m_7968_();
        if (stack.m_41776_() <= 0) {
            return stack;
        }
        int d = r.nextInt(stack.m_41776_());
        stack.m_41721_(d);
        return stack;
    }
}

