/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.TabFocusHandler;
import com.tom.cpl.math.Box;
import com.tom.cpm.externals.com.udojava.evalex.Expression;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.util.ExpressionExt;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

public class Spinner
extends GuiElement
implements TabFocusHandler.Focusable {
    private float value;
    private int dp = 3;
    private List<Runnable> changeListeners = new ArrayList<Runnable>();
    private TextField txtf;
    private boolean txtfNeedsUpdate;
    private String error;
    private String lastValue;
    private MouseEvent currentClick;
    private int currentClickStartTime;

    public Spinner(IGui gui) {
        super(gui);
        this.txtf = new TextField(gui);
        this.txtf.setEventListener(this::updateTxtf);
        this.lastValue = this.roundValue();
        this.txtf.setText(this.lastValue);
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        this.gui.drawBox(this.bounds.x, this.bounds.y, this.bounds.w, this.bounds.h, this.gui.getColors().button_border);
        this.gui.drawBox(this.bounds.x + 1, this.bounds.y + 1, this.bounds.w - 2, this.bounds.h - 2, this.enabled ? this.gui.getColors().button_fill : this.gui.getColors().button_disabled);
        this.txtf.draw(event, partialTicks);
        Box bUp = new Box(this.bounds.x + this.bounds.w - 10, this.bounds.y, 10, this.bounds.h / 2);
        Box bDown = new Box(this.bounds.x + this.bounds.w - 10, this.bounds.y + this.bounds.h / 2, 10, this.bounds.h / 2);
        boolean upH = event.isHovered(bUp);
        boolean downH = event.isHovered(bDown);
        this.gui.drawBox((float)(this.bounds.x + this.bounds.w - 10), (float)(this.bounds.y + this.bounds.h / 2) - 0.5f, 10.0f, 1.0f, this.gui.getColors().button_border);
        if (this.enabled && upH) {
            this.gui.drawBox((float)(this.bounds.x + this.bounds.w - 10), (float)(this.bounds.y + 1), 9.0f, 8.5f, this.gui.getColors().button_hover);
        }
        if (this.enabled && downH) {
            this.gui.drawBox((float)(this.bounds.x + this.bounds.w - 10), (float)(this.bounds.y + this.bounds.h / 2) + 0.5f, 9.0f, 8.5f, this.gui.getColors().button_hover);
        }
        this.gui.drawTexture(this.bounds.x + this.bounds.w - 9, this.bounds.y + 2, 8, 8, 8, 8, "editor", this.enabled ? (upH ? this.gui.getColors().button_text_hover : this.gui.getColors().button_text_color) : this.gui.getColors().button_text_disabled);
        this.gui.drawTexture(this.bounds.x + this.bounds.w - 9, this.bounds.y + this.bounds.h / 2 + 1, 8, 8, 0, 8, "editor", this.enabled ? (downH ? this.gui.getColors().button_text_hover : this.gui.getColors().button_text_color) : this.gui.getColors().button_text_disabled);
        if (this.txtfNeedsUpdate && !this.txtf.isFocused()) {
            this.txtfNeedsUpdate = false;
            this.lastValue = this.roundValue();
            this.txtf.setText(this.lastValue);
        }
        if (event.isHovered(this.bounds) && this.txtf.isFocused() && this.error != null) {
            new Tooltip(this.gui.getFrame(), this.gui.i18nFormat("tooltip.cpm.exp_error", this.error)).set();
        }
        if (this.txtf.isFocused() && this.error != null) {
            this.gui.drawRectangle(this.bounds.x, this.bounds.y, this.bounds.w, this.bounds.h, -65536);
        }
        if (this.currentClick != null && MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getTicks() - this.currentClickStartTime > 10) {
            ++this.currentClickStartTime;
            this.arrowClicked(this.currentClick);
        }
    }

    @Override
    public void mouseClick(MouseEvent e) {
        if (this.bounds.isInBounds(e.x, e.y) && this.enabled) {
            if (e.isConsumed()) {
                return;
            }
            this.arrowClicked(e);
            this.currentClick = new MouseEvent(e.x, e.y, e.btn);
            this.currentClickStartTime = MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getTicks();
        }
        this.txtf.mouseClick(e);
    }

    @Override
    public void mouseDrag(MouseEvent e) {
        if (this.currentClick != null) {
            this.currentClick.x = e.x;
            this.currentClick.y = e.y;
        }
    }

    @Override
    public void mouseRelease(MouseEvent e) {
        this.currentClick = null;
    }

    private void arrowClicked(MouseEvent e) {
        float v;
        Box bUp = new Box(this.bounds.x + this.bounds.w - 9, this.bounds.y, this.bounds.w, this.bounds.h / 2);
        Box bDown = new Box(this.bounds.x + this.bounds.w - 9, this.bounds.y + this.bounds.h / 2, this.bounds.w, this.bounds.h / 2);
        float f = this.gui.isAltDown() && this.dp > 1 ? (this.gui.isShiftDown() && this.dp > 2 ? 0.001f : 0.01f) : (this.gui.isShiftDown() && this.dp > 0 ? 0.1f : (this.gui.isCtrlDown() ? (this.gui.isShiftDown() ? 100.0f : 10.0f) : (v = 1.0f)));
        if (bUp.isInBounds(e.x, e.y)) {
            this.value += v;
            this.changeListeners.forEach(Runnable::run);
            this.lastValue = this.roundValue();
            this.txtf.setText(this.lastValue);
            e.consume();
        } else if (bDown.isInBounds(e.x, e.y)) {
            this.value -= v;
            this.changeListeners.forEach(Runnable::run);
            this.lastValue = this.roundValue();
            this.txtf.setText(this.lastValue);
            e.consume();
        }
    }

    @Override
    public GuiElement setBounds(Box bounds) {
        this.txtf.setBounds(new Box(bounds.x, bounds.y, bounds.w - 10, bounds.h));
        return super.setBounds(bounds);
    }

    @Override
    public void keyPressed(KeyboardEvent evt) {
        this.txtf.keyPressed(evt);
    }

    public void addChangeListener(Runnable r) {
        this.changeListeners.add(r);
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
        if (!this.txtf.isFocused()) {
            this.lastValue = this.roundValue();
            this.txtf.setText(this.lastValue);
        } else {
            this.txtfNeedsUpdate = true;
        }
        this.error = null;
    }

    public void setDp(int dp) {
        this.dp = dp;
        this.lastValue = this.roundValue();
        this.txtf.setText(this.lastValue);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.txtf.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    private void updateTxtf() {
        if (this.lastValue.equals(this.txtf.getText())) {
            return;
        }
        try {
            float value;
            this.value = value = new ExpressionExt(this.txtf.getText().replace(',', '.').replace(';', ',')).eval();
            this.changeListeners.forEach(Runnable::run);
            this.error = null;
            this.txtfNeedsUpdate = true;
        }
        catch (Expression.ExpressionException e) {
            this.error = e.getMessage();
        }
        catch (Exception e) {
            this.error = this.gui.i18nFormat("error.cpm.unknownError", new Object[0]);
        }
    }

    @Override
    public boolean isFocused() {
        return this.txtf.isFocused();
    }

    @Override
    public void setFocused(boolean focused) {
        this.txtf.setFocused(focused);
        if (focused && this.enabled) {
            this.txtf.setSelectionPos(0, this.txtf.getText().length());
        } else {
            this.txtf.setSelectionPos(0, 0);
        }
    }

    public void setBackgroundColor(int bgColor) {
        this.txtf.setBackgroundColor(bgColor);
    }

    @Override
    public boolean isSelectable() {
        return this.visible && this.enabled;
    }

    private String roundValue() {
        try {
            return new BigDecimal(this.value).setScale(this.dp, RoundingMode.HALF_UP).toPlainString();
        }
        catch (NumberFormatException e) {
            return String.format("%." + this.dp + "f", Float.valueOf(this.value));
        }
    }
}

