/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.cpl.block.entity.ActiveEffect;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.util.Hand;
import com.tom.cpl.util.HandAnimation;
import com.tom.cpm.client.CustomPlayerModelsClient;
import com.tom.cpm.client.FirstPersonDetector;
import com.tom.cpm.client.Platform;
import com.tom.cpm.client.RealCameraDetector;
import com.tom.cpm.client.vr.VRPlayerRenderer;
import com.tom.cpm.common.EntityTypeHandlerImpl;
import com.tom.cpm.common.PlayerInventory;
import com.tom.cpm.common.WorldImpl;
import com.tom.cpm.mixinplugin.FPMDetector;
import com.tom.cpm.mixinplugin.RCDetector;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.render.PlayerModelSetup;
import com.tom.cpm.shared.skin.PlayerTextureLoader;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractSkullBlock;

public class PlayerProfile
extends com.tom.cpm.shared.config.Player<Player> {
    public static boolean inGui;
    private static BooleanSupplier inFirstPerson;
    private final GameProfile profile;
    private String skinType;

    public static void addInFirstPerson(BooleanSupplier inFirstPerson) {
        BooleanSupplier old = PlayerProfile.inFirstPerson;
        PlayerProfile.inFirstPerson = () -> inFirstPerson.getAsBoolean() || old.getAsBoolean();
    }

    public static GameProfile getPlayerProfile(Player player) {
        PlayerInfo info;
        ClientPacketListener conn;
        if (player == null) {
            return null;
        }
        GameProfile profile = player.m_36316_();
        if (profile.getProperties().isEmpty() && (conn = Minecraft.m_91087_().m_91403_()) != null && (info = conn.m_104949_(profile.getId())) != null) {
            profile = info.m_105312_();
        }
        return profile;
    }

    public PlayerProfile(GameProfile profile) {
        this.profile = new GameProfile(profile.getId(), profile.getName());
        PlayerProfile.cloneProperties(profile.getProperties(), this.profile.getProperties());
        if (profile.getId() != null) {
            this.skinType = DefaultPlayerSkin.m_118629_((UUID)profile.getId());
        }
    }

    @Override
    public SkinType getSkinType() {
        return SkinType.get(this.skinType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.profile == null ? 0 : this.profile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlayerProfile other = (PlayerProfile)obj;
        return !(this.profile == null ? other.profile != null : !this.profile.equals((Object)other.profile));
    }

    @Override
    public UUID getUUID() {
        return this.profile.getId();
    }

    @Override
    public void updateFromPlayer(Player player) {
        float f1;
        float f;
        ItemStack is;
        Pose p = player.m_20089_();
        this.animState.resetPlayer();
        switch (p) {
            case FALL_FLYING: {
                this.animState.elytraFlying = true;
                break;
            }
            case SLEEPING: {
                this.animState.sleeping = true;
                break;
            }
            case SPIN_ATTACK: {
                this.animState.tridentSpin = true;
                break;
            }
        }
        this.animState.sneaking = player.m_6047_();
        this.animState.crawling = player.m_20143_();
        this.animState.swimming = player.m_6067_();
        if (!player.m_6084_()) {
            this.animState.dying = true;
        }
        if (Platform.isSitting(player)) {
            this.animState.riding = true;
        }
        if (player.m_20142_()) {
            this.animState.sprinting = true;
        }
        if (player.m_6117_()) {
            this.animState.usingAnimation = HandAnimation.of(player.m_21211_().m_41780_());
        }
        if (player.m_20069_()) {
            this.animState.retroSwimming = true;
        }
        this.animState.moveAmountX = (float)(player.m_20185_() - player.f_19854_);
        this.animState.moveAmountY = (float)(player.m_20186_() - player.f_19855_);
        this.animState.moveAmountZ = (float)(player.m_20189_() - player.f_19856_);
        this.animState.yaw = player.m_146908_();
        this.animState.pitch = player.m_146909_();
        this.animState.bodyYaw = player.f_20883_;
        if (player.m_36170_(PlayerModelPart.HAT)) {
            this.animState.encodedState |= 1;
        }
        if (player.m_36170_(PlayerModelPart.JACKET)) {
            this.animState.encodedState |= 2;
        }
        if (player.m_36170_(PlayerModelPart.LEFT_PANTS_LEG)) {
            this.animState.encodedState |= 4;
        }
        if (player.m_36170_(PlayerModelPart.RIGHT_PANTS_LEG)) {
            this.animState.encodedState |= 8;
        }
        if (player.m_36170_(PlayerModelPart.LEFT_SLEEVE)) {
            this.animState.encodedState |= 0x10;
        }
        if (player.m_36170_(PlayerModelPart.RIGHT_SLEEVE)) {
            this.animState.encodedState |= 0x20;
        }
        this.animState.hasSkullOnHead = (is = player.m_6844_(EquipmentSlot.HEAD)).m_41720_() instanceof BlockItem && ((BlockItem)is.m_41720_()).m_40614_() instanceof AbstractSkullBlock;
        this.animState.wearingHelm = !is.m_41619_();
        is = player.m_6844_(EquipmentSlot.CHEST);
        this.animState.wearingElytra = is.m_41720_() instanceof ElytraItem;
        this.animState.wearingBody = !is.m_41619_();
        this.animState.wearingLegs = !player.m_6844_(EquipmentSlot.LEGS).m_41619_();
        this.animState.wearingBoots = !player.m_6844_(EquipmentSlot.FEET).m_41619_();
        this.animState.mainHand = Hand.of(player.m_5737_());
        this.animState.activeHand = Hand.of(this.animState.mainHand, player.m_7655_());
        this.animState.swingingHand = Hand.of(this.animState.mainHand, player.f_20912_);
        this.animState.hurtTime = player.f_20916_;
        this.animState.isOnLadder = player.m_6147_();
        this.animState.isBurning = player.m_6051_();
        this.animState.isFreezing = player.m_146888_() > 0;
        this.animState.inGui = inGui;
        this.animState.firstPersonMod = inFirstPerson.getAsBoolean();
        PlayerInventory.setInv(this.animState, player.m_150109_());
        WorldImpl.setWorld(this.animState, (Entity)player);
        if (player.m_20202_() != null) {
            this.animState.vehicle = EntityTypeHandlerImpl.impl.wrap(player.m_20202_().m_6095_());
        }
        player.m_21220_().forEach(e -> this.animState.allEffects.add(new ActiveEffect(BuiltInRegistries.f_256974_.m_7981_((Object)e.m_19544_()).toString(), e.m_19564_(), e.m_19557_(), !e.m_19572_())));
        if (player.m_21211_().m_41720_() instanceof CrossbowItem) {
            f = CrossbowItem.m_40939_((ItemStack)player.m_21211_());
            f1 = MathHelper.clamp((float)player.m_21252_(), 0.0f, f);
            this.animState.crossbowPullback = f1 / f;
        }
        if (player.m_21211_().m_41720_() instanceof BowItem) {
            f = 20.0f;
            f1 = MathHelper.clamp((float)player.m_21252_(), 0.0f, f);
            this.animState.bowPullback = f1 / f;
        }
        this.animState.parrotLeft = !player.m_36331_().m_128461_("id").isEmpty();
        this.animState.parrotRight = !player.m_36332_().m_128461_("id").isEmpty();
    }

    @Override
    public void updateFromModel(Object model) {
        if (model instanceof PlayerModel) {
            PlayerModel m = (PlayerModel)model;
            this.animState.resetModel();
            this.animState.attackTime = m.f_102608_;
            this.animState.swimAmount = m.f_102818_;
            this.animState.leftArm = PlayerModelSetup.ArmPose.of(m.f_102815_);
            this.animState.rightArm = PlayerModelSetup.ArmPose.of(m.f_102816_);
            if (CustomPlayerModelsClient.vrLoaded) {
                this.animState.vrState = VRPlayerRenderer.getVRState(this.animState.animationMode, model);
            }
        }
    }

    @Override
    protected PlayerTextureLoader initTextures() {
        return new PlayerTextureLoader(Minecraft.m_91087_().m_91109_().f_118808_){

            @Override
            protected CompletableFuture<Void> load0() {
                Map map = Minecraft.m_91087_().m_91109_().m_118815_(PlayerProfile.this.profile);
                this.defineAll(map, MinecraftProfileTexture::getUrl, MinecraftProfileTexture::getHash);
                if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    MinecraftProfileTexture tex = (MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN);
                    PlayerProfile.this.skinType = tex.getMetadata("model");
                    if (PlayerProfile.this.skinType == null) {
                        PlayerProfile.this.skinType = "default";
                    }
                    return CompletableFuture.completedFuture(null);
                }
                final CompletableFuture<Void> cf = new CompletableFuture<Void>();
                Minecraft.m_91087_().m_91109_().m_118817_(PlayerProfile.this.profile, new SkinManager.SkinTextureCallback(){

                    public void m_118856_(MinecraftProfileTexture.Type typeIn, ResourceLocation location, MinecraftProfileTexture profileTexture) {
                        this.defineTexture((Enum)typeIn, profileTexture.getUrl(), profileTexture.getHash());
                        switch (typeIn) {
                            case SKIN: {
                                PlayerProfile.this.skinType = profileTexture.getMetadata("model");
                                if (PlayerProfile.this.skinType == null) {
                                    PlayerProfile.this.skinType = "default";
                                }
                                RenderSystem.recordRenderCall(() -> cf.complete(null));
                                break;
                            }
                        }
                    }
                }, true);
                return cf;
            }
        };
    }

    @Override
    public String getName() {
        return this.profile.getName();
    }

    @Override
    public Object getGameProfile() {
        return this.profile;
    }

    static {
        inFirstPerson = () -> false;
        if (FPMDetector.doApply()) {
            FirstPersonDetector.init();
        }
        if (RCDetector.doApply()) {
            RealCameraDetector.init();
        }
    }
}

