/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui;

import com.tom.cpl.function.TriFunction;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.Spinner;
import com.tom.cpl.gui.util.TabFocusHandler;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.gui.PerfaceUVPanel;
import com.tom.cpm.shared.editor.gui.UVPanel;
import com.tom.cpm.shared.editor.gui.popup.ColorButton;

public enum ModeDisplayType {
    NULL(ModePanel::new),
    COLOR(ColorPanel::new),
    TEX(UVPanel::new),
    VALUE(ValuePanel::new),
    TEX_FACE(PerfaceUVPanel::new);

    public final TriFunction<Frame, Editor, TabFocusHandler, Panel> factory;
    public static final ModeDisplayType[] VALUES;

    private ModeDisplayType(TriFunction<Frame, Editor, TabFocusHandler, Panel> factory) {
        this.factory = factory;
    }

    static {
        VALUES = ModeDisplayType.values();
    }

    public static class ValuePanel
    extends Panel {
        private Spinner spinnerS;

        public ValuePanel(Frame frm, Editor editor, TabFocusHandler tabHandler) {
            super(frm.getGui());
            this.setBounds(new Box(0, 0, 170, 20));
            this.spinnerS = new Spinner(this.gui);
            this.spinnerS.setBounds(new Box(5, 0, 160, 20));
            this.spinnerS.setDp(2);
            this.spinnerS.addChangeListener(() -> editor.setValue(this.spinnerS.getValue()));
            editor.setValue.add(this.spinnerS::setValue);
            this.addElement(this.spinnerS);
            tabHandler.add(this.spinnerS);
        }

        @Override
        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.spinnerS.setVisible(visible);
        }
    }

    public static class ColorPanel
    extends ModePanel {
        public ColorPanel(Frame frm, Editor editor, TabFocusHandler tabHandler) {
            super(frm, editor, tabHandler);
            this.setBounds(new Box(0, 0, 170, 47));
            ColorButton colorBtn = new ColorButton(this.gui, frm, editor::setColor);
            this.addElement(colorBtn);
            editor.setPartColor.add(c -> {
                if (c != null) {
                    colorBtn.setColor((int)c);
                }
            });
            colorBtn.setBounds(new Box(5, 25, 160, 20));
        }
    }

    public static class ModePanel
    extends Panel {
        public ModePanel(Frame frm, Editor editor, TabFocusHandler tabHandler) {
            super(frm.getGui());
            this.setBounds(new Box(0, 0, 170, 22));
            Button modeBtn = new Button(this.gui, this.gui.i18nFormat("button.cpm.mode", new Object[0]), editor::switchMode);
            modeBtn.setBounds(new Box(5, 0, 160, 20));
            editor.setModeBtn.add(b -> {
                if (b == null) {
                    modeBtn.setEnabled(false);
                    modeBtn.setText(this.gui.i18nFormat("button.cpm.mode", new Object[0]));
                } else {
                    modeBtn.setEnabled(true);
                    modeBtn.setText((String)b);
                }
            });
            this.addElement(modeBtn);
        }
    }
}

