/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.tags;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ButtonIcon;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.InputPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.ListPicker;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.gui.util.StackSlot;
import com.tom.cpl.gui.util.StackTagSlot;
import com.tom.cpl.item.Stack;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.tag.CPMTag;
import com.tom.cpl.tag.NativeTagManager;
import com.tom.cpl.util.NamedElement;
import com.tom.cpm.shared.editor.tags.EditorTagManager;
import com.tom.cpm.shared.gui.panel.ListPanel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public class TagEditorPanel<T>
extends Panel {
    protected ListPicker<NamedElement<EditorTagManager.EditableTag>> tagList;
    protected NamedElement.NameMapper<EditorTagManager.EditableTag> tagMapper;
    protected FlowLayout elemsLayout;
    protected Panel elemsPanel;
    protected ScrollPanel scpElements;
    protected EditorTagManager<T> manager;
    protected ButtonIcon delTag;
    protected ButtonIcon newEBtn;

    public TagEditorPanel(IGui gui, EditorTagManager<T> manager, int w, int h) {
        super(gui);
        this.manager = manager;
        this.tagMapper = new NamedElement.NameMapper<EditorTagManager.EditableTag>(manager.getTags(), CPMTag::getId);
        this.tagList = new ListPicker<NamedElement<EditorTagManager.EditableTag>>(gui.getFrame(), this.tagMapper.asList());
        this.tagMapper.setSetter(this.tagList::setSelected);
        this.tagList.setBounds(new Box(5, 5, w - 60, 20));
        this.tagList.setAction(this::updateElems);
        this.addElement(this.tagList);
        this.scpElements = new ScrollPanel(gui);
        this.addElement(this.scpElements);
        this.elemsPanel = new Panel(gui);
        this.scpElements.setDisplay(this.elemsPanel);
        this.elemsPanel.setBackgroundColor(gui.getColors().button_border);
        this.elemsPanel.setBounds(new Box(0, 0, w - 35, 0));
        this.scpElements.setBounds(new Box(5, 30, w - 35, h - 40));
        this.elemsLayout = new FlowLayout(this.elemsPanel, 5, 1);
        ButtonIcon newBtn = new ButtonIcon(gui, "editor", 0, 16, () -> gui.getFrame().openPopup(new InputPopup(gui.getFrame(), gui.i18nFormat("label.cpm.tags.newTag", new Object[0]), gui.i18nFormat("label.cpm.tags.newTag.desc", new Object[0]), name -> {
            String f = EditorTagManager.formatTag(name);
            if (f == null) {
                gui.displayMessagePopup(gui.i18nFormat("label.cpm.tags.newTag.invalidTag", new Object[0]), gui.i18nFormat("label.cpm.tags.newTag.invalidChars", new Object[0]));
            } else {
                EditorTagManager.EditableTag tag = manager.create(f);
                this.tagMapper.refreshValues();
                this.tagMapper.setValue(tag);
                this.updateElems();
            }
        }, null)));
        newBtn.setTooltip(new Tooltip(gui.getFrame(), gui.i18nFormat("tooltip.cpm.tags.newTag", new Object[0])));
        newBtn.setBounds(new Box(w - 50, 5, 20, 20));
        this.addElement(newBtn);
        this.delTag = new ButtonIcon(gui, "editor", 16, 16, ConfirmPopup.confirmHandler(gui.getFrame(), gui.i18nFormat("label.cpm.tags.deleteTag", new Object[0]), () -> {}));
        this.delTag.setBounds(new Box(w - 25, 5, 20, 20));
        this.addElement(this.delTag);
        this.newEBtn = new ButtonIcon(gui, "editor", 0, 16, this::addNewElement);
        this.newEBtn.setTooltip(new Tooltip(gui.getFrame(), gui.i18nFormat("tooltip.cpm.tags.newElem", new Object[0])));
        this.newEBtn.setBounds(new Box(w - 25, 30, 20, 20));
        this.addElement(this.newEBtn);
        this.updateElems();
        this.setBounds(new Box(0, 0, w, h));
    }

    private void updateElems() {
        int w = this.elemsPanel.getBounds().w;
        this.elemsPanel.getElements().clear();
        this.scpElements.setScrollY(0);
        boolean en = this.tagList.getSelected() != null && this.tagList.getSelected().getElem() != null;
        this.delTag.setEnabled(en);
        this.newEBtn.setEnabled(en);
        if (en) {
            EditorTagManager.EditableTag tag = this.tagList.getSelected().getElem();
            tag.getEntries().forEach(e -> this.addElementToPanel((String)e, w));
        }
        this.elemsLayout.reflow();
    }

    protected void addElementToPanel(String elem, int w) {
        Panel pn = new Panel(this.gui);
        pn.addElement(new Label(this.gui, elem).setBounds(new Box(5, 5, 0, 0)));
        ButtonIcon del = new ButtonIcon(this.gui, "editor", 16, 16, () -> this.removeElem(elem));
        del.setBounds(new Box(w - 25, 0, 20, 20));
        pn.addElement(del);
        pn.setBounds(new Box(0, 0, w, 20));
        this.elemsPanel.addElement(pn);
    }

    protected void addNewElement() {
        ArrayList<String> elems = new ArrayList<String>();
        this.manager.listAllTags().forEach(e -> elems.add(e.getId()));
        NativeTagManager m = this.manager.getNativeManager();
        m.getAllElements().forEach(e -> elems.add(m.getId(e)));
        this.gui.getFrame().openPopup(new PopupList(elems));
    }

    protected void removeElem(String elem) {
        if (this.tagList.getSelected() == null) {
            return;
        }
        EditorTagManager.EditableTag tag = this.tagList.getSelected().getElem();
        this.manager.removeElemFromTag(tag, elem);
        this.updateElems();
    }

    protected void addTagElement(String elem) {
        if (this.tagList.getSelected() == null) {
            return;
        }
        EditorTagManager.EditableTag tag = this.tagList.getSelected().getElem();
        this.manager.addElemToTag(tag, elem);
        this.updateElems();
    }

    protected class PopupList
    extends PopupPanel {
        private Button btnR;

        protected PopupList(List<String> values) {
            super(TagEditorPanel.this.gui);
            Frame frame = this.gui.getFrame();
            int w = Math.min(frame.getBounds().w / 4 * 3, 210);
            int h = Math.min(frame.getBounds().h / 4 * 3, 335);
            ListPanel<String> list = new ListPanel<String>(this.gui, values, w - 10, h - 35);
            list.setBounds(new Box(5, 5, w - 10, h - 35));
            this.addElement(list);
            Button btn = new Button(this.gui, this.gui.i18nFormat("button.cpm.ok", new Object[0]), () -> {
                this.close();
                if (list.getSelected() != null) {
                    TagEditorPanel.this.addTagElement((String)list.getSelected());
                }
            });
            btn.setBounds(new Box(5, h - 25, 60, 20));
            this.addElement(btn);
            Button btnC = new Button(this.gui, this.gui.i18nFormat("button.cpm.cancel", new Object[0]), this::close);
            btnC.setBounds(new Box(70, h - 25, 60, 20));
            this.addElement(btnC);
            this.btnR = new Button(this.gui, this.gui.i18nFormat("button.cpm.tags.raw", new Object[0]), null);
            this.initRawPopup(this.gui.i18nFormat("button.cpm.tags.list", new Object[0]), () -> frame.openPopup(this));
            this.btnR.setBounds(new Box(135, h - 25, 60, 20));
            this.addElement(this.btnR);
            this.setBounds(new Box(0, 0, w, h));
        }

        protected PopupList(List<String> values, String exBtn, Runnable exAction) {
            this(values);
            this.initRawPopup(exBtn, exAction);
        }

        private void initRawPopup(String exBtn, Runnable exAction) {
            Frame frame = this.gui.getFrame();
            this.btnR.setAction(() -> {
                this.close();
                InputPopup in = new InputPopup(frame, this.gui.i18nFormat("label.cpm.tags.raw.title", new Object[0]), this.gui.i18nFormat("label.cpm.tags.raw.desc", new Object[0]), e -> TagEditorPanel.this.addTagElement((String)e), null);
                Button btnT = new Button(this.gui, exBtn, () -> {
                    in.close();
                    exAction.run();
                });
                btnT.setBounds(new Box(95, in.getBounds().h - 25, 60, 20));
                in.addElement(btnT);
                frame.openPopup(in);
            });
        }

        @Override
        public String getTitle() {
            return this.gui.i18nFormat("label.cpm.tags.addNewElement", new Object[0]);
        }
    }

    public static class ItemTagEditorPanel
    extends TagEditorPanel<Stack> {
        public ItemTagEditorPanel(IGui gui, EditorTagManager<Stack> manager, int w, int h) {
            super(gui, manager, w, h);
        }

        @Override
        protected void addElementToPanel(String elem, int w) {
            Panel pn = new Panel(this.gui);
            pn.addElement(new StackTagSlot(this.gui, this.manager, elem).setBounds(new Box(5, 1, 18, 18)));
            pn.addElement(new Label(this.gui, elem).setBounds(new Box(30, 5, 0, 0)));
            ButtonIcon del = new ButtonIcon(this.gui, "editor", 16, 16, () -> this.removeElem(elem));
            del.setBounds(new Box(w - 25, 0, 20, 20));
            pn.addElement(del);
            pn.setBounds(new Box(0, 0, w, 20));
            this.elemsPanel.addElement(pn);
        }

        @Override
        protected void addNewElement() {
            this.gui.getFrame().openPopup(new PopupItems());
        }

        private class PopupItems
        extends PopupPanel {
            private List<StackSlot> slots;
            private String searchLast;
            private TextField searchField;
            private List<Stack> itemsList;
            private float currentScroll;
            private float oldScroll;
            private int cols;
            private int lines;
            private int dragY;
            private boolean refreshItemList;
            private Stack selected;
            private boolean enableDrag;

            protected PopupItems() {
                super(ItemTagEditorPanel.this.gui);
                this.searchLast = "";
                this.refreshItemList = true;
                Frame frame = this.gui.getFrame();
                int w = Math.min(frame.getBounds().w / 4 * 3, 210);
                int h = Math.min(frame.getBounds().h / 4 * 3, 335);
                this.searchField = new TextField(this.gui);
                this.searchField.setBounds(new Box(10, 10, w - 20, 20));
                this.addElement(this.searchField);
                this.searchField.setEventListener(this::updateSearch);
                this.slots = new ArrayList<StackSlot>();
                this.itemsList = new ArrayList<Stack>();
                this.lines = (int)((float)(h - 55) / 18.0f);
                this.cols = (int)((float)(w - 15) / 18.0f);
                for (int y = 0; y < this.lines; ++y) {
                    for (int x = 0; x < this.cols; ++x) {
                        StackSlot slot = new StackSlot(this.gui){

                            @Override
                            public void draw(MouseEvent event, float partialTicks) {
                                if (this.stack != null && Objects.equals(PopupItems.this.selected, this.stack)) {
                                    this.gui.drawRectangle(this.bounds.x, this.bounds.y, this.bounds.w, this.bounds.h, -256);
                                }
                                super.draw(event, partialTicks);
                            }

                            @Override
                            public void mouseClick(MouseEvent event) {
                                if (event.isHovered(this.bounds)) {
                                    PopupItems.this.selected = this.stack;
                                }
                            }
                        };
                        slot.setBounds(new Box(10 + x * 18, 35 + y * 18, 18, 18));
                        this.addElement(slot);
                        this.slots.add(slot);
                    }
                }
                Button btn = new Button(this.gui, this.gui.i18nFormat("button.cpm.ok", new Object[0]), () -> {
                    this.close();
                    if (this.selected != null) {
                        ItemTagEditorPanel.this.addTagElement(this.selected.getItemId());
                    }
                });
                btn.setBounds(new Box(5, h - 25, 60, 20));
                this.addElement(btn);
                Button btnC = new Button(this.gui, this.gui.i18nFormat("button.cpm.cancel", new Object[0]), this::close);
                btnC.setBounds(new Box(70, h - 25, 60, 20));
                this.addElement(btnC);
                Button btnT = new Button(this.gui, this.gui.i18nFormat("button.cpm.tags", new Object[0]), () -> {
                    this.close();
                    ArrayList<String> elems = new ArrayList<String>();
                    ItemTagEditorPanel.this.manager.listAllTags().forEach(e -> elems.add(e.getId()));
                    this.gui.getFrame().openPopup(new PopupList(elems, this.gui.i18nFormat("tab.cpm.tags.items", new Object[0]), () -> this.gui.getFrame().openPopup(this)));
                });
                btnT.setBounds(new Box(135, h - 25, 60, 20));
                this.addElement(btnT);
                this.setBounds(new Box(0, 0, w, h));
                this.updateSearch();
            }

            @Override
            public String getTitle() {
                return this.gui.i18nFormat("label.cpm.tags.addNewElement", new Object[0]);
            }

            private void updateSearch() {
                String searchString = this.searchField.getText();
                if (this.refreshItemList || !this.searchLast.equals(searchString)) {
                    this.itemsList.clear();
                    boolean searchMod = false;
                    String search = searchString;
                    if (searchString.startsWith("@")) {
                        searchMod = true;
                        search = searchString.substring(1);
                    }
                    Pattern m = null;
                    try {
                        m = Pattern.compile(search.toLowerCase(), 2);
                    }
                    catch (Throwable ignore) {
                        try {
                            m = Pattern.compile(Pattern.quote(search.toLowerCase()), 2);
                        }
                        catch (Throwable __) {
                            return;
                        }
                    }
                    try {
                        for (Stack is : ItemTagEditorPanel.this.manager.getNativeManager().getAllElements()) {
                            String dspName = searchMod ? is.getModId() : is.getDisplayName();
                            if (!m.matcher(dspName.toLowerCase()).find()) continue;
                            this.itemsList.add(is);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Collections.sort(this.itemsList, Comparator.comparing(Stack::getDisplayName));
                    this.currentScroll = 0.0f;
                    this.selected = null;
                    this.searchLast = searchString;
                    this.refreshItemList = false;
                    this.scrollTo(this.currentScroll);
                }
            }

            public final void scrollTo(float p_148329_1_) {
                int i = (this.itemsList.size() + this.cols - 1) / this.cols - this.lines;
                int j = (int)((double)(p_148329_1_ * (float)i) + 0.5);
                if (j < 0) {
                    j = 0;
                }
                for (int k = 0; k < this.lines; ++k) {
                    for (int l = 0; l < this.cols; ++l) {
                        int i1 = l + (k + j) * this.cols;
                        if (i1 >= 0 && i1 < this.itemsList.size()) {
                            this.setSlotContents(l + k * this.cols, this.itemsList.get(i1));
                            continue;
                        }
                        this.setSlotContents(l + k * this.cols, null);
                    }
                }
            }

            private void setSlotContents(int i, Stack stack) {
                this.slots.get(i).setStack(stack);
            }

            protected boolean needsScrollBars() {
                return this.itemsList.size() > this.lines * this.cols;
            }

            @Override
            public void mouseWheel(MouseEvent event) {
                if (this.needsScrollBars() && event.isHovered(this.bounds)) {
                    int i = (this.itemsList.size() + this.cols - 1) / this.cols - this.lines;
                    this.currentScroll -= (float)event.btn / (float)i;
                    this.currentScroll = MathHelper.clamp(this.currentScroll, 0.0f, 1.0f);
                    this.scrollTo(this.currentScroll);
                    event.consume();
                }
            }

            @Override
            public void draw(MouseEvent event, float partialTicks) {
                super.draw(event, partialTicks);
                if (this.needsScrollBars()) {
                    this.gui.pushMatrix();
                    this.gui.setPosOffset(this.getBounds());
                    this.gui.setupCut();
                    int scx = this.bounds.w - 5;
                    int i = (this.itemsList.size() + this.cols - 1) / this.cols;
                    float sch = this.bounds.h - 65;
                    float ph = i * 18;
                    float overflowY = sch / ph;
                    float h = Math.max(overflowY * sch, 8.0f);
                    float scroll = this.currentScroll * (float)(i - this.lines) * 18.0f / (ph - sch);
                    int y = (int)(scroll * (sch - h));
                    Box bar = new Box(this.bounds.x + scx, 35 + this.bounds.y + y, 3, (int)h);
                    this.gui.drawBox((float)scx, 35.0f, 3.0f, sch, this.gui.getColors().panel_background);
                    this.gui.drawBox((float)scx, (float)(35 + y), 3.0f, h, event.isHovered(bar) || this.enableDrag ? this.gui.getColors().button_hover : this.gui.getColors().button_disabled);
                    this.gui.popMatrix();
                    this.gui.setupCut();
                }
            }

            @Override
            public void mouseClick(MouseEvent event) {
                super.mouseClick(event);
                if (event.offset(this.bounds).isHovered(new Box(this.bounds.w - 5, 35, 3, this.bounds.h - 65))) {
                    this.enableDrag = true;
                    this.oldScroll = this.currentScroll;
                    this.dragY = event.y;
                    event.consume();
                }
            }

            @Override
            public void mouseDrag(MouseEvent event) {
                if (this.enableDrag) {
                    float sch = this.bounds.h - 65;
                    float ph = (this.itemsList.size() + this.cols - 1) / this.cols * 18;
                    float overflowY = sch / ph;
                    float h = Math.max(overflowY * sch, 8.0f);
                    float newScroll = (float)(event.y - this.dragY) / ((float)(this.bounds.h - 65) - h);
                    this.currentScroll = MathHelper.clamp(this.oldScroll + newScroll, 0.0f, 1.0f);
                    this.scrollTo(this.currentScroll);
                    event.consume();
                }
                super.mouseDrag(event);
            }

            @Override
            public void mouseRelease(MouseEvent event) {
                if (this.enableDrag) {
                    this.enableDrag = false;
                    event.consume();
                }
                super.mouseRelease(event);
            }
        }
    }
}

