/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui.panel;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.config.ModConfigFile;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.InputPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.text.FormatText;
import com.tom.cpl.util.Image;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.animation.AnimationHandler;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.config.PlayerSpecificConfigKey;
import com.tom.cpm.shared.config.SocialConfig;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.gui.ViewportCamera;
import com.tom.cpm.shared.gui.panel.ModelDisplayPanel;
import com.tom.cpm.shared.gui.panel.SafetyPanel;
import com.tom.cpm.shared.skin.TextureProvider;
import com.tom.cpm.shared.skin.TextureType;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class SocialPlayerPanel
extends Panel
implements ModelDisplayPanel.IModelDisplayPanel {
    private final Frame frm;
    private ViewportCamera cam;
    private Player<?> player;
    private CompletableFuture<ModelDefinition> def;
    private AnimationHandler animHandler;
    private TextureProvider vanillaSkin;
    private FlowLayout layout;
    private Panel buttonsPanel;
    private Button cloneBtn;
    private boolean cloneLoaded;

    public SocialPlayerPanel(Frame frm, final Player<?> player, ViewportCamera cam, int w, int h, Runnable reload) {
        super(frm.getGui());
        String plname;
        this.frm = frm;
        final Box parentBox = new Box(0, 0, w, h);
        this.setBounds(parentBox);
        this.player = player;
        this.cam = cam;
        this.animHandler = new AnimationHandler(this::getSelectedDefinition, AnimationEngine.AnimationMode.GUI);
        String uuid = player.getUUID().toString();
        int s = Math.min(w, h) - 30;
        if (!SocialConfig.isBlocked(uuid) && !this.gui.isShiftDown()) {
            ModelDisplayPanel modelPanel = new ModelDisplayPanel(frm, this){

                @Override
                public void draw(MouseEvent event, float partialTicks) {
                    FormatText t;
                    ModelDefinition d;
                    this.gui.drawBox(parentBox.x, parentBox.y, parentBox.w, parentBox.h, this.gui.getColors().popup_background & 0x80FFFFFF);
                    if (SocialPlayerPanel.this.def == null && (d = player.getModelDefinition0()) != null && (t = d.getStatus()) != null) {
                        this.setLoadingText(t.toString(this.gui));
                    }
                    super.draw(event, partialTicks);
                }
            };
            modelPanel.setLoadingText(this.gui.i18nFormat("label.cpm.loading", new Object[0]));
            modelPanel.setBackgroundColor(0);
            modelPanel.setBounds(new Box(w - s - 5, 5, s, s));
            this.addElement(modelPanel);
            ModelDefinition def = player.getModelDefinition0();
            if (def == null) {
                this.def = player.getTextures().load().thenCompose(_v -> player.getTextures().getTexture(TextureType.SKIN).thenApply(i -> {
                    if (i == null) {
                        i = player.getSkinType().getSkinTexture();
                    }
                    this.vanillaSkin = new TextureProvider((Image)i, new Vec2i(64, 64));
                    return ModelDefinition.createVanilla(() -> this.vanillaSkin, player.getSkinType());
                }));
            }
        }
        this.addElement(new Label(this.gui, (plname = player.getName()) != null ? plname : this.gui.i18nFormat("label.cpm.unknown", new Object[0])).setBounds(new Box(5, 5, 100, 10)));
        int bpw = w - s - 10;
        this.buttonsPanel = new Panel(this.gui);
        this.buttonsPanel.setBounds(new Box(0, 15, bpw, h));
        this.addElement(this.buttonsPanel);
        this.layout = new FlowLayout(this.buttonsPanel, 5, 1);
        Button friend = new Button(this.gui, this.gui.i18nFormat(SocialConfig.isFriend(uuid) ? "button.cpm.removeFriend" : "button.cpm.addFriend", new Object[0]), null);
        friend.setBounds(new Box(5, 0, bpw - 5, 20));
        friend.setAction(() -> {
            if (SocialConfig.isFriend(uuid)) {
                SocialConfig.removeFriend(uuid);
            } else {
                SocialConfig.addFriend(uuid, player.getName());
            }
            friend.setText(this.gui.i18nFormat(SocialConfig.isFriend(uuid) ? "button.cpm.removeFriend" : "button.cpm.addFriend", new Object[0]));
            MinecraftClientAccess.get().getDefinitionLoader().settingsChanged(player.getUUID());
            reload.run();
            ModConfig.getCommonConfig().save();
        });
        this.buttonsPanel.addElement(friend);
        Button block = new Button(this.gui, this.gui.i18nFormat(SocialConfig.isBlocked(uuid) ? "button.cpm.removeBlock" : "button.cpm.addBlock", new Object[0]), null);
        block.setBounds(new Box(5, 0, bpw - 5, 20));
        block.setAction(() -> {
            if (SocialConfig.isBlocked(uuid)) {
                SocialConfig.removeBlock(uuid);
            } else {
                SocialConfig.blockPlayer(uuid, player.getName());
            }
            block.setText(this.gui.i18nFormat(SocialConfig.isBlocked(uuid) ? "button.cpm.removeBlock" : "button.cpm.addBlock", new Object[0]));
            MinecraftClientAccess.get().getDefinitionLoader().settingsChanged(player.getUUID());
            reload.run();
            ModConfig.getCommonConfig().save();
        });
        this.buttonsPanel.addElement(block);
        Button playerSettings = new Button(this.gui, this.gui.i18nFormat("button.cpm.playerSettings", new Object[0]), () -> frm.openPopup(new SafetyPopup(this, player.getUUID().toString(), player.getName(), reload, frm)));
        playerSettings.setBounds(new Box(5, 0, bpw - 5, 20));
        this.buttonsPanel.addElement(playerSettings);
        this.cloneBtn = new Button(this.gui, this.gui.i18nFormat("button.cpm.clone", new Object[0]), () -> {
            ModelDefinition d = player.getModelDefinition();
            if (d != null && d.cloneable != null) {
                String name = d.cloneable.name;
                if (name == null) {
                    frm.openPopup(new InputPopup(frm, this.gui.i18nFormat("label.cpm.modelName", new Object[0]), this::clone, null));
                } else {
                    this.clone(name);
                }
            }
        });
        this.cloneBtn.setBounds(new Box(5, 0, bpw - 5, 20));
        this.buttonsPanel.addElement(this.cloneBtn);
        this.cloneBtn.setVisible(false);
        this.layout.reflow();
    }

    private void clone(String name) {
        MinecraftClientAccess.get().getDefinitionLoader().cloneModel(this.player, name).thenAcceptAsync(_b -> {
            if (((Boolean)_b).booleanValue()) {
                this.frm.openPopup(new MessagePopup(this.frm, this.gui.i18nFormat("label.cpm.success", new Object[0]), this.gui.i18nFormat("label.cpm.cloningSuccess", name)));
            } else {
                this.frm.openPopup(new MessagePopup(this.frm, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("label.cpm.cloningFailed", new Object[0])));
            }
        }, this.gui::executeLater);
    }

    @Override
    public ModelDefinition getSelectedDefinition() {
        ModelDefinition d = this.player.getModelDefinition();
        if (d != null) {
            if (!this.cloneLoaded) {
                this.cloneLoaded = true;
                this.cloneBtn.setVisible(d.cloneable != null);
                this.layout.reflow();
            }
            return d;
        }
        if (this.def != null) {
            return this.def.getNow(null);
        }
        return null;
    }

    @Override
    public ViewportCamera getCamera() {
        return this.cam;
    }

    @Override
    public void preRender() {
        if (this.getSelectedDefinition() != null) {
            MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().handleGuiAnimation(this.animHandler, this.getSelectedDefinition());
        }
    }

    @Override
    public boolean doRender() {
        return true;
    }

    public void cleanup() {
        if (this.vanillaSkin != null) {
            this.vanillaSkin.free();
        }
    }

    public static class SafetyPopup
    extends PopupPanel {
        private final Frame frm;
        private String uuid;
        private String name;
        private ModConfigFile.ConfigEntryTemp config;

        protected SafetyPopup(Panel parent, String uuid, String name, Runnable reload, Frame frm) {
            super(parent.getGui());
            this.frm = frm;
            Box b = parent.getBounds();
            this.setBounds(new Box(0, 0, b.w - 30, b.h - 20));
            this.uuid = uuid;
            this.name = name;
            this.config = ModConfig.getCommonConfig().createTemp();
            ConfigEntry ce = this.config.getEntry("playerSettings").getEntry(uuid);
            if (ce.keySet().isEmpty() && name != null) {
                ce.setString("name", name);
            }
            ScrollPanel scpS = new ScrollPanel(this.gui);
            scpS.setBounds(new Box(5, 5, this.bounds.w - 10, this.bounds.h - 30));
            this.addElement(scpS);
            SafetyPanel sp = new SafetyPanel(this.gui, ce, this.bounds.w - 10, this.getKeyGroup(), uuid, this.config);
            scpS.setDisplay(sp);
            Button saveBtn = new Button(this.gui, this.gui.i18nFormat("button.cpm.saveCfg", new Object[0]), () -> {
                this.config.saveConfig();
                MinecraftClientAccess.get().getDefinitionLoader().settingsChanged(UUID.fromString(uuid));
                reload.run();
                this.close();
            });
            this.addElement(saveBtn);
            saveBtn.setBounds(new Box(5, this.bounds.h - 25, 80, 20));
        }

        public PlayerSpecificConfigKey.KeyGroup getKeyGroup() {
            return SocialConfig.isFriend(this.uuid) ? PlayerSpecificConfigKey.KeyGroup.FRIEND : PlayerSpecificConfigKey.KeyGroup.GLOBAL;
        }

        @Override
        public String getTitle() {
            return this.gui.i18nFormat("label.cpm.sSettingsFor", this.name == null ? this.gui.i18nFormat("label.cpm.unknown", new Object[0]) : this.name);
        }

        @Override
        public void close() {
            if (this.config.isDirty()) {
                this.frm.openPopup(new ConfirmPopup(this.frm, this.gui.i18nFormat("label.cpm.unsaved", new Object[0]), () -> super.close(), null));
            } else {
                super.close();
            }
        }
    }
}

