/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model.render;

import com.tom.cpl.math.MathHelper;
import com.tom.cpl.math.Rotation;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.util.Hand;
import com.tom.cpm.shared.model.RootModelElement;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.builtin.VanillaPartRenderer;
import com.tom.cpm.shared.model.builtin.VanillaPlayerModel;
import com.tom.cpm.shared.model.render.VanillaModelPart;

public class PlayerModelSetup {
    public static void setRotationAngles(VanillaPlayerModel player, float limbSwing, float limbSwingAmount, Hand handside, boolean swim) {
        boolean flag3;
        boolean flag1 = swim;
        player.swimAmount = swim ? 1.0f : 0.0f;
        player.head.yRot = 0.0f;
        player.head.xRot = player.swimAmount > 0.0f ? (flag1 ? PlayerModelSetup.rotLerpRad(player.swimAmount, player.head.xRot, -0.7853982f) : PlayerModelSetup.rotLerpRad(player.swimAmount, player.head.xRot, 0.0f)) : 0.0f;
        player.body.yRot = 0.0f;
        player.rightArm.z = 0.0f;
        player.rightArm.x = -5.0f;
        player.leftArm.z = 0.0f;
        player.leftArm.x = 5.0f;
        float f = 1.0f;
        player.rightArm.xRot = MathHelper.cos(limbSwing * 0.6662f + (float)Math.PI) * 2.0f * limbSwingAmount * 0.5f / f;
        player.leftArm.xRot = MathHelper.cos(limbSwing * 0.6662f) * 2.0f * limbSwingAmount * 0.5f / f;
        player.rightArm.zRot = 0.0f;
        player.leftArm.zRot = 0.0f;
        player.rightLeg.xRot = MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbSwingAmount / f;
        player.leftLeg.xRot = MathHelper.cos(limbSwing * 0.6662f + (float)Math.PI) * 1.4f * limbSwingAmount / f;
        player.rightLeg.yRot = 0.0f;
        player.leftLeg.yRot = 0.0f;
        player.rightLeg.zRot = 0.0f;
        player.leftLeg.zRot = 0.0f;
        if (player.riding) {
            player.rightArm.xRot += -0.62831855f;
            player.leftArm.xRot += -0.62831855f;
            player.rightLeg.xRot = -1.4137167f;
            player.rightLeg.yRot = 0.31415927f;
            player.rightLeg.zRot = 0.07853982f;
            player.leftLeg.xRot = -1.4137167f;
            player.leftLeg.yRot = -0.31415927f;
            player.leftLeg.zRot = -0.07853982f;
        }
        player.rightArm.yRot = 0.0f;
        player.leftArm.yRot = 0.0f;
        boolean flag2 = handside == Hand.RIGHT;
        boolean bl = flag3 = flag2 ? player.leftArmPose.isTwoHanded() : player.rightArmPose.isTwoHanded();
        if (flag2 != flag3) {
            PlayerModelSetup.poseLeftArm(player);
            PlayerModelSetup.poseRightArm(player);
        } else {
            PlayerModelSetup.poseRightArm(player);
            PlayerModelSetup.poseLeftArm(player);
        }
        PlayerModelSetup.setupAttackAnimation(player, handside);
        if (player.crouching) {
            player.body.xRot = 0.5f;
            player.rightArm.xRot += 0.4f;
            player.leftArm.xRot += 0.4f;
            player.rightLeg.z = 4.0f;
            player.leftLeg.z = 4.0f;
            player.rightLeg.y = 12.2f;
            player.leftLeg.y = 12.2f;
            player.head.y = 4.2f;
            player.body.y = 3.2f;
            player.leftArm.y = 5.2f;
            player.rightArm.y = 5.2f;
        } else {
            player.body.xRot = 0.0f;
            player.rightLeg.z = 0.1f;
            player.leftLeg.z = 0.1f;
            player.rightLeg.y = 12.0f;
            player.leftLeg.y = 12.0f;
            player.head.y = 0.0f;
            player.body.y = 0.0f;
            player.leftArm.y = 2.0f;
            player.rightArm.y = 2.0f;
        }
        PlayerModelSetup.bobArms(player.rightArm, player.leftArm, 0.0f);
        if (player.swimAmount > 0.0f) {
            float f3;
            float f1 = limbSwing % 26.0f;
            float f2 = handside == Hand.RIGHT && player.attackTime > 0.0f ? 0.0f : player.swimAmount;
            float f4 = f3 = handside == Hand.LEFT && player.attackTime > 0.0f ? 0.0f : player.swimAmount;
            if (f1 < 14.0f) {
                player.leftArm.xRot = PlayerModelSetup.rotLerpRad(f3, player.leftArm.xRot, 0.0f);
                player.rightArm.xRot = MathHelper.lerp(f2, player.rightArm.xRot, 0.0f);
                player.leftArm.yRot = PlayerModelSetup.rotLerpRad(f3, player.leftArm.yRot, (float)Math.PI);
                player.rightArm.yRot = MathHelper.lerp(f2, player.rightArm.yRot, (float)Math.PI);
                player.leftArm.zRot = PlayerModelSetup.rotLerpRad(f3, player.leftArm.zRot, (float)Math.PI + 1.8707964f * PlayerModelSetup.getArmAngleSq(f1) / PlayerModelSetup.getArmAngleSq(14.0f));
                player.rightArm.zRot = MathHelper.lerp(f2, player.rightArm.zRot, (float)Math.PI - 1.8707964f * PlayerModelSetup.getArmAngleSq(f1) / PlayerModelSetup.getArmAngleSq(14.0f));
            } else if (f1 >= 14.0f && f1 < 22.0f) {
                float f6 = (f1 - 14.0f) / 8.0f;
                player.leftArm.xRot = PlayerModelSetup.rotLerpRad(f3, player.leftArm.xRot, 1.5707964f * f6);
                player.rightArm.xRot = MathHelper.lerp(f2, player.rightArm.xRot, 1.5707964f * f6);
                player.leftArm.yRot = PlayerModelSetup.rotLerpRad(f3, player.leftArm.yRot, (float)Math.PI);
                player.rightArm.yRot = MathHelper.lerp(f2, player.rightArm.yRot, (float)Math.PI);
                player.leftArm.zRot = PlayerModelSetup.rotLerpRad(f3, player.leftArm.zRot, 5.012389f - 1.8707964f * f6);
                player.rightArm.zRot = MathHelper.lerp(f2, player.rightArm.zRot, 1.2707963f + 1.8707964f * f6);
            } else if (f1 >= 22.0f && f1 < 26.0f) {
                float f42 = (f1 - 22.0f) / 4.0f;
                player.leftArm.xRot = PlayerModelSetup.rotLerpRad(f3, player.leftArm.xRot, 1.5707964f - 1.5707964f * f42);
                player.rightArm.xRot = MathHelper.lerp(f2, player.rightArm.xRot, 1.5707964f - 1.5707964f * f42);
                player.leftArm.yRot = PlayerModelSetup.rotLerpRad(f3, player.leftArm.yRot, (float)Math.PI);
                player.rightArm.yRot = MathHelper.lerp(f2, player.rightArm.yRot, (float)Math.PI);
                player.leftArm.zRot = PlayerModelSetup.rotLerpRad(f3, player.leftArm.zRot, (float)Math.PI);
                player.rightArm.zRot = MathHelper.lerp(f2, player.rightArm.zRot, (float)Math.PI);
            }
            player.leftLeg.xRot = MathHelper.lerp(player.swimAmount, player.leftLeg.xRot, 0.3f * MathHelper.cos(limbSwing * 0.33333334f + (float)Math.PI));
            player.rightLeg.xRot = MathHelper.lerp(player.swimAmount, player.rightLeg.xRot, 0.3f * MathHelper.cos(limbSwing * 0.33333334f));
        }
    }

    private static float rotLerpRad(float angleIn, float maxAngleIn, float mulIn) {
        float f = (mulIn - maxAngleIn) % ((float)Math.PI * 2);
        if (f < (float)(-Math.PI)) {
            f += (float)Math.PI * 2;
        }
        if (f >= (float)Math.PI) {
            f -= (float)Math.PI * 2;
        }
        return maxAngleIn + angleIn * f;
    }

    private static void bobArms(VanillaPartRenderer p_239101_0_, VanillaPartRenderer p_239101_1_, float p_239101_2_) {
        p_239101_0_.zRot += MathHelper.cos(p_239101_2_ * 0.09f) * 0.05f + 0.05f;
        p_239101_1_.zRot -= MathHelper.cos(p_239101_2_ * 0.09f) * 0.05f + 0.05f;
        p_239101_0_.xRot += MathHelper.sin(p_239101_2_ * 0.067f) * 0.05f;
        p_239101_1_.xRot -= MathHelper.sin(p_239101_2_ * 0.067f) * 0.05f;
    }

    private static void poseLeftArm(VanillaPlayerModel player) {
        switch (player.leftArmPose) {
            case EMPTY: {
                player.leftArm.yRot = 0.0f;
                break;
            }
            case BLOCK: {
                player.leftArm.xRot = player.leftArm.xRot * 0.5f - 0.9424779f;
                player.leftArm.yRot = 0.5235988f;
                break;
            }
            case ITEM: {
                player.leftArm.xRot = player.leftArm.xRot * 0.5f - 0.31415927f;
                player.leftArm.yRot = 0.0f;
                break;
            }
            case THROW_SPEAR: {
                player.leftArm.xRot = player.leftArm.xRot * 0.5f - (float)Math.PI;
                player.leftArm.yRot = 0.0f;
                break;
            }
            case BOW_AND_ARROW: {
                player.rightArm.yRot = -0.1f + player.head.yRot - 0.4f;
                player.leftArm.yRot = 0.1f + player.head.yRot;
                player.rightArm.xRot = -1.5707964f + player.head.xRot;
                player.leftArm.xRot = -1.5707964f + player.head.xRot;
                break;
            }
            case CROSSBOW_CHARGE: {
                PlayerModelSetup.animateCrossbowCharge(player.rightArm, player.leftArm, player.useAmount, false);
                break;
            }
            case CROSSBOW_HOLD: {
                PlayerModelSetup.animateCrossbowHold(player.rightArm, player.leftArm, player.head, false);
                break;
            }
            case SPYGLASS: {
                player.leftArm.xRot = MathHelper.clamp(player.head.xRot - 1.9198622f - (player.crouching ? 0.2617994f : 0.0f), -2.4f, 3.3f);
                player.leftArm.yRot = player.head.yRot + 0.2617994f;
                break;
            }
            case TOOT_HORN: {
                player.leftArm.xRot = MathHelper.clamp(player.head.xRot, -1.2f, 1.2f) - 1.4835298f;
                player.leftArm.yRot = player.head.yRot + 0.5235988f;
            }
        }
    }

    private static void poseRightArm(VanillaPlayerModel player) {
        switch (player.rightArmPose) {
            case EMPTY: {
                player.rightArm.yRot = 0.0f;
                break;
            }
            case BLOCK: {
                player.rightArm.xRot = player.rightArm.xRot * 0.5f - 0.9424779f;
                player.rightArm.yRot = -0.5235988f;
                break;
            }
            case ITEM: {
                player.rightArm.xRot = player.rightArm.xRot * 0.5f - 0.31415927f;
                player.rightArm.yRot = 0.0f;
                break;
            }
            case THROW_SPEAR: {
                player.rightArm.xRot = player.rightArm.xRot * 0.5f - (float)Math.PI;
                player.rightArm.yRot = 0.0f;
                break;
            }
            case BOW_AND_ARROW: {
                player.rightArm.yRot = -0.1f + player.head.yRot;
                player.leftArm.yRot = 0.1f + player.head.yRot + 0.4f;
                player.rightArm.xRot = -1.5707964f + player.head.xRot;
                player.leftArm.xRot = -1.5707964f + player.head.xRot;
                break;
            }
            case CROSSBOW_CHARGE: {
                PlayerModelSetup.animateCrossbowCharge(player.rightArm, player.leftArm, player.useAmount, true);
                break;
            }
            case CROSSBOW_HOLD: {
                PlayerModelSetup.animateCrossbowHold(player.rightArm, player.leftArm, player.head, true);
                break;
            }
            case SPYGLASS: {
                player.rightArm.xRot = MathHelper.clamp(player.head.xRot - 1.9198622f - (player.crouching ? 0.2617994f : 0.0f), -2.4f, 3.3f);
                player.rightArm.yRot = player.head.yRot - 0.2617994f;
                break;
            }
            case TOOT_HORN: {
                player.rightArm.xRot = MathHelper.clamp(player.head.xRot, -1.2f, 1.2f) - 1.4835298f;
                player.rightArm.yRot = player.head.yRot - 0.5235988f;
            }
        }
    }

    private static void setupAttackAnimation(VanillaPlayerModel player, Hand handside) {
        if (!(player.attackTime <= 0.0f)) {
            VanillaPartRenderer modelrenderer = PlayerModelSetup.getArmForSide(player, handside);
            float f = player.attackTime;
            player.body.yRot = MathHelper.sin(MathHelper.sqrt(f) * ((float)Math.PI * 2)) * 0.2f;
            if (handside == Hand.LEFT) {
                player.body.yRot *= -1.0f;
            }
            player.rightArm.z = MathHelper.sin(player.body.yRot) * 5.0f;
            player.rightArm.x = -MathHelper.cos(player.body.yRot) * 5.0f;
            player.leftArm.z = -MathHelper.sin(player.body.yRot) * 5.0f;
            player.leftArm.x = MathHelper.cos(player.body.yRot) * 5.0f;
            player.rightArm.yRot += player.body.yRot;
            player.leftArm.yRot += player.body.yRot;
            player.leftArm.xRot += player.body.yRot;
            f = 1.0f - player.attackTime;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = MathHelper.sin(f * (float)Math.PI);
            float f2 = MathHelper.sin(player.attackTime * (float)Math.PI) * -(player.head.xRot - 0.7f) * 0.75f;
            modelrenderer.xRot = (float)((double)modelrenderer.xRot - ((double)f1 * 1.2 + (double)f2));
            modelrenderer.yRot += player.body.yRot * 2.0f;
            modelrenderer.zRot += MathHelper.sin(player.attackTime * (float)Math.PI) * -0.4f;
        }
    }

    private static void animateCrossbowHold(VanillaPartRenderer p_239104_0_, VanillaPartRenderer p_239104_1_, VanillaPartRenderer p_239104_2_, boolean p_239104_3_) {
        VanillaPartRenderer modelrenderer = p_239104_3_ ? p_239104_0_ : p_239104_1_;
        VanillaPartRenderer modelrenderer1 = p_239104_3_ ? p_239104_1_ : p_239104_0_;
        modelrenderer.yRot = (p_239104_3_ ? -0.3f : 0.3f) + p_239104_2_.yRot;
        modelrenderer1.yRot = (p_239104_3_ ? 0.6f : -0.6f) + p_239104_2_.yRot;
        modelrenderer.xRot = -1.5707964f + p_239104_2_.xRot + 0.1f;
        modelrenderer1.xRot = -1.5f + p_239104_2_.xRot;
    }

    public static void animateCrossbowCharge(VanillaPartRenderer p_102087_, VanillaPartRenderer p_102088_, float chargeValue, boolean p_102090_) {
        VanillaPartRenderer modelpart = p_102090_ ? p_102087_ : p_102088_;
        VanillaPartRenderer modelpart1 = p_102090_ ? p_102088_ : p_102087_;
        modelpart.yRot = p_102090_ ? -0.8f : 0.8f;
        modelpart1.xRot = modelpart.xRot = -0.97079635f;
        modelpart1.yRot = MathHelper.lerp(chargeValue, 0.4f, 0.85f) * (float)(p_102090_ ? 1 : -1);
        modelpart1.xRot = MathHelper.lerp(chargeValue, modelpart1.xRot, -1.5707964f);
    }

    private static VanillaPartRenderer getArmForSide(VanillaPlayerModel player, Hand side) {
        return side == Hand.LEFT ? player.leftArm : player.rightArm;
    }

    private static float getArmAngleSq(float limbSwing) {
        return -65.0f * limbSwing + limbSwing * limbSwing;
    }

    public static void initDefaultPose(RootModelElement rme, VanillaModelPart part) {
        if (part == RootModelType.CAPE) {
            rme.defPos = new Vec3f(0.0f, 0.14999998f, 2.9f);
            rme.defRot = new Rotation(0.0f, (float)Math.toRadians(180.0), (float)(-Math.toRadians(6.0)), false);
        } else if (part == RootModelType.ELYTRA_LEFT) {
            rme.defPos = new Vec3f(5.0f, 0.0f, 0.0f);
            rme.defRot = new Rotation(0.2617994f, 0.0f, -0.2617994f, false);
        } else if (part == RootModelType.ELYTRA_RIGHT) {
            rme.defPos = new Vec3f(-5.0f, 0.0f, 0.0f);
            rme.defRot = new Rotation(0.2617994f, 0.0f, 0.2617994f, false);
        }
    }

    public static enum ArmPose {
        EMPTY(false),
        ITEM(false),
        BLOCK(false),
        BOW_AND_ARROW(true),
        THROW_SPEAR(false),
        CROSSBOW_CHARGE(true),
        CROSSBOW_HOLD(true),
        SPYGLASS(false),
        TOOT_HORN(false),
        BRUSH(false);

        public static final ArmPose[] VALUES;
        private final boolean twoHanded;

        private ArmPose(boolean p_i241257_3_) {
            this.twoHanded = p_i241257_3_;
        }

        public boolean isTwoHanded() {
            return this.twoHanded;
        }

        public static <T extends Enum<T>> ArmPose of(T value) {
            for (int i = 0; i < VALUES.length; ++i) {
                ArmPose armPose = VALUES[i];
                if (!armPose.name().equals(value.name())) continue;
                return armPose;
            }
            return EMPTY;
        }

        static {
            VALUES = ArmPose.values();
        }
    }
}

