/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts.anim;

import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.parts.anim.AnimLoaderState;
import com.tom.cpm.shared.parts.anim.ConstantTimeBool;
import com.tom.cpm.shared.parts.anim.ConstantTimeFloat;
import com.tom.cpm.shared.parts.anim.ParameterDetails;
import com.tom.cpm.shared.parts.anim.SerializedAnimation;
import com.tom.cpm.shared.parts.anim.SerializedTrigger;
import com.tom.cpm.shared.parts.anim.StagedAnimInfo;
import com.tom.cpm.shared.parts.anim.menu.AbstractGestureButtonData;
import java.io.IOException;

public enum TagType {
    END((a, b) -> {}),
    NEW_ANIM(SerializedAnimation::newAnimation),
    NEW_TRIGGER(SerializedTrigger::newTrigger),
    INIT_BUILTIN_TRIGGER(SerializedTrigger::initBuiltin),
    INIT_NAMED_TRIGGER(SerializedTrigger::initNamed),
    INIT_PARAMETER_TRIGGER(SerializedTrigger::initParameter),
    INIT_STAGED_TRIGGER(SerializedTrigger::initStaged),
    CONSTANT_FRAME_TIME_FLOAT(ConstantTimeFloat::parse),
    CONSTANT_FRAME_TIME_BOOLEAN(ConstantTimeBool::parse),
    CUBES_TO_CHANNELS(SerializedAnimation::addCubesToChannels),
    CONTROL_INFO(AnimLoaderState::parseInfo),
    GESTURE_BUTTON(AbstractGestureButtonData::parse),
    PARAMETERS(ParameterDetails::parse),
    INIT_STAGED_ANIM(StagedAnimInfo::parse);

    public static final TagType[] VALUES;
    private final Handler handler;

    private TagType(Handler handler) {
        this.handler = handler;
    }

    public static IOHelper.ObjectReader<TagType, TagType> read(AnimLoaderState state) throws IOException {
        return (t, din) -> {
            t.handler.load(din, state);
            return t;
        };
    }

    static {
        VALUES = TagType.values();
    }

    @FunctionalInterface
    public static interface Handler {
        public void load(IOHelper var1, AnimLoaderState var2) throws IOException;
    }
}

