/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.api.conduit.ticker;

import com.enderio.api.conduit.ColoredRedstoneProvider;
import com.enderio.api.conduit.ConduitData;
import com.enderio.api.conduit.ConduitGraph;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.ticker.IOAwareConduitTicker;
import com.enderio.api.conduit.upgrade.ConduitUpgrade;
import com.enderio.api.filter.ResourceFilter;
import com.enderio.api.misc.ColorControl;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.Nullable;

public abstract class CapabilityAwareConduitTicker<TData extends ConduitData<TData>, TCap>
implements IOAwareConduitTicker<TData> {
    @Override
    public final void tickColoredGraph(ServerLevel level, ConduitType<TData> type, List<IOAwareConduitTicker.Connection<TData>> inserts, List<IOAwareConduitTicker.Connection<TData>> extracts, ColorControl color, ConduitGraph<TData> graph, ColoredRedstoneProvider coloredRedstoneProvider) {
        ArrayList<CapabilityConnection> insertCaps = new ArrayList<CapabilityConnection>();
        for (IOAwareConduitTicker.Connection<TData> insert : inserts) {
            Optional.ofNullable(level.m_7702_(insert.move())).flatMap(b -> b.getCapability(this.getCapability(), insert.dir().m_122424_()).resolve()).ifPresent(cap -> insertCaps.add(new CapabilityConnection(this, cap, insert.data(), insert.dir(), insert.upgrade(), insert.extractFilter(), insert.insertFilter())));
        }
        if (!insertCaps.isEmpty()) {
            ArrayList<CapabilityConnection> extractCaps = new ArrayList<CapabilityConnection>();
            for (IOAwareConduitTicker.Connection<TData> extract : extracts) {
                Optional.ofNullable(level.m_7702_(extract.move())).flatMap(b -> b.getCapability(this.getCapability(), extract.dir().m_122424_()).resolve()).ifPresent(cap -> extractCaps.add(new CapabilityConnection(this, cap, extract.data(), extract.dir(), extract.upgrade(), extract.extractFilter(), extract.insertFilter())));
            }
            if (!extractCaps.isEmpty()) {
                this.tickCapabilityGraph(level, type, insertCaps, extractCaps, graph, coloredRedstoneProvider);
            }
        }
    }

    @Override
    public boolean canConnectTo(Level level, BlockPos conduitPos, Direction direction) {
        return Optional.ofNullable(level.m_7702_(conduitPos.m_121945_(direction))).flatMap(be -> be.getCapability(this.getCapability(), direction.m_122424_()).resolve()).isPresent();
    }

    protected abstract void tickCapabilityGraph(ServerLevel var1, ConduitType<TData> var2, List<CapabilityConnection> var3, List<CapabilityConnection> var4, ConduitGraph<TData> var5, ColoredRedstoneProvider var6);

    protected abstract Capability<TCap> getCapability();

    public static final class CapabilityConnection {
        public final TCap capability;
        public final TData data;
        public final Direction direction;
        @Nullable
        public final ConduitUpgrade upgrade;
        @Nullable
        public final ResourceFilter extractFilter;
        @Nullable
        public final ResourceFilter insertFilter;
        final /* synthetic */ CapabilityAwareConduitTicker this$0;

        public CapabilityConnection(TCap capability, TData data, @Nullable Direction direction, @Nullable ConduitUpgrade upgrade, @Nullable ResourceFilter extractFilter, ResourceFilter insertFilter) {
            this.this$0 = this$0;
            this.capability = capability;
            this.data = data;
            this.direction = direction;
            this.upgrade = upgrade;
            this.extractFilter = extractFilter;
            this.insertFilter = insertFilter;
        }
    }
}

