/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.armory.common.item.darksteel.upgrades;

import com.enderio.api.capability.IDarkSteelUpgrade;
import com.enderio.armory.common.item.darksteel.upgrades.IUpgradeTier;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

public abstract class TieredUpgrade<T extends IUpgradeTier>
implements IDarkSteelUpgrade {
    public static final String TIER_KEY = "tier";
    protected T tier;
    private final String serializedName;

    protected TieredUpgrade(T tier, String serializedName) {
        this.tier = tier;
        this.serializedName = serializedName;
    }

    @Override
    public boolean isBaseTier() {
        return this.tier.getLevel() == 0;
    }

    @Override
    public Optional<? extends IDarkSteelUpgrade> getNextTier() {
        return this.getUpgradeForTier(this.tier.getLevel() + 1);
    }

    @Override
    public boolean isValidUpgrade(IDarkSteelUpgrade upgrade) {
        if (this.getName().equals(upgrade.getName()) && upgrade instanceof TieredUpgrade) {
            TieredUpgrade up = (TieredUpgrade)upgrade;
            return up.tier.getLevel() == this.tier.getLevel() + 1;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.serializedName;
    }

    @Override
    public Component getDisplayName() {
        return this.tier.getDisplayName();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(TIER_KEY, this.tier.getLevel());
        return nbt;
    }

    @Override
    public void deserializeNBT(Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag nbt = (CompoundTag)tag;
            int level = nbt.m_128451_(TIER_KEY);
            this.tier = (IUpgradeTier)this.getTier(level).orElse(this.getBaseTier());
        }
    }

    protected Optional<? extends IDarkSteelUpgrade> getUpgradeForTier(int level) {
        return this.getTier(level).map(upgradeTier -> upgradeTier.getFactory().get());
    }

    protected abstract T getBaseTier();

    protected abstract Optional<T> getTier(int var1);
}

