/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.client.gui.screen;

import com.enderio.EnderIO;
import com.enderio.api.misc.Vector2i;
import com.enderio.base.common.lang.EIOLang;
import com.enderio.base.common.menu.FluidFilterMenu;
import com.enderio.core.client.gui.screen.EIOScreen;
import com.enderio.core.client.gui.widgets.EIOImageButton;
import com.enderio.core.client.gui.widgets.ToggleImageButton;
import com.enderio.core.common.capability.FluidFilterCapability;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.NotImplementedException;

public class FluidFilterScreen
extends EIOScreen<FluidFilterMenu> {
    private static final Vector2i BG_SIZE = new Vector2i(183, 201);
    private static ResourceLocation BG_TEXTURE = EnderIO.loc("textures/gui/40/item_filter.png");
    private static final ResourceLocation BLACKLIST_TEXTURE = EnderIO.loc("textures/gui/icons/blacklist.png");
    private static final ResourceLocation NBT_TEXTURE = EnderIO.loc("textures/gui/icons/range_buttons.png");
    private static final ResourceLocation BACK_TEXTURE = EnderIO.loc("textures/gui/icons/back.png");

    public FluidFilterScreen(FluidFilterMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        BG_TEXTURE = switch (pMenu.getFilter().size()) {
            case 5 -> EnderIO.loc("textures/gui/40/basic_item_filter.png");
            case 10 -> EnderIO.loc("textures/gui/40/advanced_item_filter.png");
            case 36 -> EnderIO.loc("textures/gui/40/big_item_filter.png");
            default -> throw new NotImplementedException();
        };
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new ToggleImageButton<FluidFilterScreen>(this, this.getGuiLeft() + 110, this.getGuiTop() + 36, 16, 16, 0, 0, 16, 0, NBT_TEXTURE, ((FluidFilterMenu)this.m_6262_()).getFilter()::isNbt, ((FluidFilterMenu)this.m_6262_())::setNbt, () -> ((FluidFilterMenu)this.m_6262_()).getFilter().isNbt() ? EIOLang.NBT_FILTER : EIOLang.NO_NBT_FILTER));
        this.m_142416_((GuiEventListener)new ToggleImageButton<FluidFilterScreen>(this, this.getGuiLeft() + 110, this.getGuiTop() + 36 + 20, 16, 16, 0, 0, 16, 0, BLACKLIST_TEXTURE, ((FluidFilterMenu)this.m_6262_()).getFilter()::isInvert, ((FluidFilterMenu)this.m_6262_())::setInverted, () -> ((FluidFilterMenu)this.m_6262_()).getFilter().isInvert() ? EIOLang.BLACKLIST_FILTER : EIOLang.WHITELIST_FILTER));
        this.m_142416_((GuiEventListener)new EIOImageButton(this, this.getGuiLeft() + 3, this.getGuiTop() + 3, 16, 16, 0, 0, 0, BACK_TEXTURE, button -> this.closeContainer()));
    }

    public void m_280092_(GuiGraphics pGuiGraphics, Slot pSlot) {
        AbstractTexture texture;
        FluidFilterCapability filterCapability = ((FluidFilterMenu)this.m_6262_()).getFilter();
        if (pSlot.f_40219_ >= filterCapability.size()) {
            super.m_280092_(pGuiGraphics, pSlot);
            return;
        }
        FluidStack fluidStack = filterCapability.getEntry(pSlot.f_40219_);
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        ResourceLocation still = props.getStillTexture(fluidStack);
        if (still != null && (texture = this.f_96541_.m_91097_().m_118506_(TextureAtlas.f_118259_)) instanceof TextureAtlas) {
            TextureAtlas atlas = (TextureAtlas)texture;
            TextureAtlasSprite sprite = atlas.m_118316_(still);
            int color = props.getTintColor();
            RenderSystem.setShaderColor((float)((float)FastColor.ARGB32.m_13665_((int)color) / 255.0f), (float)((float)FastColor.ARGB32.m_13667_((int)color) / 255.0f), (float)((float)FastColor.ARGB32.m_13669_((int)color) / 255.0f), (float)((float)FastColor.ARGB32.m_13655_((int)color) / 255.0f));
            RenderSystem.enableBlend();
            int atlasWidth = (int)((float)sprite.m_245424_().m_246492_() / (sprite.m_118410_() - sprite.m_118409_()));
            int atlasHeight = (int)((float)sprite.m_245424_().m_245330_() / (sprite.m_118412_() - sprite.m_118411_()));
            pGuiGraphics.m_280411_(TextureAtlas.f_118259_, pSlot.f_40220_, pSlot.f_40221_, 16, 16, sprite.m_118409_() * (float)atlasWidth, sprite.m_118411_() * (float)atlasHeight, sprite.m_245424_().m_246492_(), sprite.m_245424_().m_245330_(), atlasWidth, atlasHeight);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public ResourceLocation getBackgroundImage() {
        return BG_TEXTURE;
    }

    @Override
    protected Vector2i getBackgroundImageSize() {
        return BG_SIZE;
    }
}

