/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.network.slot;

import com.enderio.core.common.network.slot.NetworkDataSlot;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class EnumNetworkDataSlot<T extends Enum<T>>
extends NetworkDataSlot<T> {
    private final Class<T> enumClass;

    public EnumNetworkDataSlot(Class<T> enumClass, Supplier<T> getter, Consumer<T> setter) {
        super(getter, setter);
        this.enumClass = enumClass;
    }

    @Override
    public Tag serializeValueNBT(T value) {
        return IntTag.m_128679_((int)((Enum)value).ordinal());
    }

    @Override
    protected T valueFromNBT(Tag nbt) {
        if (nbt instanceof IntTag) {
            IntTag intTag = (IntTag)nbt;
            return (T)((Enum[])this.enumClass.getEnumConstants())[intTag.m_7047_()];
        }
        throw new IllegalStateException("Invalid enum/int tag was passed over the network.");
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, T value) {
        buf.writeInt(((Enum)value).ordinal());
    }

    @Override
    public T valueFromBuffer(FriendlyByteBuf buf) {
        try {
            return (T)((Enum[])this.enumClass.getEnumConstants())[buf.readInt()];
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid enum/int buffer was passed over the network.");
        }
    }
}

