/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.network.slot;

import com.enderio.core.common.network.slot.NBTSerializingNetworkDataSlot;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.INBTSerializable;

public class NBTSerializableNetworkDataSlot<T extends INBTSerializable<CompoundTag>>
extends NBTSerializingNetworkDataSlot<T> {
    private final Callback setterCallback;

    public NBTSerializableNetworkDataSlot(Supplier<T> getter) {
        this(getter, () -> {});
    }

    public NBTSerializableNetworkDataSlot(Supplier<T> getter, Callback setterCallback) {
        this(getter, setterCallback, (t, friendlyByteBuf) -> friendlyByteBuf.m_130079_((CompoundTag)t.serializeNBT()), friendlyByteBuf -> {
            CompoundTag tag = friendlyByteBuf.m_130260_();
            INBTSerializable t = (INBTSerializable)getter.get();
            t.deserializeNBT((Tag)tag);
            return t;
        });
    }

    public NBTSerializableNetworkDataSlot(Supplier<T> getter, Callback setterCallback, BiConsumer<T, FriendlyByteBuf> toBuffer, Function<FriendlyByteBuf, T> fromBuffer) {
        super(getter, INBTSerializable::serializeNBT, INBTSerializable::deserializeNBT, toBuffer, fromBuffer);
        this.setterCallback = setterCallback;
    }

    @Override
    public void fromNBT(Tag nbt) {
        super.fromNBT(nbt);
        this.setterCallback.call();
    }

    @Override
    public void fromBuffer(FriendlyByteBuf buf) {
        super.fromBuffer(buf);
        this.setterCallback.call();
    }

    public static interface Callback {
        public void call();
    }
}

