/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.io.item;

import com.enderio.machines.common.io.item.SingleSlotAccess;
import java.util.ArrayList;
import java.util.List;

public class MultiSlotAccess {
    private List<SingleSlotAccess> accesses = null;

    void init(int index, int size) {
        ArrayList<SingleSlotAccess> accesses = new ArrayList<SingleSlotAccess>();
        for (int i = 0; i < size; ++i) {
            SingleSlotAccess access = new SingleSlotAccess();
            access.init(i + index);
            accesses.add(access);
        }
        this.accesses = accesses;
    }

    public int size() {
        return this.accesses.size();
    }

    public SingleSlotAccess get(int index) {
        return this.accesses.get(index);
    }

    public List<SingleSlotAccess> getAccesses() {
        return this.accesses;
    }

    public boolean contains(int slotIndex) {
        return slotIndex >= this.accesses.get(0).getIndex() && slotIndex <= this.accesses.get(this.accesses.size() - 1).getIndex();
    }

    public static MultiSlotAccess wrap(SingleSlotAccess access) {
        MultiSlotAccess multi = new MultiSlotAccess();
        multi.accesses = List.of(access);
        return multi;
    }
}

