/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.item;

import com.enderio.base.common.lang.EIOLang;
import com.enderio.core.client.item.IAdvancedTooltipProvider;
import com.enderio.core.common.util.TooltipUtil;
import com.enderio.machines.client.rendering.item.FluidTankBEWLR;
import com.enderio.machines.common.block.MachineBlock;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidTankItem
extends BlockItem
implements IAdvancedTooltipProvider {
    protected final int capacity;

    public FluidTankItem(MachineBlock block, Item.Properties properties, int capacity) {
        super((Block)block, properties);
        this.capacity = capacity;
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            final NonNullLazy<BlockEntityWithoutLevelRenderer> renderer = NonNullLazy.of(() -> FluidTankBEWLR.INSTANCE);

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.renderer.get();
            }
        });
    }

    @Override
    public void addCommonTooltips(ItemStack itemStack, @Nullable Player player, List<Component> tooltips) {
        itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(iFluidHandlerItem -> {
            if (iFluidHandlerItem instanceof FluidItemStack) {
                FluidItemStack fluidHandler = (FluidItemStack)((Object)iFluidHandlerItem);
                if (fluidHandler.getFluid().isEmpty()) {
                    tooltips.add(TooltipUtil.style(EIOLang.TANK_EMPTY_STRING));
                } else {
                    tooltips.add(TooltipUtil.styledWithArgs(EIOLang.FLUID_TANK_TOOLTIP, fluidHandler.getFluid().getAmount(), this.capacity, fluidHandler.getFluid().getFluid().getFluidType().getDescription().getString()));
                }
            }
        });
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidItemStack(stack, this.capacity);
    }

    public class FluidItemStack
    extends FluidHandlerItemStack {
        public FluidItemStack(ItemStack container, int capacity) {
            super(container, capacity);
        }

        @NotNull
        public FluidStack getFluid() {
            CompoundTag itemTag = this.container.m_41783_();
            if (itemTag == null) {
                return FluidStack.EMPTY;
            }
            if (!itemTag.m_128441_("BlockEntityTag")) {
                return FluidStack.EMPTY;
            }
            CompoundTag blockEntityTag = itemTag.m_128469_("BlockEntityTag");
            if (!blockEntityTag.m_128441_("Fluid")) {
                return FluidStack.EMPTY;
            }
            CompoundTag fluidContainerTag = blockEntityTag.m_128469_("Fluid");
            if (fluidContainerTag.m_128441_("Tanks")) {
                ListTag tankList = fluidContainerTag.m_128437_("Tanks", 10);
                if (tankList.isEmpty()) {
                    return FluidStack.EMPTY;
                }
                CompoundTag firstTank = tankList.m_128728_(0);
                return FluidStack.loadFluidStackFromNBT((CompoundTag)firstTank);
            }
            return FluidStack.loadFluidStackFromNBT((CompoundTag)blockEntityTag.m_128469_("Fluid"));
        }

        protected void setFluid(FluidStack fluid) {
            CompoundTag tankTag;
            ListTag tankList;
            CompoundTag fluidContainerTag;
            CompoundTag blockEntityTag;
            CompoundTag mainTag = this.container.m_41784_();
            if (mainTag.m_128441_("BlockEntityTag")) {
                blockEntityTag = mainTag.m_128469_("BlockEntityTag");
            } else {
                blockEntityTag = new CompoundTag();
                mainTag.m_128365_("BlockEntityTag", (Tag)blockEntityTag);
            }
            if (blockEntityTag.m_128441_("Fluid")) {
                fluidContainerTag = blockEntityTag.m_128469_("Fluid");
            } else {
                fluidContainerTag = new CompoundTag();
                fluidContainerTag.m_128405_("Size", 1);
                blockEntityTag.m_128365_("Fluid", (Tag)fluidContainerTag);
            }
            if (fluidContainerTag.m_128441_("Tanks")) {
                tankList = fluidContainerTag.m_128437_("Tanks", 10);
            } else {
                tankList = new ListTag();
                fluidContainerTag.m_128365_("Tanks", (Tag)tankList);
            }
            if (!tankList.isEmpty()) {
                tankTag = tankList.m_128728_(0);
            } else {
                tankTag = new CompoundTag();
                tankTag.m_128405_("Capacity", this.capacity);
                tankList.add((Object)tankTag);
            }
            fluid.writeToNBT(tankTag);
        }

        protected void setContainerToEmpty() {
            CompoundTag blockEntityTag;
            CompoundTag tagCompound = this.container.m_41783_();
            if (tagCompound != null && (blockEntityTag = tagCompound.m_128469_("BlockEntityTag")).m_128441_("Fluid")) {
                blockEntityTag.m_128473_("Fluid");
            }
        }
    }
}

