/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.function.IntSupplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.fluid.VariableCapacityFluidTank;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.generators.common.GeneratorTags;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.registries.GeneratorsFluids;
import mekanism.generators.common.slot.FluidFuelInventorySlot;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityBioGenerator
extends TileEntityGenerator {
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getBioFuel", "getBioFuelCapacity", "getBioFuelNeeded", "getBioFuelFilledPercentage"}, docPlaceholder="biofuel tank")
    public BasicFluidTank bioFuelTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getFuelItem"}, docPlaceholder="fuel slot")
    FluidFuelInventorySlot fuelSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy item")
    EnergyInventorySlot energySlot;
    private float lastFluidScale;

    public TileEntityBioGenerator(BlockPos pos, BlockState state) {
        super((IBlockProvider)GeneratorsBlocks.BIO_GENERATOR, pos, state, (FloatingLongSupplier)MekanismGeneratorsConfig.generators.bioGeneration);
    }

    @NotNull
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        FluidTankHelper builder = FluidTankHelper.forSide(() -> ((TileEntityBioGenerator)this).getDirection());
        this.bioFuelTank = VariableCapacityFluidTank.input((IntSupplier)MekanismGeneratorsConfig.generators.bioTankCapacity, fluidStack -> GeneratorTags.Fluids.BIOETHANOL_LOOKUP.contains((Object)fluidStack.getFluid()), (IContentsListener)listener);
        builder.addTank((IExtendedFluidTank)this.bioFuelTank, new RelativeSide[]{RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.BACK, RelativeSide.TOP, RelativeSide.BOTTOM});
        return builder.build();
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((TileEntityBioGenerator)this).getDirection());
        this.fuelSlot = FluidFuelInventorySlot.forFuel((IExtendedFluidTank)this.bioFuelTank, stack -> stack.m_204117_(MekanismTags.Items.FUELS_BIO) ? 200 : 0, (Int2ObjectFunction<FluidStack>)((Int2ObjectFunction)arg_0 -> GeneratorsFluids.BIOETHANOL.getFluidStack(arg_0)), listener, 17, 35);
        builder.addSlot((IInventorySlot)this.fuelSlot, new RelativeSide[]{RelativeSide.FRONT, RelativeSide.LEFT, RelativeSide.BACK, RelativeSide.TOP, RelativeSide.BOTTOM});
        this.energySlot = EnergyInventorySlot.drain((IEnergyContainer)this.getEnergyContainer(), (IContentsListener)listener, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot, new RelativeSide[]{RelativeSide.RIGHT});
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.drainContainer();
        this.fuelSlot.fillOrBurn();
        if (MekanismUtils.canFunction((TileEntityMekanism)this) && !this.bioFuelTank.isEmpty() && this.getEnergyContainer().insert((FloatingLong)MekanismGeneratorsConfig.generators.bioGeneration.get(), Action.SIMULATE, AutomationType.INTERNAL).isZero()) {
            this.setActive(true);
            MekanismUtils.logMismatchedStackSize((long)this.bioFuelTank.shrinkStack(1, Action.EXECUTE), (long)1L);
            this.getEnergyContainer().insert((FloatingLong)MekanismGeneratorsConfig.generators.bioGeneration.get(), Action.EXECUTE, AutomationType.INTERNAL);
            float fluidScale = MekanismUtils.getScale((float)this.lastFluidScale, (IExtendedFluidTank)this.bioFuelTank);
            if (fluidScale != this.lastFluidScale) {
                this.lastFluidScale = fluidScale;
                this.sendUpdatePacket();
            }
        } else {
            this.setActive(false);
        }
    }

    @NotNull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag updateTag = super.getReducedUpdateTag();
        updateTag.m_128365_("fluid", (Tag)this.bioFuelTank.serializeNBT());
        return updateTag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setCompoundIfPresent((CompoundTag)tag, (String)"fluid", nbt -> this.bioFuelTank.deserializeNBT(nbt));
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.bioFuelTank.getFluidAmount(), (long)this.bioFuelTank.getCapacity());
    }

    protected boolean makesComparatorDirty(@Nullable SubstanceType type) {
        return type == SubstanceType.FLUID;
    }

    @Override
    FloatingLong getProductionRate() {
        return this.getActive() ? (FloatingLong)MekanismGeneratorsConfig.generators.bioGeneration.get() : FloatingLong.ZERO;
    }
}

