/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.impl.network.wired;

import dan200.computercraft.impl.network.wired.WiredNetworkImpl;
import dan200.computercraft.impl.network.wired.WiredNodeImpl;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InvariantChecker {
    private static final Logger LOG = LoggerFactory.getLogger(InvariantChecker.class);

    private InvariantChecker() {
    }

    static void checkNode(WiredNodeImpl node) {
        assert (InvariantChecker.checkNodeImpl(node)) : "Node invariants failed. See logs.";
    }

    private static boolean checkNodeImpl(WiredNodeImpl node) {
        WiredNetworkImpl network;
        boolean okay = true;
        if (node.currentSet != null) {
            okay = false;
            LOG.error("{}: currentSet was not cleared.", (Object)node);
        }
        if ((network = InvariantChecker.makeNullable(node.network)) == null) {
            okay = false;
            LOG.error("{}: Node's network is null.", (Object)node);
        } else if (InvariantChecker.makeNullable(network.nodes) == null || !network.nodes.contains(node)) {
            okay = false;
            LOG.error("{}: Node's network does not contain node.", (Object)node);
        }
        for (WiredNodeImpl neighbour : node.neighbours) {
            if (neighbour.neighbours.contains(node)) continue;
            okay = false;
            LOG.error("{}: Neighbour {}'s neighbour set does not contain origianl node.", (Object)node, (Object)neighbour);
        }
        return okay;
    }

    static void checkNetwork(WiredNetworkImpl network) {
        assert (InvariantChecker.checkNetworkImpl(network)) : "Network invariants failed. See logs.";
    }

    private static boolean checkNetworkImpl(WiredNetworkImpl network) {
        boolean okay = true;
        for (WiredNodeImpl node : network.nodes) {
            okay &= InvariantChecker.checkNodeImpl(node);
        }
        return okay;
    }

    private static <T> @Nullable T makeNullable(T object) {
        return object;
    }
}

