/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.peripherals;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.AbstractPocketUpgrade;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.pocket.peripherals.PocketModemPeripheral;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

public class PocketModem
extends AbstractPocketUpgrade {
    private final boolean advanced;

    public PocketModem(ResourceLocation id, ItemStack stack, boolean advanced) {
        super(id, advanced ? "upgrade.computercraft.wireless_modem_advanced.adjective" : "upgrade.computercraft.wireless_modem_normal.adjective", stack);
        this.advanced = advanced;
    }

    @Override
    public @Nullable IPeripheral createPeripheral(IPocketAccess access) {
        return new PocketModemPeripheral(this.advanced, access);
    }

    @Override
    public void update(IPocketAccess access, @Nullable IPeripheral peripheral) {
        if (!(peripheral instanceof PocketModemPeripheral)) {
            return;
        }
        PocketModemPeripheral modem = (PocketModemPeripheral)peripheral;
        ModemState state = modem.getModemState();
        if (state.pollChanged()) {
            access.setLight(state.isOpen() ? 0xBA0000 : -1);
        }
    }
}

