/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.ngram;

import guideme.internal.shaded.lucene.analysis.Tokenizer;
import guideme.internal.shaded.lucene.analysis.TokenizerFactory;
import guideme.internal.shaded.lucene.analysis.ngram.NGramTokenizer;
import guideme.internal.shaded.lucene.util.AttributeFactory;
import java.util.Map;

public class NGramTokenizerFactory
extends TokenizerFactory {
    public static final String NAME = "nGram";
    private final int maxGramSize;
    private final int minGramSize;

    public NGramTokenizerFactory(Map<String, String> args) {
        super(args);
        this.minGramSize = this.getInt(args, "minGramSize", 1);
        this.maxGramSize = this.getInt(args, "maxGramSize", 2);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public NGramTokenizerFactory() {
        throw NGramTokenizerFactory.defaultCtorException();
    }

    @Override
    public Tokenizer create(AttributeFactory factory) {
        return new NGramTokenizer(factory, this.minGramSize, this.maxGramSize);
    }
}

