/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet.taxonomy;

import guideme.internal.shaded.lucene.facet.FacetUtils;
import guideme.internal.shaded.lucene.facet.FacetsCollector;
import guideme.internal.shaded.lucene.facet.FacetsConfig;
import guideme.internal.shaded.lucene.facet.taxonomy.AssociationAggregationFunction;
import guideme.internal.shaded.lucene.facet.taxonomy.FloatTaxonomyFacets;
import guideme.internal.shaded.lucene.facet.taxonomy.OrdinalsReader;
import guideme.internal.shaded.lucene.facet.taxonomy.TaxonomyReader;
import guideme.internal.shaded.lucene.index.BinaryDocValues;
import guideme.internal.shaded.lucene.index.DocValues;
import guideme.internal.shaded.lucene.index.SortedNumericDocValues;
import guideme.internal.shaded.lucene.search.ConjunctionUtils;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.DoubleValues;
import guideme.internal.shaded.lucene.search.DoubleValuesSource;
import guideme.internal.shaded.lucene.util.BitUtil;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.IntsRef;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class TaxonomyFacetFloatAssociations
extends FloatTaxonomyFacets {
    private final OrdinalsReader ordinalsReader;

    public TaxonomyFacetFloatAssociations(TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, AssociationAggregationFunction aggregationFunction) throws IOException {
        this("$facets", taxoReader, config, fc, aggregationFunction);
    }

    public TaxonomyFacetFloatAssociations(TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, AssociationAggregationFunction aggregationFunction, DoubleValuesSource valuesSource) throws IOException {
        this("$facets", taxoReader, config, fc, aggregationFunction, valuesSource);
    }

    public TaxonomyFacetFloatAssociations(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, AssociationAggregationFunction aggregationFunction) throws IOException {
        super(indexFieldName, taxoReader, aggregationFunction, config, fc);
        this.ordinalsReader = null;
        this.aggregateValues(aggregationFunction, fc.getMatchingDocs());
    }

    public TaxonomyFacetFloatAssociations(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, AssociationAggregationFunction aggregationFunction, DoubleValuesSource valuesSource) throws IOException {
        super(indexFieldName, taxoReader, aggregationFunction, config, fc);
        this.ordinalsReader = null;
        this.aggregateValues(aggregationFunction, fc.getMatchingDocs(), fc.getKeepScores(), valuesSource);
    }

    @Deprecated
    public TaxonomyFacetFloatAssociations(OrdinalsReader ordinalsReader, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, AssociationAggregationFunction aggregationFunction, DoubleValuesSource valuesSource) throws IOException {
        super(ordinalsReader.getIndexFieldName(), taxoReader, aggregationFunction, config, fc);
        this.ordinalsReader = ordinalsReader;
        this.aggregateValues(aggregationFunction, fc.getMatchingDocs(), fc.getKeepScores(), valuesSource);
    }

    private static DoubleValues scores(final FacetsCollector.MatchingDocs hits) {
        return new DoubleValues(){
            int index = -1;

            @Override
            public double doubleValue() throws IOException {
                return hits.scores[this.index];
            }

            @Override
            public boolean advanceExact(int doc) throws IOException {
                this.index = doc;
                return true;
            }
        };
    }

    private void aggregateValues(AssociationAggregationFunction aggregationFunction, List<FacetsCollector.MatchingDocs> matchingDocs, boolean keepScores, DoubleValuesSource valueSource) throws IOException {
        if (this.ordinalsReader != null) {
            IntsRef scratch = new IntsRef();
            for (FacetsCollector.MatchingDocs hits : matchingDocs) {
                int doc;
                if (hits.totalHits == 0) continue;
                this.initializeValueCounters();
                OrdinalsReader.OrdinalsSegmentReader ords = this.ordinalsReader.getReader(hits.context);
                DoubleValues scores = keepScores ? TaxonomyFacetFloatAssociations.scores(hits) : null;
                DoubleValues functionValues = valueSource.getValues(hits.context, scores);
                DocIdSetIterator docs = hits.bits.iterator();
                while ((doc = docs.nextDoc()) != Integer.MAX_VALUE) {
                    ords.get(doc, scratch);
                    if (!functionValues.advanceExact(doc)) continue;
                    float value = (float)functionValues.doubleValue();
                    for (int i = 0; i < scratch.length; ++i) {
                        int ord = scratch.ints[i];
                        float currentValue = this.getValue(ord);
                        float newValue = aggregationFunction.aggregate(currentValue, value);
                        this.setValue(ord, newValue);
                        this.setCount(ord, this.getCount(ord) + 1);
                    }
                }
            }
        } else {
            for (FacetsCollector.MatchingDocs hits : matchingDocs) {
                if (hits.totalHits == 0) continue;
                this.initializeValueCounters();
                SortedNumericDocValues ordinalValues = FacetUtils.loadOrdinalValues(hits.context.reader(), this.indexFieldName);
                if (ordinalValues == null) continue;
                DoubleValues scores = keepScores ? TaxonomyFacetFloatAssociations.scores(hits) : null;
                DoubleValues functionValues = valueSource.getValues(hits.context, scores);
                DocIdSetIterator it = ConjunctionUtils.intersectIterators(List.of(hits.bits.iterator(), ordinalValues));
                int doc = it.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if (functionValues.advanceExact(doc)) {
                        float value = (float)functionValues.doubleValue();
                        int ordinalCount = ordinalValues.docValueCount();
                        for (int i = 0; i < ordinalCount; ++i) {
                            int ord = (int)ordinalValues.nextValue();
                            float currentValue = this.getValue(ord);
                            float newValue = aggregationFunction.aggregate(currentValue, value);
                            this.setValue(ord, newValue);
                            this.setCount(ord, this.getCount(ord) + 1);
                        }
                    }
                    doc = it.nextDoc();
                }
            }
        }
        this.rollup();
    }

    private void aggregateValues(AssociationAggregationFunction aggregationFunction, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            if (hits.totalHits == 0) continue;
            this.initializeValueCounters();
            BinaryDocValues dv = DocValues.getBinary(hits.context.reader(), this.indexFieldName);
            DocIdSetIterator it = ConjunctionUtils.intersectIterators(Arrays.asList(hits.bits.iterator(), dv));
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                BytesRef bytesRef = dv.binaryValue();
                byte[] bytes = bytesRef.bytes;
                int end = bytesRef.offset + bytesRef.length;
                for (int offset = bytesRef.offset; offset < end; offset += 4) {
                    int ord = BitUtil.VH_BE_INT.get(bytes, offset);
                    float value = BitUtil.VH_BE_FLOAT.get(bytes, offset += 4);
                    float currentValue = this.getValue(ord);
                    float newValue = aggregationFunction.aggregate(currentValue, value);
                    this.setValue(ord, newValue);
                    this.setCount(ord, this.getCount(ord) + 1);
                }
                doc = it.nextDoc();
            }
        }
    }
}

