/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.bkd;

import guideme.internal.shaded.lucene.codecs.CodecUtil;
import guideme.internal.shaded.lucene.store.Directory;
import guideme.internal.shaded.lucene.store.IOContext;
import guideme.internal.shaded.lucene.store.IndexOutput;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.bkd.BKDConfig;
import guideme.internal.shaded.lucene.util.bkd.OfflinePointReader;
import guideme.internal.shaded.lucene.util.bkd.PointReader;
import guideme.internal.shaded.lucene.util.bkd.PointValue;
import guideme.internal.shaded.lucene.util.bkd.PointWriter;
import java.io.IOException;

public final class OfflinePointWriter
implements PointWriter {
    final Directory tempDir;
    public final IndexOutput out;
    public final String name;
    final BKDConfig config;
    long count;
    private boolean closed;
    final long expectedCount;

    public OfflinePointWriter(BKDConfig config, Directory tempDir, String tempFileNamePrefix, String desc, long expectedCount) throws IOException {
        this.out = tempDir.createTempOutput(tempFileNamePrefix, "bkd_" + desc, IOContext.DEFAULT);
        this.name = this.out.getName();
        this.tempDir = tempDir;
        this.config = config;
        this.expectedCount = expectedCount;
    }

    @Override
    public void append(byte[] packedValue, int docID) throws IOException {
        assert (!this.closed) : "Point writer is already closed";
        assert (packedValue.length == this.config.packedBytesLength) : "[packedValue] must have length [" + this.config.packedBytesLength + "] but was [" + packedValue.length + "]";
        this.out.writeBytes(packedValue, 0, packedValue.length);
        this.out.writeInt(Integer.reverseBytes(docID));
        ++this.count;
        assert (this.expectedCount == 0L || this.count <= this.expectedCount) : "expectedCount=" + this.expectedCount + " vs count=" + this.count;
    }

    @Override
    public void append(PointValue pointValue) throws IOException {
        assert (!this.closed) : "Point writer is already closed";
        BytesRef packedValueDocID = pointValue.packedValueDocIDBytes();
        assert (packedValueDocID.length == this.config.bytesPerDoc) : "[packedValue and docID] must have length [" + this.config.bytesPerDoc + "] but was [" + packedValueDocID.length + "]";
        this.out.writeBytes(packedValueDocID.bytes, packedValueDocID.offset, packedValueDocID.length);
        ++this.count;
        assert (this.expectedCount == 0L || this.count <= this.expectedCount) : "expectedCount=" + this.expectedCount + " vs count=" + this.count;
    }

    @Override
    public PointReader getReader(long start, long length) throws IOException {
        byte[] buffer = new byte[this.config.bytesPerDoc];
        return this.getReader(start, length, buffer);
    }

    protected OfflinePointReader getReader(long start, long length, byte[] reusableBuffer) throws IOException {
        assert (this.closed) : "point writer is still open and trying to get a reader";
        assert (start + length <= this.count) : "start=" + start + " length=" + length + " count=" + this.count;
        assert (this.expectedCount == 0L || this.count == this.expectedCount);
        return new OfflinePointReader(this.config, this.tempDir, this.name, start, length, reusableBuffer);
    }

    @Override
    public long count() {
        return this.count;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                CodecUtil.writeFooter(this.out);
            }
            finally {
                this.out.close();
                this.closed = true;
            }
        }
    }

    @Override
    public void destroy() throws IOException {
        this.tempDir.deleteFile(this.name);
    }

    public String toString() {
        return "OfflinePointWriter(count=" + this.count + " tempFileName=" + this.name + ")";
    }
}

