/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.pigment;

import at.petrak.hexcasting.api.pigment.ColorProvider;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public record FrozenPigment(ItemStack item, UUID owner) {
    public static final String TAG_STACK = "stack";
    public static final String TAG_OWNER = "owner";
    public static final Supplier<FrozenPigment> DEFAULT = () -> new FrozenPigment(new ItemStack((ItemLike)HexItems.DEFAULT_PIGMENT), Util.f_137441_);
    public static final Supplier<FrozenPigment> ANCIENT = () -> new FrozenPigment(new ItemStack((ItemLike)HexItems.ANCIENT_PIGMENT), Util.f_137441_);

    public CompoundTag serializeToNBT() {
        CompoundTag out = new CompoundTag();
        out.m_128365_(TAG_STACK, (Tag)this.item.m_41739_(new CompoundTag()));
        out.m_128362_(TAG_OWNER, this.owner);
        return out;
    }

    public static FrozenPigment fromNBT(CompoundTag tag) {
        if (tag.m_128456_()) {
            return DEFAULT.get();
        }
        try {
            CompoundTag stackTag = tag.m_128469_(TAG_STACK);
            ItemStack stack = ItemStack.m_41712_((CompoundTag)stackTag);
            UUID uuid = tag.m_128342_(TAG_OWNER);
            return new FrozenPigment(stack, uuid);
        }
        catch (NullPointerException exn) {
            return DEFAULT.get();
        }
    }

    public ColorProvider getColorProvider() {
        return IXplatAbstractions.INSTANCE.getColorProvider(this);
    }
}

