/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.lib;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.common.loot.AddHexToAncientCypherFunc;
import at.petrak.hexcasting.common.loot.AddPerWorldPatternToScrollFunc;
import at.petrak.hexcasting.common.loot.AmethystReducerFunc;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;

public class HexLootFunctions {
    private static final Map<ResourceLocation, LootItemFunctionType> LOOT_FUNCS = new LinkedHashMap<ResourceLocation, LootItemFunctionType>();
    public static final LootItemFunctionType PATTERN_SCROLL = HexLootFunctions.register("pattern_scroll", new LootItemFunctionType((Serializer)new AddPerWorldPatternToScrollFunc.Serializer()));
    public static final LootItemFunctionType HEX_CYPHER = HexLootFunctions.register("hex_cypher", new LootItemFunctionType((Serializer)new AddHexToAncientCypherFunc.Serializer()));
    public static final LootItemFunctionType AMETHYST_SHARD_REDUCER = HexLootFunctions.register("amethyst_shard_reducer", new LootItemFunctionType((Serializer)new AmethystReducerFunc.Serializer()));

    public static void registerSerializers(BiConsumer<LootItemFunctionType, ResourceLocation> r) {
        for (Map.Entry<ResourceLocation, LootItemFunctionType> e : LOOT_FUNCS.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    private static LootItemFunctionType register(String id, LootItemFunctionType lift) {
        LootItemFunctionType old = LOOT_FUNCS.put(HexAPI.modLoc(id), lift);
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + id);
        }
        return lift;
    }
}

