/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.recipe.ingredient.brainsweep;

import at.petrak.hexcasting.common.recipe.ingredient.brainsweep.BrainsweepeeIngredient;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class VillagerIngredient
extends BrainsweepeeIngredient {
    @Nullable
    public final VillagerProfession profession;
    @Nullable
    public final VillagerType biome;
    public final int minLevel;

    public VillagerIngredient(@Nullable VillagerProfession profession, @Nullable VillagerType biome, int minLevel) {
        this.profession = profession;
        this.biome = biome;
        this.minLevel = minLevel;
    }

    @Override
    public boolean test(Entity entity, ServerLevel level) {
        if (!(entity instanceof Villager)) {
            return false;
        }
        Villager villager = (Villager)entity;
        VillagerData data = villager.m_7141_();
        return !(this.profession != null && !this.profession.equals((Object)data.m_35571_()) || this.biome != null && !this.biome.equals(data.m_35560_()) || this.minLevel > data.m_35576_());
    }

    @Override
    public Entity exampleEntity(Level level) {
        VillagerType biome = Objects.requireNonNullElse(this.biome, VillagerType.f_35821_);
        VillagerProfession profession = Objects.requireNonNullElse(this.profession, VillagerProfession.f_35598_);
        int tradeLevel = Math.min(this.minLevel, 1);
        Villager out = new Villager(EntityType.f_20492_, level);
        VillagerData data = out.m_7141_();
        data.m_35565_(profession).m_35567_(biome).m_35561_(tradeLevel);
        out.m_34375_(data);
        CompoundTag tag = new CompoundTag();
        out.m_20223_(tag);
        return out;
    }

    @Override
    public List<Component> getTooltip(boolean advanced) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add(this.getName());
        if (advanced) {
            if (this.minLevel >= 5) {
                tooltip.add((Component)Component.m_237110_((String)"hexcasting.tooltip.brainsweep.level", (Object[])new Object[]{5}).m_130940_(ChatFormatting.DARK_GRAY));
            } else if (this.minLevel > 1) {
                tooltip.add((Component)Component.m_237110_((String)"hexcasting.tooltip.brainsweep.min_level", (Object[])new Object[]{this.minLevel}).m_130940_(ChatFormatting.DARK_GRAY));
            }
            if (this.biome != null) {
                tooltip.add((Component)Component.m_237113_((String)this.biome.toString()).m_130940_(ChatFormatting.DARK_GRAY));
            }
            if (this.profession != null) {
                tooltip.add((Component)Component.m_237113_((String)this.profession.toString()).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
        tooltip.add(BrainsweepeeIngredient.getModNameComponent(this.profession == null ? "minecraft" : BuiltInRegistries.f_256735_.m_7981_((Object)this.profession).m_135827_()));
        return tooltip;
    }

    @Override
    public Component getName() {
        MutableComponent component = Component.m_237113_((String)"");
        boolean addedAny = false;
        if (this.minLevel >= 5) {
            component.m_7220_((Component)Component.m_237115_((String)"merchant.level.5"));
            addedAny = true;
        } else if (this.minLevel > 1) {
            component.m_7220_((Component)Component.m_237115_((String)("merchant.level." + this.minLevel)));
            addedAny = true;
        } else if (this.profession != null) {
            component.m_7220_((Component)Component.m_237115_((String)"merchant.level.1"));
            addedAny = true;
        }
        if (this.biome != null) {
            if (addedAny) {
                component.m_130946_(" ");
            }
            ResourceLocation biomeLoc = BuiltInRegistries.f_256934_.m_7981_((Object)this.biome);
            component.m_7220_((Component)Component.m_237115_((String)("biome." + biomeLoc.m_135827_() + "." + biomeLoc.m_135815_())));
            addedAny = true;
        }
        if (this.profession != null) {
            component.m_130946_(" ");
            ResourceLocation professionLoc = BuiltInRegistries.f_256735_.m_7981_((Object)this.profession);
            component.m_7220_((Component)Component.m_237115_((String)("entity.minecraft.villager." + professionLoc.m_135815_())));
        } else {
            if (addedAny) {
                component.m_130946_(" ");
            }
            component.m_7220_(EntityType.f_20492_.m_20676_());
        }
        return component;
    }

    @Override
    public JsonObject serialize() {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", BrainsweepeeIngredient.Type.VILLAGER.m_7912_());
        if (this.profession != null) {
            obj.addProperty("profession", this.profession.toString());
        }
        if (this.biome != null) {
            obj.addProperty("biome", this.biome.toString());
        }
        obj.addProperty("minLevel", (Number)this.minLevel);
        return obj;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        if (this.profession != null) {
            buf.m_130130_(1);
            buf.m_130130_(BuiltInRegistries.f_256735_.m_7447_((Object)this.profession));
        } else {
            buf.m_130130_(0);
        }
        if (this.biome != null) {
            buf.m_130130_(1);
            buf.m_130130_(BuiltInRegistries.f_256934_.m_7447_((Object)this.biome));
        } else {
            buf.m_130130_(0);
        }
        buf.writeInt(this.minLevel);
    }

    public static VillagerIngredient deserialize(JsonObject json) {
        VillagerProfession profession = null;
        if (json.has("profession") && !json.get("profession").isJsonNull()) {
            profession = (VillagerProfession)BuiltInRegistries.f_256735_.m_7745_(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"profession")));
        }
        VillagerType biome = null;
        if (json.has("biome") && !json.get("biome").isJsonNull()) {
            biome = (VillagerType)BuiltInRegistries.f_256934_.m_7745_(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"biome")));
        }
        int minLevel = GsonHelper.m_13927_((JsonObject)json, (String)"minLevel");
        return new VillagerIngredient(profession, biome, minLevel);
    }

    public static VillagerIngredient read(FriendlyByteBuf buf) {
        VillagerProfession profession = null;
        int hasProfession = buf.m_130242_();
        if (hasProfession != 0) {
            profession = (VillagerProfession)BuiltInRegistries.f_256735_.m_7942_(buf.m_130242_());
        }
        VillagerType biome = null;
        int hasBiome = buf.m_130242_();
        if (hasBiome != 0) {
            biome = (VillagerType)BuiltInRegistries.f_256934_.m_7942_(buf.m_130242_());
        }
        int minLevel = buf.readInt();
        return new VillagerIngredient(profession, biome, minLevel);
    }

    @Override
    public BrainsweepeeIngredient.Type ingrType() {
        return BrainsweepeeIngredient.Type.VILLAGER;
    }

    @Override
    public String getSomeKindOfReasonableIDForEmi() {
        StringBuilder bob = new StringBuilder();
        if (this.profession != null) {
            ResourceLocation profLoc = BuiltInRegistries.f_256735_.m_7981_((Object)this.profession);
            bob.append(profLoc.m_135827_()).append("//").append(profLoc.m_135815_());
        } else {
            bob.append("null");
        }
        bob.append("_");
        if (this.biome != null) {
            ResourceLocation biomeLoc = BuiltInRegistries.f_256934_.m_7981_((Object)this.biome);
            bob.append(biomeLoc.m_135827_()).append("//").append(biomeLoc.m_135815_());
        } else {
            bob.append("null");
        }
        bob.append(this.minLevel);
        return bob.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VillagerIngredient that = (VillagerIngredient)o;
        return this.minLevel == that.minLevel && Objects.equals(this.profession, that.profession) && Objects.equals(this.biome, that.biome);
    }

    public int hashCode() {
        return Objects.hash(this.profession, this.biome, this.minLevel);
    }
}

