/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.datagen;

import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.loot.HexLootHandler;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import at.petrak.paucal.api.datagen.PaucalLootTableSubProvider;
import java.util.Map;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class HexLootTables
extends PaucalLootTableSubProvider {
    public HexLootTables() {
        super("hexcasting");
    }

    protected void makeLootTables(Map<Block, LootTable.Builder> blockTables, Map<ResourceLocation, LootTable.Builder> lootTables) {
        this.dropSelf(blockTables, new Block[]{HexBlocks.IMPETUS_EMPTY, HexBlocks.IMPETUS_RIGHTCLICK, HexBlocks.IMPETUS_LOOK, HexBlocks.IMPETUS_REDSTONE, HexBlocks.EMPTY_DIRECTRIX, HexBlocks.DIRECTRIX_REDSTONE, HexBlocks.DIRECTRIX_BOOLEAN, HexBlocks.AKASHIC_RECORD, HexBlocks.AKASHIC_BOOKSHELF, HexBlocks.AKASHIC_LIGATURE, HexBlocks.SLATE_BLOCK, HexBlocks.SLATE_TILES, HexBlocks.SLATE_BRICKS, HexBlocks.SLATE_BRICKS_SMALL, HexBlocks.SLATE_PILLAR, HexBlocks.AMETHYST_DUST_BLOCK, HexBlocks.AMETHYST_TILES, HexBlocks.AMETHYST_BRICKS, HexBlocks.AMETHYST_BRICKS_SMALL, HexBlocks.AMETHYST_PILLAR, HexBlocks.SLATE_AMETHYST_TILES, HexBlocks.SLATE_AMETHYST_BRICKS, HexBlocks.SLATE_AMETHYST_BRICKS_SMALL, HexBlocks.SLATE_AMETHYST_PILLAR, HexBlocks.QUENCHED_ALLAY_TILES, HexBlocks.QUENCHED_ALLAY_BRICKS, HexBlocks.QUENCHED_ALLAY_BRICKS_SMALL, HexBlocks.SCROLL_PAPER, HexBlocks.ANCIENT_SCROLL_PAPER, HexBlocks.SCROLL_PAPER_LANTERN, HexBlocks.ANCIENT_SCROLL_PAPER_LANTERN, HexBlocks.SCONCE, HexBlocks.EDIFIED_LOG, HexBlocks.EDIFIED_LOG_AMETHYST, HexBlocks.EDIFIED_LOG_AVENTURINE, HexBlocks.EDIFIED_LOG_CITRINE, HexBlocks.EDIFIED_LOG_PURPLE, HexBlocks.STRIPPED_EDIFIED_LOG, HexBlocks.EDIFIED_WOOD, HexBlocks.STRIPPED_EDIFIED_WOOD, HexBlocks.EDIFIED_PLANKS, HexBlocks.EDIFIED_TILE, HexBlocks.EDIFIED_PANEL, HexBlocks.EDIFIED_TRAPDOOR, HexBlocks.EDIFIED_STAIRS, HexBlocks.EDIFIED_FENCE, HexBlocks.EDIFIED_FENCE_GATE, HexBlocks.EDIFIED_PRESSURE_PLATE, HexBlocks.EDIFIED_BUTTON});
        this.makeSlabTable(blockTables, (Block)HexBlocks.EDIFIED_SLAB);
        this.makeLeafTable(blockTables, (Block)HexBlocks.AMETHYST_EDIFIED_LEAVES);
        this.makeLeafTable(blockTables, (Block)HexBlocks.AVENTURINE_EDIFIED_LEAVES);
        this.makeLeafTable(blockTables, (Block)HexBlocks.CITRINE_EDIFIED_LEAVES);
        LootPool.Builder slatePool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)HexBlocks.SLATE).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("pattern", "BlockEntityTag.pattern")));
        blockTables.put(HexBlocks.SLATE, LootTable.m_79147_().m_79161_(slatePool));
        LootPool.Builder doorPool = this.dropThisPool((ItemLike)HexBlocks.EDIFIED_DOOR, 1).m_79080_((LootItemCondition.Builder)new LootItemBlockStatePropertyCondition.Builder((Block)HexBlocks.EDIFIED_DOOR).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER)));
        blockTables.put((Block)HexBlocks.EDIFIED_DOOR, LootTable.m_79147_().m_79161_(doorPool));
        LootItemCondition.Builder silkTouchCond = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.f_55364_)));
        LootItemCondition.Builder noSilkTouchCond = silkTouchCond.m_81807_();
        LootItemCondition.Builder goodAtAmethystingCond = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(ItemTags.f_144323_));
        LootPool.Builder dustPoolWhenGood = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)HexItems.AMETHYST_DUST)).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_)).m_79080_(noSilkTouchCond).m_79080_(goodAtAmethystingCond);
        LootPool.Builder dustPoolWhenBad = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)HexItems.AMETHYST_DUST)).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79080_(noSilkTouchCond).m_79080_(goodAtAmethystingCond.m_81807_());
        LootPool.Builder isThatAnMFingBrandonSandersonReference = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)HexItems.CHARGED_AMETHYST)).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79080_(noSilkTouchCond).m_79080_(goodAtAmethystingCond).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.25f, 0.35f, 0.5f, 0.75f, 1.0f}));
        LootPool.Builder isThatAnMFingBadBrandonSandersonReference = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)HexItems.CHARGED_AMETHYST)).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79080_(noSilkTouchCond).m_79080_(goodAtAmethystingCond.m_81807_()).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.125f));
        lootTables.put(HexLootHandler.TABLE_INJECT_AMETHYST_CLUSTER, LootTable.m_79147_().m_79161_(dustPoolWhenGood).m_79161_(dustPoolWhenBad).m_79161_(isThatAnMFingBrandonSandersonReference).m_79161_(isThatAnMFingBadBrandonSandersonReference));
        LootPool.Builder quenchedPool = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.m_79579_((ItemLike)HexBlocks.QUENCHED_ALLAY).m_79080_(silkTouchCond), LootItem.m_79579_((ItemLike)HexItems.QUENCHED_SHARD).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)ConstantValue.m_165692_((float)1.0f), (boolean)true).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.25f, 0.5f, 0.75f, 1.0f})))}));
        blockTables.put(HexBlocks.QUENCHED_ALLAY, LootTable.m_79147_().m_79161_(quenchedPool));
    }

    private void makeLeafTable(Map<Block, LootTable.Builder> lootTables, Block block) {
        LootPool.Builder leafPool = this.dropThisPool((ItemLike)block, 1).m_79080_((LootItemCondition.Builder)AnyOfCondition.m_285758_((LootItemCondition.Builder[])new LootItemCondition.Builder[]{IXplatAbstractions.INSTANCE.isShearsCondition(), MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))}));
        lootTables.put(block, LootTable.m_79147_().m_79161_(leafPool));
    }

    private void makeSlabTable(Map<Block, LootTable.Builder> lootTables, Block block) {
        LootPool.Builder leafPool = this.dropThisPool((ItemLike)block, 1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)new LootItemBlockStatePropertyCondition.Builder(block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE)))).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_());
        lootTables.put(block, LootTable.m_79147_().m_79161_(leafPool));
    }
}

