/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.interop.curios;

import at.petrak.hexcasting.api.misc.DiscoveryHandlers;
import at.petrak.hexcasting.common.items.HexBaubleItem;
import at.petrak.hexcasting.common.items.magic.ItemCreativeUnlocker;
import at.petrak.hexcasting.forge.cap.ForgeCapabilityHandler;
import at.petrak.hexcasting.forge.interop.curios.CuriosRenderers;
import com.google.common.collect.Multimap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosApiInterop {
    public static ICapabilityProvider curioCap(ItemStack stack) {
        return ForgeCapabilityHandler.makeProvider(CuriosCapability.ITEM, new Wrapper(stack));
    }

    public static void init() {
        DiscoveryHandlers.addDebugItemDiscoverer((player, type) -> {
            AtomicReference<ItemStack> result = new AtomicReference<ItemStack>(ItemStack.f_41583_);
            player.getCapability(CuriosCapability.INVENTORY).ifPresent(handler -> {
                for (ICurioStacksHandler stacksHandler : handler.getCurios().values()) {
                    IDynamicStackHandler stacks = stacksHandler.getStacks();
                    for (int i = 0; i < stacks.getSlots(); ++i) {
                        ItemStack stack = stacks.getStackInSlot(i);
                        if (!ItemCreativeUnlocker.isDebug(stack, type)) continue;
                        result.set(stack);
                        return;
                    }
                }
            });
            return result.get();
        });
    }

    public static void onInterModEnqueue(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.HEAD.getMessageBuilder().build());
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        CuriosRenderers.register();
    }

    static class Wrapper
    implements ICurio {
        private final ItemStack stack;
        private final HexBaubleItem bauble;

        Wrapper(ItemStack stack) {
            HexBaubleItem bauble;
            this.stack = stack;
            Item item = stack.m_41720_();
            if (!(item instanceof HexBaubleItem)) {
                throw new IllegalArgumentException("Item stack " + stack + " wasn't a bauble item weewoo");
            }
            this.bauble = bauble = (HexBaubleItem)item;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid) {
            Multimap map = super.getAttributeModifiers(slotContext, uuid);
            map.putAll(this.bauble.getHexBaubleAttrs(this.stack));
            return map;
        }
    }
}

