/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.blocks;

import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class SupportBlock
extends Block {
    public static final EnumProperty<SupportStatus> STATUS = EnumProperty.m_61587_((String)"status", SupportStatus.class);

    public SupportBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_280170_().m_60955_().m_60924_((state, world, pos) -> false));
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull BlockHitResult hit) {
        if (!world.f_46443_) {
            ArrayDeque<BlockPos> todo = new ArrayDeque<BlockPos>();
            todo.add(pos);
            this.removeBlock(world, todo);
        }
        return super.m_6227_(state, world, pos, player, handIn, hit);
    }

    private void removeBlock(Level world, Deque<BlockPos> todo) {
        while (!todo.isEmpty()) {
            BlockPos c = todo.pollFirst();
            world.m_46597_(c, Blocks.f_50016_.m_49966_());
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        BlockPos offset;
                        if (dx == 0 && dy == 0 && dz == 0 || world.m_8055_(offset = c.m_7918_(dx, dy, dz)).m_60734_() != this) continue;
                        todo.push(offset);
                    }
                }
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STATUS});
    }

    public static enum SupportStatus implements StringRepresentable
    {
        STATUS_OK("ok"),
        STATUS_WARN("warn"),
        STATUS_ERROR("error");

        private final String name;

        private SupportStatus(String name) {
            this.name = name;
        }

        public static SupportStatus max(SupportStatus error1, SupportStatus error2) {
            if (error1 == STATUS_ERROR || error2 == STATUS_ERROR) {
                return STATUS_ERROR;
            }
            if (error1 == STATUS_WARN || error2 == STATUS_WARN) {
                return STATUS_WARN;
            }
            return STATUS_OK;
        }

        public String getName() {
            return this.name;
        }

        @Nonnull
        public String m_7912_() {
            return this.name;
        }
    }
}

