/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.scanner.blocks;

import java.util.function.Predicate;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.Cached;
import mcjty.lib.varia.RLE;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleItem;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbuilder.compat.RFToolsBuilderTOPDriver;
import mcjty.rftoolsbuilder.modules.builder.BuilderModule;
import mcjty.rftoolsbuilder.modules.builder.blocks.SupportBlock;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardItem;
import mcjty.rftoolsbuilder.shapes.StatePalette;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;

public class ScannerTileEntity
extends TickingTileEntity {
    public static final int SLOT_IN = 0;
    public static final int SLOT_OUT = 1;
    public static final int SLOT_FILTER = 2;
    public static final int SLOT_MODIFIER = 3;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(4).slot(SlotDefinition.specific(s -> s.m_41720_() instanceof ShapeCardItem).in().out(), 0, 15, 7).slot(SlotDefinition.specific(s -> s.m_41720_() instanceof ShapeCardItem).in().out(), 1, 15, 200).slot(SlotDefinition.specific(s -> s.m_41720_() instanceof FilterModuleItem).in().out(), 2, 35, 7).slot(SlotDefinition.specific(s -> true).in().out(), 3, 55, 7).playerSlots(85, 142));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = this.createItemHandler();
    @Cap(type=CapType.CONTAINER)
    private final Lazy<MenuProvider> screenHandler = Lazy.of(() -> new DefaultContainerProvider("Builder").containerSupplier(DefaultContainerProvider.container(BuilderModule.CONTAINER_BUILDER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).setupSync((GenericTileEntity)this));
    private int scanId = 0;
    private ItemStack renderStack = ItemStack.f_41583_;
    private BlockPos dataDim;
    private BlockPos dataOffset = new BlockPos(0, 0, 0);
    private ScanProgress progress = null;
    private int progressBusy = -1;
    private final Cached<Predicate<ItemStack>> filterCache = Cached.of(this::createFilterCache);

    public ScannerTileEntity(BlockEntityType type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setRSMode(RedstoneMode.REDSTONE_ONREQUIRED);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsBuilderTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolsbuilder:projector/scanner")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbuilder.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()})){

            public RotationType getRotationType() {
                return RotationType.HORIZROTATION;
            }
        };
    }

    protected void tickServer() {
        int surfaceAreaPerTick = 262144;
        if (this.progress != null) {
            for (int done = 0; this.progress != null && done < surfaceAreaPerTick; done += this.dataDim.m_123343_() * this.dataDim.m_123342_()) {
                this.progressScan();
            }
        } else if (this.isMachineEnabled()) {
            this.scan();
        }
    }

    private void scan() {
        if (this.progress != null) {
            return;
        }
        if (this.items.getStackInSlot(0).m_41619_()) {
            return;
        }
        BlockPos machinePos = this.getScanPos();
        if (machinePos == null) {
            return;
        }
        int dimX = this.dataDim.m_123341_();
        int dimY = this.dataDim.m_123342_();
        int dimZ = this.dataDim.m_123343_();
        this.startScanArea(this.getScanCenter(), this.getScanDimension(), dimX, dimY, dimZ);
    }

    public Level getScanWorld(ResourceKey<Level> dimension) {
        return this.f_58857_.m_7654_().m_129880_(dimension);
    }

    protected BlockPos getScanPos() {
        return this.m_58899_();
    }

    public BlockPos getScanCenter() {
        if (this.getScanPos() == null) {
            return null;
        }
        return this.getScanPos().m_7918_(this.dataOffset.m_123341_(), this.dataOffset.m_123342_(), this.dataOffset.m_123343_());
    }

    public BlockPos getFirstCorner() {
        if (this.getScanPos() == null) {
            return null;
        }
        return this.getScanPos().m_7918_(this.dataOffset.m_123341_() - this.dataDim.m_123341_() / 2, this.dataOffset.m_123342_() - this.dataDim.m_123342_() / 2, this.dataOffset.m_123343_() - this.dataDim.m_123343_() / 2);
    }

    public BlockPos getLastCorner() {
        if (this.getScanPos() == null) {
            return null;
        }
        return this.getScanPos().m_7918_(this.dataOffset.m_123341_() + this.dataDim.m_123341_() / 2, this.dataOffset.m_123342_() + this.dataDim.m_123342_() / 2, this.dataOffset.m_123343_() + this.dataDim.m_123343_() / 2);
    }

    public ResourceKey<Level> getScanDimension() {
        return this.f_58857_.m_46472_();
    }

    private void progressScan() {
        if (this.progress == null) {
            return;
        }
        BlockPos tl = this.progress.tl;
        int dimX = this.progress.dimX;
        int dimY = this.progress.dimY;
        int dimZ = this.progress.dimZ;
        Level world = this.getScanWorld(this.progress.dimension);
        BlockPos.MutableBlockPos mpos = this.progress.mpos;
        for (int z = tl.m_123343_(); z < tl.m_123343_() + dimZ; ++z) {
            for (int y = tl.m_123342_(); y < tl.m_123342_() + dimY; ++y) {
                mpos.m_122178_(this.progress.x, y, z);
            }
        }
        ++this.progress.x;
        if (this.progress.x >= tl.m_123341_() + dimX) {
            this.stopScanArea();
        } else {
            this.markDirtyClient();
        }
    }

    private void startScanArea(BlockPos center, ResourceKey<Level> dimension, int dimX, int dimY, int dimZ) {
        this.progress = new ScanProgress();
        this.progress.rle = new RLE();
        this.progress.tl = new BlockPos(center.m_123341_() - dimX / 2, center.m_123342_() - dimY / 2, center.m_123343_() - dimZ / 2);
        this.progress.materialPalette = new StatePalette();
        this.progress.materialPalette.alloc(((SupportBlock)BuilderModule.SUPPORT.get()).m_49966_(), 0);
        this.progress.x = this.progress.tl.m_123341_();
        this.progress.dimX = dimX;
        this.progress.dimY = dimY;
        this.progress.dimZ = dimZ;
        this.progress.dimension = dimension;
        this.markDirtyClient();
    }

    private void stopScanArea() {
        this.dataDim = new BlockPos(this.progress.dimX, this.progress.dimY, this.progress.dimZ);
        this.progress = null;
    }

    private Predicate<ItemStack> createFilterCache() {
        return FilterModuleItem.getCache((ItemStack)this.items.getStackInSlot(2));
    }

    private GenericItemHandler createItemHandler() {
        return new GenericItemHandler((GenericTileEntity)this, (ContainerFactory)CONTAINER_FACTORY.get());
    }

    private static class ScanProgress {
        RLE rle;
        BlockPos tl;
        StatePalette materialPalette;
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        int dimX;
        int dimY;
        int dimZ;
        int x;
        ResourceKey<Level> dimension;

        private ScanProgress() {
        }
    }
}

