/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.shield.blocks;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbase.modules.various.items.SmartWrenchItem;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbuilder.compat.RFToolsBuilderTOPDriver;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldProjectorTileEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ShieldProjectorBlock
extends BaseBlock
implements INBTPreservingIngredient {
    public ShieldProjectorBlock(BlockEntityType.BlockEntitySupplier<BlockEntity> te, Supplier<Integer> max) {
        super(new BlockBuilder().manualEntry(ManualHelper.create((String)"rftoolsbuilder:shield/shield_intro")).topDriver((TOPDriver)RFToolsBuilderTOPDriver.DRIVER).infusable().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbuilder.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"info", stack -> Integer.toString((Integer)max.get()))}).tileEntitySupplier(te));
    }

    public RotationType getRotationType() {
        return RotationType.NONE;
    }

    public Collection<String> getTagsToPreserve() {
        return Collections.singleton("BlockEntityTag");
    }

    public void m_6402_(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        this.setOwner(world, pos, placer);
    }

    public void m_6256_(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, @Nonnull Player player) {
        if (!world.f_46443_) {
            this.composeDecomposeShield(world, pos, true);
        }
    }

    protected boolean wrenchUse(Level world, BlockPos pos, Direction side, Player player) {
        this.composeDecomposeShield(world, pos, false);
        return true;
    }

    protected boolean wrenchSneakSelect(Level world, BlockPos pos, Player player) {
        if (!world.f_46443_) {
            Optional currentBlock = SmartWrenchItem.getCurrentBlock((ItemStack)player.m_21120_(InteractionHand.MAIN_HAND));
            if (!currentBlock.isPresent()) {
                SmartWrenchItem.setCurrentBlock((ItemStack)player.m_21120_(InteractionHand.MAIN_HAND), (GlobalPos)GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)pos));
                Logging.message((Player)player, (String)(ChatFormatting.YELLOW + "Selected block"));
            } else {
                SmartWrenchItem.setCurrentBlock((ItemStack)player.m_21120_(InteractionHand.MAIN_HAND), null);
                Logging.message((Player)player, (String)(ChatFormatting.YELLOW + "Cleared selected block"));
            }
        }
        return true;
    }

    private void composeDecomposeShield(Level world, BlockPos pos, boolean ctrl) {
        BlockEntity te;
        if (!world.f_46443_ && (te = world.m_7702_(pos)) instanceof ShieldProjectorTileEntity) {
            ((ShieldProjectorTileEntity)te).composeDecomposeShield(ctrl);
        }
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState newstate, boolean isMoving) {
        if (newstate.m_60734_() != this) {
            this.removeShield((LevelAccessor)world, pos);
        }
        super.m_6810_(state, world, pos, newstate, isMoving);
    }

    public void m_6786_(@Nonnull LevelAccessor world, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        this.removeShield(world, pos);
        super.m_6786_(world, pos, state);
    }

    public void m_7592_(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Explosion explosionIn) {
        this.removeShield((LevelAccessor)world, pos);
        super.m_7592_(world, pos, explosionIn);
    }

    private void removeShield(LevelAccessor world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof ShieldProjectorTileEntity) {
            ShieldProjectorTileEntity shield = (ShieldProjectorTileEntity)te;
            if (!world.m_5776_() && shield.isShieldComposed()) {
                shield.decomposeShield();
            }
        }
    }
}

