/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.shapes;

import java.util.HashMap;
import java.util.Map;

public enum BeaconType {
    BEACON_OFF(0.1f, 0.1f, 0.1f, "off"),
    BEACON_GREEN(0.0f, 1.0f, 0.0f, "green"),
    BEACON_RED(1.0f, 0.0f, 0.0f, "red"),
    BEACON_CYAN(0.0f, 1.0f, 1.0f, "cyan"),
    BEACON_BLUE(0.0f, 0.0f, 1.0f, "blue"),
    BEACON_YELLOW(1.0f, 1.0f, 0.0f, "yellow"),
    BEACON_PURPLE(1.0f, 0.0f, 1.0f, "purple"),
    BEACON_WHITE(1.0f, 1.0f, 1.0f, "white");

    public static final BeaconType[] VALUES;
    private static final Map<String, BeaconType> TYPE_BY_CODE;
    private final String code;
    private final float r;
    private final float g;
    private final float b;
    private final int color;

    private BeaconType(float r, float g, float b, String code) {
        this.code = code;
        this.b = b;
        this.g = g;
        this.r = r;
        this.color = ((int)((double)r * 255.0) << 16) + ((int)((double)g * 255.0) << 8) + (int)((double)b * 255.0);
    }

    public String getCode() {
        return this.code;
    }

    public int getColor() {
        return this.color;
    }

    public float getR() {
        return this.r;
    }

    public float getG() {
        return this.g;
    }

    public float getB() {
        return this.b;
    }

    public static BeaconType getTypeByCode(String code) {
        if (code == null || code.isEmpty()) {
            return BEACON_OFF;
        }
        BeaconType type = TYPE_BY_CODE.get(code);
        if (type == null) {
            return BEACON_OFF;
        }
        return type;
    }

    static {
        TYPE_BY_CODE = new HashMap<String, BeaconType>();
        VALUES = new BeaconType[BeaconType.values().length];
        for (int i = 0; i < BeaconType.values().length; ++i) {
            BeaconType.VALUES[i] = BeaconType.values()[i];
            TYPE_BY_CODE.put(VALUES[i].getCode(), VALUES[i]);
        }
    }
}

