/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.xkdeco.block;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.NyliumBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SpreadingSnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.gameevent.GameEvent;
import org.teacon.xkdeco.XKDeco;
import snownee.kiwi.customization.block.loader.BlockCodecs;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SpecialSlabBlock
extends SlabBlock {
    public static final MapCodec<SpecialSlabBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockCodecs.propertiesCodec(), (App)StringRepresentable.m_216439_(Type::values).fieldOf("type").forGetter(block -> block.type)).apply((Applicative)instance, SpecialSlabBlock::new));
    private static final Supplier<Block> DIRT_SLAB = Suppliers.memoize(() -> (Block)BuiltInRegistries.f_256975_.m_7745_(XKDeco.id("dirt_slab")));
    private static final Supplier<Block> NETHERRACK_SLAB = Suppliers.memoize(() -> (Block)BuiltInRegistries.f_256975_.m_7745_(XKDeco.id("netherrack_slab")));
    protected final Type type;

    public SpecialSlabBlock(BlockBehaviour.Properties properties, Type type) {
        super(properties);
        this.type = type;
    }

    public boolean m_7923_(BlockState state) {
        return this.type == Type.PATH || super.m_7923_(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        if (this.type == Type.PATH && facing == Direction.UP && !state.m_60710_((LevelReader)world, pos)) {
            world.m_186460_(pos, (Block)this, 1);
        }
        return super.m_7417_(state, facing, facingState, world, pos, facingPos);
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (this.type == Type.PATH) {
            BlockState newState = this.turnToAnotherSlab(DIRT_SLAB, pState, pLevel, pPos);
            SpecialSlabBlock.m_49897_((BlockState)pState, (BlockState)Blocks.f_50493_.m_49966_(), (LevelAccessor)pLevel, (BlockPos)pPos);
            pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223719_(null, (BlockState)newState));
        } else if (this.type == Type.DIRT) {
            if (pState.m_61143_((Property)f_56353_) == SlabType.BOTTOM) {
                if (((Boolean)pState.m_61143_((Property)f_56354_)).booleanValue()) {
                    this.turnToAnotherSlab(DIRT_SLAB, pState, pLevel, pPos);
                }
            } else if (!SpreadingSnowyDirtBlock.m_56823_((BlockState)((BlockState)pState.m_61124_((Property)f_56353_, (Comparable)SlabType.DOUBLE)), (LevelReader)pLevel, (BlockPos)pPos)) {
                this.turnToAnotherSlab(DIRT_SLAB, pState, pLevel, pPos);
            }
        } else if (this.type == Type.NYLIUM && pState.m_61143_((Property)f_56353_) != SlabType.BOTTOM && !NyliumBlock.m_55078_((BlockState)((BlockState)pState.m_61124_((Property)f_56353_, (Comparable)SlabType.DOUBLE)), (LevelReader)pLevel, (BlockPos)pPos)) {
            this.turnToAnotherSlab(NETHERRACK_SLAB, pState, pLevel, pPos);
        }
    }

    private BlockState turnToAnotherSlab(Supplier<Block> blockSupplier, BlockState original, ServerLevel world, BlockPos pos) {
        if (!(original.m_60734_() instanceof SlabBlock)) {
            return original;
        }
        BlockState state = (BlockState)((BlockState)blockSupplier.get().m_49966_().m_61124_((Property)f_56353_, (Comparable)((SlabType)original.m_61143_((Property)f_56353_)))).m_61124_((Property)f_56354_, (Comparable)((Boolean)original.m_61143_((Property)f_56354_)));
        world.m_46597_(pos, state);
        return state;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        if (this.type == Type.PATH && state.m_61143_((Property)f_56353_) != SlabType.BOTTOM) {
            BlockState aboveState = world.m_8055_(pos.m_7494_());
            return !aboveState.m_280296_() || aboveState.m_60734_() instanceof FenceGateBlock;
        }
        return true;
    }

    public static enum Type implements StringRepresentable
    {
        DIRT,
        PATH,
        NYLIUM;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

