/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.xkdeco.util;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Optional;
import net.fabricmc.fabric.api.client.model.loading.v1.BlockStateResolver;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.teacon.xkdeco.XKDeco;
import org.teacon.xkdeco.block.MimicWallBlock;
import org.teacon.xkdeco.client.model.AirDuctModel;
import org.teacon.xkdeco.client.model.MimicWallModel;
import org.teacon.xkdeco.client.renderer.BlockDisplayRenderer;
import org.teacon.xkdeco.client.renderer.HologramRenderer;
import org.teacon.xkdeco.client.renderer.ItemDisplayRenderer;
import org.teacon.xkdeco.init.MimicWallsLoader;
import org.teacon.xkdeco.init.XKDecoEntityTypes;
import snownee.kiwi.util.NotNullByDefault;

@NotNullByDefault
public final class ClientProxy {
    public static void setEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)XKDecoEntityTypes.ITEM_DISPLAY.getOrCreate(), ItemDisplayRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)XKDecoEntityTypes.ITEM_PROJECTOR.getOrCreate(), ItemDisplayRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)XKDecoEntityTypes.BLOCK_DISPLAY.getOrCreate(), BlockDisplayRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)XKDecoEntityTypes.HOLOGRAM.getOrCreate(), HologramRenderer::new);
    }

    public static void init() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(ClientProxy::setEntityRenderers);
        ModelLoadingPlugin.register(ctx -> {
            ResourceLocation airDuctModel = XKDeco.id("block/air_duct");
            ctx.resolveModel().register(context -> {
                if (!context.id().equals((Object)airDuctModel)) {
                    return null;
                }
                ResourceLocation file = ModelBakery.f_244378_.m_245698_(context.id());
                Optional resource = Minecraft.m_91087_().m_91098_().m_213713_(file);
                if (resource.isEmpty()) {
                    return null;
                }
                try (BufferedReader reader = ((Resource)resource.get()).m_215508_();){
                    JsonObject jsonObject = GsonHelper.m_13859_((Reader)reader);
                    if (!GsonHelper.m_13906_((JsonObject)jsonObject, (String)"xkdeco:loader").equals("xkdeco:air_duct")) {
                        UnbakedModel unbakedModel = null;
                        return unbakedModel;
                    }
                    AirDuctModel airDuctModel2 = new AirDuctModel(ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)jsonObject, (String)"straight")), ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)jsonObject, (String)"corner")), ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)jsonObject, (String)"cover")), ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)jsonObject, (String)"frame")));
                    return airDuctModel2;
                }
                catch (Exception e) {
                    XKDeco.LOGGER.error("Failed to load air duct model", (Throwable)e);
                    return null;
                }
            });
            HashMap wallModels = Maps.newHashMap();
            BlockStateResolver resolver = context -> {
                MimicWallModel wallModel = wallModels.computeIfAbsent(((MimicWallBlock)context.block()).getWallDelegate(), MimicWallModel::new);
                for (BlockState blockState : context.block().m_49965_().m_61056_()) {
                    context.setModel(blockState, (UnbakedModel)wallModel);
                }
            };
            for (MimicWallBlock block : MimicWallsLoader.MIMIC_WALLS) {
                ctx.registerBlockStateResolver((Block)block, resolver);
            }
            ctx.resolveModel().register(context -> {
                ResourceLocation modelId = context.id();
                if (!modelId.m_135827_().equals("xkdeco")) {
                    return null;
                }
                if (!modelId.m_135815_().startsWith("block/mimic/") && !modelId.m_135815_().startsWith("item/mimic/")) {
                    return null;
                }
                ResourceLocation id = XKDeco.id(modelId.m_135815_().substring(modelId.m_135815_().indexOf(47) + 1));
                Block block = BuiltInRegistries.f_256975_.m_6612_(id).orElse(null);
                if (block instanceof MimicWallBlock) {
                    MimicWallBlock mimicWallBlock = (MimicWallBlock)block;
                    return wallModels.computeIfAbsent(mimicWallBlock.getWallDelegate(), MimicWallModel::new);
                }
                return null;
            });
        });
    }
}

