/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.client.core.proxy.ClientProxy;
import vazkii.psi.common.core.handler.ConfigHandler;
import vazkii.psi.common.core.handler.ContributorSpellCircleHandler;
import vazkii.psi.common.core.handler.InternalMethodHandler;
import vazkii.psi.common.core.proxy.IProxy;
import vazkii.psi.common.core.proxy.ServerProxy;
import vazkii.psi.common.item.component.DefaultStats;
import vazkii.psi.common.network.MessageRegister;

@Mod(value="psi")
public class Psi {
    public static final Logger logger = LogManager.getLogger((String)"psi");
    public static Psi instance;
    public static boolean magical;
    public static IProxy proxy;
    public static List<SoundEvent> noteblockSoundEvents;

    public Psi() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigHandler.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigHandler.COMMON_SPEC);
        proxy = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
        proxy.registerHandlers();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        magical = ModList.get().isLoaded("magipsi");
        PsiAPI.internalHandler = new InternalMethodHandler();
        ContributorSpellCircleHandler.firstStart();
        DefaultStats.registerStats();
        MessageRegister.init();
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        ForgeRegistries.SOUND_EVENTS.forEach(el -> {
            if (ForgeRegistries.SOUND_EVENTS.getKey(el).m_135815_().toLowerCase(Locale.ROOT).startsWith("block.note_block")) {
                noteblockSoundEvents.add((SoundEvent)el);
            }
        });
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation("psi", path);
    }

    static {
        noteblockSoundEvents = new ArrayList<SoundEvent>();
    }
}

