/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.operator.entity;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellHelpers;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamEntityListWrapper;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceOperator;
import vazkii.psi.api.spell.wrapper.EntityListWrapper;
import vazkii.psi.common.spell.operator.entity.PieceOperatorClosestToPoint;

public class PieceOperatorClosestToLine
extends PieceOperator {
    SpellParam<Vector3> rayStartParam;
    SpellParam<Vector3> rayEndParam;
    SpellParam<EntityListWrapper> entList;

    public PieceOperatorClosestToLine(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        super.initParams();
        this.rayStartParam = new ParamVector("psi.spellparam.ray_start", SpellParam.RED, false, false);
        this.addParam(this.rayStartParam);
        this.rayEndParam = new ParamVector("psi.spellparam.ray_end", SpellParam.BLUE, false, false);
        this.addParam(this.rayEndParam);
        this.entList = new ParamEntityListWrapper("psi.spellparam.list", SpellParam.GREEN, false, false);
        this.addParam(this.entList);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 rayStart = SpellHelpers.getVector3(this, context, this.rayStartParam, false, false);
        Vector3 rayEnd = SpellHelpers.getVector3(this, context, this.rayEndParam, false, false);
        EntityListWrapper list = this.getNonnullParamValue(context, this.entList);
        if (list.size() == 0) {
            return null;
        }
        return PieceOperatorClosestToLine.closestToLineSegment(rayStart, rayEnd, list);
    }

    @Override
    public Class<?> getEvaluationType() {
        return Entity.class;
    }

    public static Entity closestToLineSegment(Vector3 a, Vector3 b, Iterable<Entity> list) throws SpellRuntimeException {
        if (a.equals(b)) {
            return PieceOperatorClosestToPoint.closestToPoint(a, list);
        }
        Vec3 start = a.toVec3D();
        Vec3 end = b.toVec3D();
        Vec3 diff = end.m_82546_(start).m_82541_();
        double minDot = diff.m_82526_(start);
        double maxDot = diff.m_82526_(end);
        double minDist = Double.MAX_VALUE;
        Entity found = null;
        for (Entity e : list) {
            Vec3 pos = e.m_20182_();
            double dot = diff.m_82526_(pos);
            double dist = dot <= minDot ? pos.m_82546_(start).m_82553_() : (dot >= maxDot ? pos.m_82546_(end).m_82553_() : pos.m_82546_(start).m_82537_(diff).m_82553_());
            if (!(dist < minDist)) continue;
            minDist = dist;
            found = e;
        }
        if (found == null) {
            throw new SpellRuntimeException("psi.spellerror.nulltarget");
        }
        return found;
    }
}

