/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.compat.create;

import ad_astra_giselle_addon.common.content.oxygen.IOxygenStorage;
import com.simibubi.create.content.equipment.armor.BacktankItem;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class BacktankOxygenStorage
implements IOxygenStorage {
    private final ItemStackHolder holder;
    private final ArmorMaterial material;

    public static IOxygenStorage getOxygenStroage(ItemStackHolder holder) {
        Item item = holder.getStack().m_41720_();
        if (item instanceof BacktankItem) {
            BacktankItem item2 = (BacktankItem)item;
            return new BacktankOxygenStorage(holder, item2.m_40401_());
        }
        return null;
    }

    public BacktankOxygenStorage(ItemStackHolder holder, ArmorMaterial material) {
        this.holder = holder;
        this.material = material;
    }

    @Override
    public long extractOxygen(@Nullable LivingEntity living, long amount, boolean simulate) {
        ItemStack stack = this.getHolder().getStack();
        float air = BacktankUtil.getAir((ItemStack)stack);
        float neededAir = this.toAir(amount);
        float usingAir = Math.min(air, neededAir);
        if (!simulate) {
            BacktankUtil.consumeAir((LivingEntity)living, (ItemStack)stack, (float)usingAir);
            this.getHolder().setStack(stack);
        }
        return this.toAmount(usingAir);
    }

    @Override
    public long getOxygenAmount() {
        ItemStack stack = this.getHolder().getStack();
        float air = BacktankUtil.getAir((ItemStack)stack);
        return this.toAmount(air);
    }

    @Override
    public long getOxygenCapacity() {
        ItemStack stack = this.getHolder().getStack();
        float air = BacktankUtil.maxAir((ItemStack)stack);
        return this.toAmount(air);
    }

    private float toAir(long amount) {
        return (float)(FluidConstants.toMillibuckets((long)amount) * 30L) / 20.0f;
    }

    private long toAmount(float air) {
        return (long)(air * 20.0f * (float)FluidConstants.fromMillibuckets((long)1L) / 30.0f);
    }

    @Override
    public boolean canUseOnCold() {
        return true;
    }

    @Override
    public boolean canUseOnHot() {
        return this.getMaterial() == ArmorMaterials.NETHERITE;
    }

    public ItemStackHolder getHolder() {
        return this.holder;
    }

    public ArmorMaterial getMaterial() {
        return this.material;
    }
}

