/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.compat.tconstruct;

import ad_astra_giselle_addon.common.compat.tconstruct.AddonTConstructModifiers;
import ad_astra_giselle_addon.common.config.EnchantmentsConfig;
import ad_astra_giselle_addon.common.content.proof.OxygenProofEnchantmentFunction;
import ad_astra_giselle_addon.common.content.proof.ProofAbstractUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class TConstructProofProvidingHandler {
    public int onOxygenProof(Entity entity) {
        LivingEntity living;
        Tuple tuple;
        if (entity instanceof LivingEntity && (tuple = TConstructProofProvidingHandler.findFirst(living = (LivingEntity)entity, AddonTConstructModifiers.OXYGEN_PROOF.get())) != null && OxygenProofEnchantmentFunction.consumeOxygen(living, ProofAbstractUtils.OXYGEN_PROOF_USING, false)) {
            return 30;
        }
        return 0;
    }

    public int onHotTemperatureProof(Entity entity) {
        return TConstructProofProvidingHandler.provideProof(entity, AddonTConstructModifiers.HOT_TEMPERATURE_PROOF.get(), EnchantmentsConfig.HOT_TEMPERATURE_PROOF_DURABILITY_USING, EnchantmentsConfig.HOT_TEMPERATURE_PROOF_DURABILITY_DURATION);
    }

    public int onAcidRainProof(Entity entity) {
        return TConstructProofProvidingHandler.provideProof(entity, AddonTConstructModifiers.ACID_RAIN_PROOF.get(), EnchantmentsConfig.ACID_RAIN_PROOF_DURABILITY_USING, EnchantmentsConfig.ACID_RAIN_PROOF_DURABILITY_DURATION);
    }

    public int onGravityProof(Entity entity) {
        return TConstructProofProvidingHandler.provideProof(entity, AddonTConstructModifiers.GRAVITY_PROOF.get(), EnchantmentsConfig.GRAVITY_PROOF_DURABILITY_USING, EnchantmentsConfig.GRAVITY_PROOF_DURABILITY_DURATION);
    }

    public static int provideProof(Entity entity, Modifier modifier, int durabilityUsing, int duration) {
        LivingEntity living;
        Tuple tuple;
        if (entity instanceof LivingEntity && (tuple = TConstructProofProvidingHandler.findFirst(living = (LivingEntity)entity, modifier)) != null) {
            ToolDamageUtil.damage((IToolStackView)tuple.tool(), (int)durabilityUsing, (LivingEntity)living, (ItemStack)living.m_6844_(tuple.slot()));
            return duration;
        }
        return 0;
    }

    public static Tuple findFirst(LivingEntity living, Modifier modifier) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ToolStack tool = Modifier.getHeldTool((LivingEntity)living, (EquipmentSlot)slot);
            if (tool == null || tool.getModifierLevel(modifier) <= 0) continue;
            return new Tuple(slot, tool);
        }
        return null;
    }

    public record Tuple(EquipmentSlot slot, ToolStack tool) {
    }
}

