/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.other;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.cycle.CommonCycles;
import de.keksuccino.fancymenu.util.cycle.LocalizedEnumValueCycle;
import de.keksuccino.fancymenu.util.enums.LocalizedEnum;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringBuilderScreen;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.CycleButton;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManageResourcePackAction
extends Action {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String VALUE_SEPARATOR = "|||";

    public ManageResourcePackAction() {
        super("manage_resource_pack");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        if (value == null || value.isEmpty()) {
            LOGGER.error("[FANCYMENU] ManageResourcePackAction: No value provided!");
            return;
        }
        try {
            ResourcePackConfig config = ResourcePackConfig.parse(value);
            if (config == null) {
                LOGGER.error("[FANCYMENU] ManageResourcePackAction: Failed to parse configuration: {}", (Object)value);
                return;
            }
            String targetName = config.packName.trim();
            if (targetName.isEmpty()) {
                LOGGER.error("[FANCYMENU] ManageResourcePackAction: Pack name is empty!");
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            PackRepository repository = minecraft.m_91099_();
            Pack pack = this.findPack(repository, targetName);
            if (pack == null) {
                LOGGER.warn("[FANCYMENU] ManageResourcePackAction: Unable to find resource pack with display name '{}'.", (Object)targetName);
                return;
            }
            ArrayList<Pack> workingSelection = new ArrayList<Pack>(repository.m_10524_());
            boolean modified = config.mode.apply(workingSelection, pack);
            if (!modified) {
                return;
            }
            ArrayList<String> selectedIds = new ArrayList<String>();
            for (Pack entry : workingSelection) {
                selectedIds.add(entry.m_10446_());
            }
            repository.m_10509_(selectedIds);
            this.refreshOptions(minecraft.f_91066_, repository);
            this.updateHighContrastOption(minecraft, repository);
            if (config.reloadOnChange) {
                minecraft.m_91391_();
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] ManageResourcePackAction failed to change resource pack state!", (Throwable)ex);
        }
    }

    @Override
    @NotNull
    public Component getActionDisplayName() {
        return Component.m_237115_((String)"fancymenu.actions.manage_resource_pack");
    }

    @Override
    @NotNull
    public Component[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.actions.manage_resource_pack.desc", new String[0]);
    }

    @Override
    public Component getValueDisplayName() {
        return Component.m_237119_();
    }

    @Override
    public String getValueExample() {
        return "Programmer Art|||TOGGLE|||true";
    }

    @Override
    public void editValue(@NotNull Screen parentScreen, @NotNull ActionInstance instance) {
        ManageResourcePackActionValueScreen screen = new ManageResourcePackActionValueScreen(Objects.requireNonNullElse(instance.value, this.getValueExample()), editedValue -> {
            if (editedValue != null) {
                instance.value = editedValue;
            }
            Minecraft.m_91087_().m_91152_(parentScreen);
        });
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private void refreshOptions(@NotNull Options options, @NotNull PackRepository repository) {
        boolean changed;
        ArrayList previous = new ArrayList(options.f_92117_);
        ArrayList previousIncompatible = new ArrayList(options.f_92118_);
        options.f_92117_.clear();
        options.f_92118_.clear();
        for (Pack selected : repository.m_10524_()) {
            if (selected.m_10450_()) continue;
            options.f_92117_.add(selected.m_10446_());
            if (selected.m_10443_().m_10489_()) continue;
            options.f_92118_.add(selected.m_10446_());
        }
        boolean bl = changed = !previous.equals(options.f_92117_) || !previousIncompatible.equals(options.f_92118_);
        if (changed) {
            options.m_92169_();
        }
    }

    private void updateHighContrastOption(@NotNull Minecraft minecraft, @NotNull PackRepository repository) {
        boolean highContrastEnabled = false;
        for (Pack selected : repository.m_10524_()) {
            if (!"high_contrast".equals(selected.m_10446_())) continue;
            highContrastEnabled = true;
            break;
        }
        minecraft.f_91066_.m_274330_().m_231514_((Object)highContrastEnabled);
    }

    @Nullable
    private Pack findPack(@NotNull PackRepository repository, @NotNull String search) {
        String trimmed = search.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        for (Pack pack : repository.m_10524_()) {
            if (!this.matchesPack(pack, trimmed)) continue;
            return pack;
        }
        for (Pack pack : repository.m_10519_()) {
            if (!this.matchesPack(pack, trimmed)) continue;
            return pack;
        }
        return null;
    }

    private boolean matchesPack(@NotNull Pack pack, @NotNull String search) {
        String title = pack.m_10429_().getString();
        if (title.equalsIgnoreCase(search)) {
            return true;
        }
        return pack.m_10446_().equalsIgnoreCase(search);
    }

    protected static class ResourcePackConfig {
        @NotNull
        protected String packName = "";
        @NotNull
        protected ResourcePackMode mode = ResourcePackMode.TOGGLE;
        protected boolean reloadOnChange = true;

        protected ResourcePackConfig() {
        }

        @NotNull
        public String serialize() {
            return ResourcePackConfig.sanitize(this.packName) + ManageResourcePackAction.VALUE_SEPARATOR + this.mode.getName() + ManageResourcePackAction.VALUE_SEPARATOR + this.reloadOnChange;
        }

        @Nullable
        public static ResourcePackConfig parse(@NotNull String value) {
            ResourcePackConfig config = new ResourcePackConfig();
            String[] parts = value.split("\\|\\|\\|", -1);
            if (parts.length >= 1) {
                config.packName = parts[0];
            }
            if (parts.length >= 2) {
                config.mode = ResourcePackMode.byName(parts[1]);
            }
            if (parts.length >= 3) {
                config.reloadOnChange = Boolean.parseBoolean(parts[2]);
            }
            return config;
        }

        @NotNull
        private static String sanitize(@NotNull String input) {
            return input.replace(ManageResourcePackAction.VALUE_SEPARATOR, "").trim();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ResourcePackMode implements LocalizedEnum<ResourcePackMode>
    {
        ENABLE("enable", (Supplier)LocalizedEnum.SUCCESS_TEXT_STYLE){

            @Override
            boolean apply(@NotNull List<Pack> selection, @NotNull Pack pack) {
                if (selection.contains(pack)) {
                    return false;
                }
                pack.m_10451_().m_10470_(selection, (Object)pack, Function.identity(), false);
                return true;
            }
        }
        ,
        DISABLE("disable", (Supplier)LocalizedEnum.ERROR_TEXT_STYLE){

            @Override
            boolean apply(@NotNull List<Pack> selection, @NotNull Pack pack) {
                if (pack.m_10449_()) {
                    LOGGER.warn("[FANCYMENU] ManageResourcePackAction: Tried to disable required resource pack '{}'.", (Object)pack.m_10446_());
                    return false;
                }
                return selection.remove(pack);
            }
        }
        ,
        TOGGLE("toggle", (Supplier)LocalizedEnum.WARNING_TEXT_STYLE){

            @Override
            boolean apply(@NotNull List<Pack> selection, @NotNull Pack pack) {
                if (selection.contains(pack)) {
                    return DISABLE.apply(selection, pack);
                }
                return ENABLE.apply(selection, pack);
            }
        };

        private final String name;
        private final Supplier<Style> styleSupplier;

        private ResourcePackMode(String name, Supplier<Style> styleSupplier) {
            this.name = name;
            this.styleSupplier = styleSupplier;
        }

        abstract boolean apply(@NotNull List<Pack> var1, @NotNull Pack var2);

        @Override
        @NotNull
        public String getLocalizationKeyBase() {
            return "fancymenu.actions.manage_resource_pack.mode";
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public ResourcePackMode[] getValues() {
            return ResourcePackMode.values();
        }

        @Override
        @Nullable
        public ResourcePackMode getByNameInternal(@NotNull String name) {
            return ResourcePackMode.byName(name);
        }

        @Override
        @NotNull
        public Style getValueComponentStyle() {
            return this.styleSupplier.get();
        }

        public static ResourcePackMode byName(@Nullable String name) {
            if (name != null) {
                for (ResourcePackMode mode : ResourcePackMode.values()) {
                    if (!mode.getName().equalsIgnoreCase(name)) continue;
                    return mode;
                }
            }
            return TOGGLE;
        }
    }

    public static class ManageResourcePackActionValueScreen
    extends StringBuilderScreen {
        protected ResourcePackConfig config;

        protected ManageResourcePackActionValueScreen(@NotNull String value, @NotNull Consumer<String> callback) {
            super((Component)Component.m_237115_((String)"fancymenu.actions.manage_resource_pack.edit_value"), callback);
            this.config = ResourcePackConfig.parse(value);
            if (this.config == null) {
                this.config = new ResourcePackConfig();
            }
        }

        @Override
        protected void initCells() {
            this.addStartEndSpacerCell();
            this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.actions.manage_resource_pack.edit.pack_name"));
            CellScreen.TextInputCell nameCell = this.addTextInputCell(null, true, true).setEditListener(text -> {
                this.config.packName = text;
            }).setText(this.config.packName);
            nameCell.editBox.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"fancymenu.actions.manage_resource_pack.edit.pack_name.desc")));
            this.addCellGroupEndSpacerCell();
            this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.actions.manage_resource_pack.edit.mode.label"));
            LocalizedEnumValueCycle modeCycle = LocalizedEnumValueCycle.ofArray((String)"fancymenu.actions.manage_resource_pack.edit.mode", (LocalizedEnum[])ResourcePackMode.values());
            modeCycle.setCurrentValue(this.config.mode, false);
            CycleButton<ResourcePackMode> modeButton = new CycleButton<ResourcePackMode>(0, 0, 20, 20, modeCycle, (selectedMode, button) -> {
                this.config.mode = selectedMode;
            });
            modeButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"fancymenu.actions.manage_resource_pack.edit.mode.desc")));
            modeButton.setSelectedValue(this.config.mode);
            this.addWidgetCell((AbstractWidget)modeButton, true);
            this.addCellGroupEndSpacerCell();
            this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.actions.manage_resource_pack.edit.reload.label"));
            CycleButton<CommonCycles.CycleEnabledDisabled> reloadButton = new CycleButton<CommonCycles.CycleEnabledDisabled>(0, 0, 20, 20, CommonCycles.cycleEnabledDisabled("fancymenu.actions.manage_resource_pack.edit.reload", this.config.reloadOnChange), (state, button) -> {
                this.config.reloadOnChange = state.getAsBoolean();
            });
            reloadButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"fancymenu.actions.manage_resource_pack.edit.reload.desc")));
            reloadButton.setSelectedValue(CommonCycles.CycleEnabledDisabled.getByBoolean(this.config.reloadOnChange));
            this.addWidgetCell((AbstractWidget)reloadButton, true);
            this.addStartEndSpacerCell();
        }

        @Override
        public boolean allowDone() {
            return !this.config.packName.trim().isEmpty();
        }

        @Override
        @NotNull
        public String buildString() {
            this.config.packName = this.config.packName.trim();
            return this.config.serialize();
        }
    }
}

