/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.advanced;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.file.DotMinecraftUtils;
import de.keksuccino.fancymenu.util.resource.ResourceSource;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSizePlaceholder
extends Placeholder {
    private static final Logger LOGGER = LogManager.getLogger();

    public FileSizePlaceholder() {
        super("file_size");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        String filePath = dps.values.get("path");
        if (filePath == null || filePath.isEmpty()) {
            LOGGER.warn("[FANCYMENU] File Size placeholder: No path provided");
            return "0";
        }
        if (filePath.startsWith("http://") || filePath.startsWith("https://")) {
            LOGGER.warn("[FANCYMENU] File Size placeholder: URLs are not supported, only local files");
            return "0";
        }
        try {
            Path path;
            filePath = DotMinecraftUtils.resolveMinecraftPath(filePath);
            if (!DotMinecraftUtils.isInsideMinecraftDirectory(filePath)) {
                filePath = ResourceSource.of(filePath).getSourceWithoutPrefix();
            }
            if (!Files.exists(path = Paths.get(filePath, new String[0]), new LinkOption[0])) {
                LOGGER.warn("[FANCYMENU] File Size placeholder: File not found: " + filePath);
                return "0";
            }
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                LOGGER.warn("[FANCYMENU] File Size placeholder: Path is not a regular file: " + filePath);
                return "0";
            }
            long sizeInBytes = Files.size(path);
            return String.valueOf(sizeInBytes);
        }
        catch (Exception e) {
            LOGGER.error("[FANCYMENU] File Size placeholder: Failed to get file size for: " + filePath, (Throwable)e);
            return "0";
        }
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("path");
        return l;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.m_118938_((String)"fancymenu.placeholders.file_size", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.file_size.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.m_118938_((String)"fancymenu.requirements.categories.advanced", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("path", "/config/fancymenu/config.txt");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}

