/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.gui;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementPosYPlaceholder
extends Placeholder {
    private static final Logger LOGGER = LogManager.getLogger();

    public ElementPosYPlaceholder() {
        super("elementposy");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        if (Minecraft.m_91087_().f_91080_ == null) {
            return "1";
        }
        String id = dps.values.get("id");
        if (id != null) {
            AbstractElement element = this.findElement(id);
            if (element != null) {
                return "" + element.getAbsoluteY();
            }
            LOGGER.error("[FANCYMENU] Unable to get Y-position of element via placeholder! Element not found: " + id);
        }
        return "1";
    }

    private AbstractElement findElement(String id) {
        if (Minecraft.m_91087_().f_91080_ != null) {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (!(screen instanceof LayoutEditorScreen)) {
                ScreenCustomizationLayer mh = ScreenCustomizationLayerHandler.getLayerOfScreen(Minecraft.m_91087_().f_91080_);
                if (mh != null) {
                    return mh.getElementByInstanceIdentifier(id);
                }
            } else {
                LayoutEditorScreen editor = (LayoutEditorScreen)screen;
                AbstractEditorElement e = editor.getElementByInstanceIdentifier(id);
                if (e != null) {
                    return e.element;
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("id");
        return l;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.m_118938_((String)"fancymenu.placeholders.element_posy", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.element_posy.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.m_118938_((String)"fancymenu.requirements.categories.gui", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        DeserializedPlaceholderString dps = new DeserializedPlaceholderString();
        dps.placeholderIdentifier = this.getIdentifier();
        dps.values.put("id", "some.element.id");
        return dps;
    }
}

