/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.file;

import de.keksuccino.fancymenu.util.OSUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DotMinecraftUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    @NotNull
    public static Path getMinecraftDirectory() {
        String appData;
        String userHome = System.getProperty("user.home");
        Path minecraftPath = OSUtils.isWindows() ? ((appData = System.getenv("APPDATA")) != null ? Paths.get(appData, ".minecraft") : Paths.get(userHome, "AppData", "Roaming", ".minecraft")) : (OSUtils.isMacOS() ? Paths.get(userHome, "Library", "Application Support", "minecraft") : (OSUtils.isLinux() ? Paths.get(userHome, ".minecraft") : Paths.get(userHome, ".minecraft")));
        if (!Files.exists(minecraftPath, new LinkOption[0])) {
            try {
                Files.createDirectories(minecraftPath, new FileAttribute[0]);
            }
            catch (IOException | SecurityException ex) {
                LOGGER.error("[FANCYMENU] Failed to create .minecraft directory at: " + minecraftPath, (Throwable)ex);
            }
        }
        return minecraftPath;
    }

    @NotNull
    public static File getMinecraftDirectoryAsFile() {
        return DotMinecraftUtils.getMinecraftDirectory().toFile();
    }

    public static boolean isInsideMinecraftDirectory(@Nullable Path path) {
        if (path == null) {
            return false;
        }
        try {
            Path minecraftDir = DotMinecraftUtils.getMinecraftDirectory().toAbsolutePath().normalize();
            Path targetPath = path.toAbsolutePath().normalize();
            return targetPath.startsWith(minecraftDir);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isInsideMinecraftDirectory(@Nullable File file) {
        if (file == null) {
            return false;
        }
        return DotMinecraftUtils.isInsideMinecraftDirectory(file.toPath());
    }

    public static boolean isInsideMinecraftDirectory(@Nullable String pathString) {
        if (pathString == null || pathString.isEmpty()) {
            return false;
        }
        try {
            return DotMinecraftUtils.isInsideMinecraftDirectory(Paths.get(pathString, new String[0]));
        }
        catch (Exception e) {
            return false;
        }
    }

    @NotNull
    public static Path resolveMinecraftPath(@NotNull Path path) {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        String pathStr = path.toString().replace('\\', '/');
        if (DotMinecraftUtils.isShortenedDotMinecraftPath(pathStr)) {
            Path minecraftDir = DotMinecraftUtils.getMinecraftDirectory();
            if (pathStr.equals(".minecraft")) {
                return minecraftDir;
            }
            String relativePart = pathStr.substring(".minecraft/".length());
            return minecraftDir.resolve(relativePart);
        }
        return path;
    }

    @NotNull
    public static File resolveMinecraftPath(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        return DotMinecraftUtils.resolveMinecraftPath(file.toPath()).toFile();
    }

    @NotNull
    public static String resolveMinecraftPath(@NotNull String pathString) {
        if (pathString == null) {
            throw new IllegalArgumentException("Path string cannot be null");
        }
        try {
            Path resolved = DotMinecraftUtils.resolveMinecraftPath(Paths.get(pathString, new String[0]));
            return resolved.toString();
        }
        catch (Exception e) {
            String normalizedPath = pathString.replace('\\', '/');
            if (DotMinecraftUtils.isShortenedDotMinecraftPath(normalizedPath)) {
                Path minecraftDir = DotMinecraftUtils.getMinecraftDirectory();
                if (normalizedPath.equals(".minecraft")) {
                    return minecraftDir.toString();
                }
                String relativePart = normalizedPath.substring(".minecraft/".length());
                try {
                    return minecraftDir.resolve(relativePart).toString();
                }
                catch (Exception ex2) {
                    return pathString;
                }
            }
            return pathString;
        }
    }

    public static boolean isShortenedDotMinecraftPath(@NotNull String path) {
        return (path = path.trim()).startsWith(".minecraft/") || path.equals(".minecraft");
    }

    @Nullable
    public static String convertToShortenedDotMinecraftPath(@NotNull String path) {
        if (DotMinecraftUtils.isShortenedDotMinecraftPath(path)) {
            return path.trim();
        }
        String dotMcDir = DotMinecraftUtils.getMinecraftDirectoryAsFile().getAbsolutePath().replace("\\", "/");
        File pathFile = new File(path = path.trim());
        String absolutePath = pathFile.getAbsolutePath().replace("\\", "/");
        if (!absolutePath.startsWith(dotMcDir)) {
            return null;
        }
        return absolutePath.replace(dotMcDir, ".minecraft/");
    }
}

