/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.mcef;

import com.cinemamod.mcef.MCEF;
import de.keksuccino.fancymenu.util.Pair;
import de.keksuccino.fancymenu.util.mcef.ActionBridge;
import de.keksuccino.fancymenu.util.mcef.MCEFUtil;
import de.keksuccino.fancymenu.util.mcef.WrappedMCEFBrowser;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import de.keksuccino.melody.resources.audio.MinecraftSoundSettingsObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.sounds.SoundSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowserHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final HashMap<String, Pair<WrappedMCEFBrowser, Long>> BROWSERS = new HashMap();
    private static boolean is_initializing = false;
    public static boolean initialized = false;

    public static void init() {
        if (initialized) {
            return;
        }
        if (is_initializing) {
            return;
        }
        is_initializing = true;
        LOGGER.info("[FANCYMENU] Starting initialization of BrowserHandler..");
        if (!MCEF.isInitialized()) {
            LOGGER.warn("[FANCYMENU] MCEF not initialized yet! Will wait for MCEF to be ready before initializing BrowserHandler!");
        }
        new Thread(() -> {
            try {
                while (!MCEFUtil.MCEF_initialized) {
                    if (MCEF.isInitialized()) {
                        MCEFUtil.MCEF_initialized = true;
                        MainThreadTaskExecutor.executeInMainThread(() -> {
                            try {
                                ActionBridge.initialize();
                                MinecraftSoundSettingsObserver.registerVolumeListener(BrowserHandler::onVolumeUpdated);
                                initialized = true;
                                LOGGER.info("[FANCYMENU] BrowserHandler successfully initialized!");
                            }
                            catch (Exception ex) {
                                LOGGER.error("[FANCYMENU] Failed to initialize BrowserHandler!", (Throwable)ex);
                            }
                        }, MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
                        break;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to initialize BrowserHandler!", (Throwable)ex);
            }
        }).start();
    }

    public static void notifyHandler(@NotNull String identifier, @NotNull WrappedMCEFBrowser browser) {
        if (!BROWSERS.containsKey(identifier)) {
            BROWSERS.put(identifier, Pair.of(browser, System.currentTimeMillis()));
        }
        BROWSERS.get(identifier).setValue(System.currentTimeMillis());
    }

    @Nullable
    public static WrappedMCEFBrowser get(@NotNull String identifier) {
        Pair<WrappedMCEFBrowser, Long> browser = BROWSERS.get(identifier);
        if (browser != null) {
            return browser.getKey();
        }
        return null;
    }

    public static void remove(@NotNull String identifier, boolean close) {
        try {
            Pair<WrappedMCEFBrowser, Long> browser;
            if (close && (browser = BROWSERS.get(identifier)) != null) {
                browser.getKey().close();
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to force-close MCEFBrowser!", (Throwable)ex);
        }
        BROWSERS.remove(identifier);
    }

    public static void tick() {
        long now = System.currentTimeMillis();
        ArrayList<String> garbageCollect = new ArrayList<String>();
        for (Map.Entry<String, Pair<WrappedMCEFBrowser, Long>> m : BROWSERS.entrySet()) {
            if (m.getValue().getValue() + 5000L >= now) continue;
            garbageCollect.add(m.getKey());
        }
        garbageCollect.forEach(s -> {
            try {
                Pair<WrappedMCEFBrowser, Long> browser = BROWSERS.get(s);
                if (browser != null) {
                    browser.getKey().close();
                }
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to force-close MCEFBrowser!", (Throwable)ex);
            }
            BROWSERS.remove(s);
        });
    }

    public static void mouseMoved(double mouseX, double mouseY) {
        BROWSERS.forEach((id, browser) -> ((WrappedMCEFBrowser)browser.getKey()).m_94757_(mouseX, mouseY));
    }

    public static void onVolumeUpdated(SoundSource soundSource, float newVolume) {
        BROWSERS.forEach((s, wrappedMCEFBrowserLongPair) -> ((WrappedMCEFBrowser)wrappedMCEFBrowserLongPair.getKey()).onVolumeUpdated(soundSource, newVolume));
    }
}

