/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.CachedRecipeHelper;
import mekanism.api.recipes.chemical.ChemicalChemicalToChemicalRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ChemicalChemicalToChemicalCachedRecipe<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK>, RECIPE extends ChemicalChemicalToChemicalRecipe<CHEMICAL, STACK, INGREDIENT>>
extends CachedRecipe<RECIPE> {
    private final IOutputHandler<@NotNull STACK> outputHandler;
    private final IInputHandler<@NotNull STACK> leftInputHandler;
    private final IInputHandler<@NotNull STACK> rightInputHandler;
    @Nullable
    private STACK leftRecipeInput;
    @Nullable
    private STACK rightRecipeInput;
    @Nullable
    private STACK output;

    public ChemicalChemicalToChemicalCachedRecipe(RECIPE recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NotNull STACK> leftInputHandler, IInputHandler<@NotNull STACK> rightInputHandler, IOutputHandler<@NotNull STACK> outputHandler) {
        super(recipe, recheckAllErrors);
        this.leftInputHandler = Objects.requireNonNull(leftInputHandler, "Left input handler cannot be null.");
        this.rightInputHandler = Objects.requireNonNull(rightInputHandler, "Right input handler cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Output handler cannot be null.");
    }

    @Override
    protected void calculateOperationsThisTick(CachedRecipe.OperationTracker tracker) {
        super.calculateOperationsThisTick(tracker);
        if (tracker.shouldContinueChecking()) {
            ChemicalStack leftInputChemical = (ChemicalStack)this.leftInputHandler.getInput();
            if (leftInputChemical.isEmpty()) {
                tracker.mismatchedRecipe();
            } else {
                ChemicalStack rightInputChemical = (ChemicalStack)this.rightInputHandler.getInput();
                if (rightInputChemical.isEmpty()) {
                    tracker.mismatchedRecipe();
                } else {
                    Supplier<ChemicalStackIngredient> rightIngredient;
                    Supplier<ChemicalStackIngredient> leftIngredient;
                    Object leftInput = ((ChemicalChemicalToChemicalRecipe)this.recipe).getLeftInput();
                    Object rightInput = ((ChemicalChemicalToChemicalRecipe)this.recipe).getRightInput();
                    if (!leftInput.test((ChemicalStack)leftInputChemical) || !rightInput.test((ChemicalStack)rightInputChemical)) {
                        leftIngredient = () -> rightInput;
                        rightIngredient = () -> leftInput;
                    } else {
                        leftIngredient = () -> leftInput;
                        rightIngredient = () -> rightInput;
                    }
                    CachedRecipeHelper.twoInputCalculateOperationsThisTick(tracker, this.leftInputHandler, leftIngredient, this.rightInputHandler, rightIngredient, (left, right) -> {
                        this.leftRecipeInput = left;
                        this.rightRecipeInput = right;
                    }, this.outputHandler, ((ChemicalChemicalToChemicalRecipe)this.recipe)::getOutput, output -> {
                        this.output = output;
                    }, ChemicalStack::isEmpty, ChemicalStack::isEmpty);
                }
            }
        }
    }

    @Override
    public boolean isInputValid() {
        ChemicalStack leftInput = (ChemicalStack)this.leftInputHandler.getInput();
        if (leftInput.isEmpty()) {
            return false;
        }
        ChemicalStack rightInput = (ChemicalStack)this.rightInputHandler.getInput();
        return !rightInput.isEmpty() && ((ChemicalChemicalToChemicalRecipe)this.recipe).test(leftInput, rightInput);
    }

    @Override
    protected void finishProcessing(int operations) {
        if (!(this.leftRecipeInput == null || this.rightRecipeInput == null || this.output == null || ((ChemicalStack)this.leftRecipeInput).isEmpty() || ((ChemicalStack)this.rightRecipeInput).isEmpty() || ((ChemicalStack)this.output).isEmpty())) {
            this.leftInputHandler.use(this.leftRecipeInput, operations);
            this.rightInputHandler.use(this.rightRecipeInput, operations);
            this.outputHandler.handleOutput(this.output, operations);
        }
    }
}

