/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.energy;

import java.util.Objects;
import java.util.function.Predicate;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.math.FloatingLong;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeEnergy;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.MekanismUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class MachineEnergyContainer<TILE extends TileEntityMekanism>
extends BasicEnergyContainer {
    protected final TILE tile;
    private final FloatingLong baseEnergyPerTick;
    private FloatingLong currentMaxEnergy;
    protected FloatingLong currentEnergyPerTick;

    public static <TILE extends TileEntityMekanism> MachineEnergyContainer<TILE> input(TILE tile, @Nullable IContentsListener listener) {
        AttributeEnergy electricBlock = MachineEnergyContainer.validateBlock(tile);
        return new MachineEnergyContainer<TILE>(electricBlock.getStorage(), electricBlock.getUsage(), notExternal, alwaysTrue, tile, listener);
    }

    public static <TILE extends TileEntityMekanism> MachineEnergyContainer<TILE> internal(TILE tile, @Nullable IContentsListener listener) {
        AttributeEnergy electricBlock = MachineEnergyContainer.validateBlock(tile);
        return new MachineEnergyContainer<TILE>(electricBlock.getStorage(), electricBlock.getUsage(), internalOnly, internalOnly, tile, listener);
    }

    public static AttributeEnergy validateBlock(TileEntityMekanism tile) {
        Objects.requireNonNull(tile, "Tile cannot be null");
        AttributeEnergy attributeEnergy = Attribute.get(tile.getBlockType(), AttributeEnergy.class);
        if (attributeEnergy == null) {
            throw new IllegalArgumentException("Block provider must be an electric block");
        }
        return attributeEnergy;
    }

    protected MachineEnergyContainer(FloatingLong maxEnergy, FloatingLong energyPerTick, Predicate<@NotNull AutomationType> canExtract, Predicate<@NotNull AutomationType> canInsert, TILE tile, @Nullable IContentsListener listener) {
        super(maxEnergy, canExtract, canInsert, listener);
        this.baseEnergyPerTick = energyPerTick.copyAsConst();
        this.tile = tile;
        this.currentMaxEnergy = this.getBaseMaxEnergy();
        this.currentEnergyPerTick = this.baseEnergyPerTick;
    }

    public boolean adjustableRates() {
        return false;
    }

    @Override
    public FloatingLong getMaxEnergy() {
        return this.currentMaxEnergy;
    }

    public FloatingLong getBaseMaxEnergy() {
        return super.getMaxEnergy();
    }

    public void setMaxEnergy(FloatingLong maxEnergy) {
        Objects.requireNonNull(maxEnergy, "Max energy cannot be null");
        this.currentMaxEnergy = maxEnergy;
        if (this.getEnergy().greaterThan(this.getMaxEnergy())) {
            this.setEnergy(this.getMaxEnergy());
        }
    }

    public FloatingLong getEnergyPerTick() {
        return this.currentEnergyPerTick;
    }

    public FloatingLong getBaseEnergyPerTick() {
        return this.baseEnergyPerTick;
    }

    public void setEnergyPerTick(FloatingLong energyPerTick) {
        Objects.requireNonNull(energyPerTick, "Energy per tick cannot be null");
        this.currentEnergyPerTick = energyPerTick;
    }

    public void updateMaxEnergy() {
        if (this.tile.supportsUpgrade(Upgrade.ENERGY)) {
            this.setMaxEnergy(MekanismUtils.getMaxEnergy(this.tile, this.getBaseMaxEnergy()));
        }
    }

    public void updateEnergyPerTick() {
        TileComponentUpgrade upgradeComponent;
        if (((TileEntityMekanism)this.tile).supportsUpgrades() && ((upgradeComponent = ((TileEntityMekanism)this.tile).getComponent()).supports(Upgrade.ENERGY) || upgradeComponent.supports(Upgrade.SPEED))) {
            this.setEnergyPerTick(MekanismUtils.getEnergyPerTick(this.tile, this.getBaseEnergyPerTick()));
        }
    }
}

