/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.gender;

import com.wildfire.api.IGenderArmor;
import java.util.function.Consumer;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;

public final class MekanismGenderArmor
extends ItemCapabilityWrapper.ItemCapability
implements IGenderArmor {
    private static final Capability<IGenderArmor> GENDER_ARMOR_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IGenderArmor>(){});
    public static final MekanismGenderArmor OPEN_FRONT = new MekanismGenderArmor(false, false, 0.0f, 0.0f);
    public static final MekanismGenderArmor HIDES_BREASTS = new MekanismGenderArmor(true, true, 0.0f, 0.0f);
    static final MekanismGenderArmor HAZMAT = new MekanismGenderArmor(0.5f, 0.25f);
    private final boolean coversBreasts;
    private final boolean alwaysHidesBreasts;
    private final float physicsResistance;
    private final float tightness;

    public MekanismGenderArmor(float physicsResistance) {
        this(physicsResistance, 0.0f);
    }

    public MekanismGenderArmor(float physicsResistance, float tightness) {
        this(true, false, physicsResistance, tightness);
    }

    private MekanismGenderArmor(boolean coversBreasts, boolean alwaysHidesBreasts, float physicsResistance, float tightness) {
        if (physicsResistance < 0.0f || physicsResistance > 1.0f) {
            throw new IllegalArgumentException("Physics resistance must be between zero and one inclusive.");
        }
        if (tightness < 0.0f || tightness > 1.0f) {
            throw new IllegalArgumentException("Armor tightness must be between zero and one inclusive.");
        }
        this.coversBreasts = coversBreasts;
        this.alwaysHidesBreasts = alwaysHidesBreasts;
        this.physicsResistance = physicsResistance;
        this.tightness = tightness;
    }

    public boolean coversBreasts() {
        return this.coversBreasts;
    }

    public boolean alwaysHidesBreasts() {
        return this.alwaysHidesBreasts;
    }

    public float physicsResistance() {
        return this.physicsResistance;
    }

    public float tightness() {
        return this.tightness;
    }

    @Override
    protected void gatherCapabilityResolvers(Consumer<ICapabilityResolver> consumer) {
        consumer.accept(BasicCapabilityResolver.constant(GENDER_ARMOR_CAPABILITY, this));
    }
}

